/*
 * Decompiled with CFR 0.152.
 */
package socks.server;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.net.ConnectException;
import java.net.Socket;
import java.util.StringTokenizer;

public class Ident {
    public String errorMessage;
    public String hostType;
    public String userName;
    public boolean successful;
    public int errorCode;
    public static final int ERR_NO_CONNECT = 1;
    public static final int ERR_TIMEOUT = 2;
    public static final int ERR_PROTOCOL = 3;
    public static final int ERR_PROTOCOL_INCORRECT = 4;
    public static final int connectionTimeout = 10000;

    /*
     * Loose catch block
     */
    public Ident(Socket s) {
        Socket sock = null;
        this.successful = false;
        try {
            try {
                sock = new Socket(s.getInetAddress(), 113);
                sock.setSoTimeout(10000);
                byte[] request = (s.getPort() + " , " + s.getLocalPort() + "\r\n").getBytes();
                sock.getOutputStream().write(request);
                BufferedReader in = new BufferedReader(new InputStreamReader(sock.getInputStream()));
                this.parseResponse(in.readLine());
            }
            catch (InterruptedIOException iioe) {
                this.errorCode = 2;
                this.errorMessage = "Connection to identd timed out.";
                try {
                    if (sock != null) {
                        sock.close();
                    }
                }
                catch (IOException iOException) {}
            }
            catch (ConnectException ce) {
                this.errorCode = 1;
                this.errorMessage = "Connection to identd server failed.";
                try {
                    if (sock != null) {
                        sock.close();
                    }
                }
                catch (IOException iOException) {}
            }
            catch (IOException ioe) {
                this.errorCode = 1;
                this.errorMessage = "" + ioe;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                try {
                    if (sock != null) {
                        sock.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            try {
                if (sock != null) {
                    sock.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private void parseResponse(String response) {
        if (response == null) {
            this.errorCode = 4;
            this.errorMessage = "Identd server closed connection.";
            return;
        }
        StringTokenizer st = new StringTokenizer(response, ":");
        if (st.countTokens() < 3) {
            this.errorCode = 4;
            this.errorMessage = "Can't parse server response.";
            return;
        }
        st.nextToken();
        String command = st.nextToken().trim().toUpperCase();
        if (command.equals("USERID") && st.countTokens() >= 2) {
            this.successful = true;
            this.hostType = st.nextToken().trim();
            this.userName = st.nextToken("").substring(1);
        } else if (command.equals("ERROR")) {
            this.errorCode = 3;
            this.errorMessage = st.nextToken();
        } else {
            this.errorCode = 4;
            System.out.println("Opa!");
            this.errorMessage = "Can't parse server response.";
        }
    }
}

