/*
 * Decompiled with CFR 0.152.
 */
package socks;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import socks.Authentication;

public class UserPasswordAuthentication
implements Authentication {
    public static final int METHOD_ID = 2;
    String userName;
    String password;
    byte[] request;

    public UserPasswordAuthentication(String userName, String password) {
        this.userName = userName;
        this.password = password;
        this.formRequest();
    }

    public String getUser() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }

    @Override
    public Object[] doSocksAuthentication(int methodId, Socket proxySocket) throws IOException {
        if (methodId != 2) {
            return null;
        }
        InputStream in = proxySocket.getInputStream();
        OutputStream out = proxySocket.getOutputStream();
        out.write(this.request);
        int version = in.read();
        if (version < 0) {
            return null;
        }
        int status = in.read();
        if (status != 0) {
            return null;
        }
        return new Object[]{in, out};
    }

    private void formRequest() {
        byte[] user_bytes = this.userName.getBytes();
        byte[] password_bytes = this.password.getBytes();
        this.request = new byte[3 + user_bytes.length + password_bytes.length];
        this.request[0] = 1;
        this.request[1] = (byte)user_bytes.length;
        System.arraycopy(user_bytes, 0, this.request, 2, user_bytes.length);
        this.request[2 + user_bytes.length] = (byte)password_bytes.length;
        System.arraycopy(password_bytes, 0, this.request, 3 + user_bytes.length, password_bytes.length);
    }
}

