/*
 * Decompiled with CFR 0.152.
 */
package socks;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import socks.CProxy;
import socks.ProxyMessage;
import socks.SocksException;
import socks.SocksSocket;

public class SocksServerSocket
extends ServerSocket {
    protected CProxy proxy;
    protected String localHost;
    protected InetAddress localIP;
    protected int localPort;
    boolean doing_direct = false;
    InetAddress remoteAddr;

    public SocksServerSocket(String host, int port) throws SocksException, UnknownHostException, IOException {
        this(CProxy.defaultProxy, host, port);
    }

    public SocksServerSocket(CProxy p, String host, int port) throws SocksException, UnknownHostException, IOException {
        super(0);
        if (p == null) {
            throw new SocksException(65536);
        }
        this.proxy = p.copy();
        if (this.proxy.isDirect(host)) {
            this.remoteAddr = InetAddress.getByName(host);
            this.proxy = null;
            this.doDirect();
        } else {
            this.processReply(this.proxy.bind(host, port));
        }
    }

    public SocksServerSocket(InetAddress ip, int port) throws SocksException, IOException {
        this(CProxy.defaultProxy, ip, port);
    }

    public SocksServerSocket(CProxy p, InetAddress ip, int port) throws SocksException, IOException {
        super(0);
        if (p == null) {
            throw new SocksException(65536);
        }
        this.proxy = p.copy();
        if (this.proxy.isDirect(ip)) {
            this.remoteAddr = ip;
            this.doDirect();
        } else {
            this.processReply(this.proxy.bind(ip, port));
        }
    }

    @Override
    public Socket accept() throws IOException {
        Socket s;
        if (!this.doing_direct) {
            if (this.proxy == null) {
                return null;
            }
            ProxyMessage msg = this.proxy.accept();
            s = msg.ip == null ? new SocksSocket(msg.host, msg.port, this.proxy) : new SocksSocket(msg.ip, msg.port, this.proxy);
            this.proxy.proxySocket.setSoTimeout(0);
        } else {
            while (!(s = super.accept()).getInetAddress().equals(this.remoteAddr)) {
                s.close();
            }
        }
        this.proxy = null;
        return s;
    }

    @Override
    public void close() throws IOException {
        super.close();
        if (this.proxy != null) {
            this.proxy.endSession();
        }
        this.proxy = null;
    }

    public String getHost() {
        return this.localHost;
    }

    @Override
    public InetAddress getInetAddress() {
        if (this.localIP == null) {
            try {
                this.localIP = InetAddress.getByName(this.localHost);
            }
            catch (UnknownHostException e) {
                return null;
            }
        }
        return this.localIP;
    }

    @Override
    public int getLocalPort() {
        return this.localPort;
    }

    @Override
    public void setSoTimeout(int timeout) throws SocketException {
        super.setSoTimeout(timeout);
        if (!this.doing_direct) {
            this.proxy.proxySocket.setSoTimeout(timeout);
        }
    }

    private void processReply(ProxyMessage reply) throws SocksException {
        this.localPort = reply.port;
        if (reply.host.equals("0.0.0.0")) {
            this.localIP = this.proxy.proxyIP;
            this.localHost = this.localIP.getHostName();
        } else {
            this.localHost = reply.host;
            this.localIP = reply.ip;
        }
    }

    private void doDirect() {
        this.doing_direct = true;
        this.localPort = super.getLocalPort();
        this.localIP = super.getInetAddress();
        this.localHost = this.localIP.getHostName();
    }
}

