/*
 * Decompiled with CFR 0.152.
 */
package socks;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import socks.ProxyMessage;
import socks.SocksException;

class Socks4Message
extends ProxyMessage {
    private byte[] msgBytes;
    private int msgLength;
    static final String[] replyMessage = new String[]{"Request Granted", "Request Rejected or Failed", "Failed request, can't connect to Identd", "Failed request, bad user name"};
    static final int SOCKS_VERSION = 4;
    public static final int REQUEST_CONNECT = 1;
    public static final int REQUEST_BIND = 2;
    public static final int REPLY_OK = 90;
    public static final int REPLY_REJECTED = 91;
    public static final int REPLY_NO_CONNECT = 92;
    public static final int REPLY_BAD_IDENTD = 93;

    public Socks4Message(int cmd) {
        super(cmd, null, 0);
        this.user = null;
        this.msgLength = 2;
        this.msgBytes = new byte[2];
        this.msgBytes[0] = 0;
        this.msgBytes[1] = (byte)this.command;
    }

    public Socks4Message(int cmd, InetAddress ip, int port) {
        this(0, cmd, ip, port, null);
    }

    public Socks4Message(int cmd, InetAddress ip, int port, String user) {
        this(4, cmd, ip, port, user);
    }

    public Socks4Message(int version, int cmd, InetAddress ip, int port, String user) {
        super(cmd, ip, port);
        byte[] addr;
        this.user = user;
        this.version = version;
        this.msgLength = user == null ? 8 : 9 + user.length();
        this.msgBytes = new byte[this.msgLength];
        this.msgBytes[0] = (byte)version;
        this.msgBytes[1] = (byte)this.command;
        this.msgBytes[2] = (byte)(port >> 8);
        this.msgBytes[3] = (byte)port;
        if (ip != null) {
            addr = ip.getAddress();
        } else {
            addr = new byte[4];
            addr[3] = 0;
            addr[2] = 0;
            addr[1] = 0;
            addr[0] = 0;
        }
        System.arraycopy(addr, 0, this.msgBytes, 4, 4);
        if (user != null) {
            byte[] buf = user.getBytes();
            System.arraycopy(buf, 0, this.msgBytes, 8, buf.length);
            this.msgBytes[this.msgBytes.length - 1] = 0;
        }
    }

    public Socks4Message(InputStream in, boolean clientMode) throws IOException {
        this.msgBytes = null;
        this.read(in, clientMode);
    }

    @Override
    public void read(InputStream in) throws IOException {
        this.read(in, true);
    }

    @Override
    public void read(InputStream in, boolean clientMode) throws IOException {
        DataInputStream d_in = new DataInputStream(in);
        this.version = d_in.readUnsignedByte();
        this.command = d_in.readUnsignedByte();
        if (clientMode && this.command != 90) {
            String errMsg = this.command > 90 && this.command < 93 ? replyMessage[this.command - 90] : "Unknown Reply Code";
            throw new SocksException(this.command, errMsg);
        }
        this.port = d_in.readUnsignedShort();
        byte[] addr = new byte[4];
        d_in.readFully(addr);
        this.ip = Socks4Message.bytes2IP(addr);
        this.host = this.ip.getHostName();
        if (!clientMode) {
            int b = in.read();
            byte[] userBytes = new byte[256];
            int i = 0;
            i = 0;
            while (i < userBytes.length && b > 0) {
                userBytes[i] = (byte)b;
                b = in.read();
                ++i;
            }
            this.user = new String(userBytes, 0, i);
        }
    }

    @Override
    public void write(OutputStream out) throws IOException {
        if (this.msgBytes == null) {
            Socks4Message msg = new Socks4Message(this.version, this.command, this.ip, this.port, this.user);
            this.msgBytes = msg.msgBytes;
            this.msgLength = msg.msgLength;
        }
        out.write(this.msgBytes);
    }

    static InetAddress bytes2IP(byte[] addr) {
        String s = Socks4Message.bytes2IPV4(addr, 0);
        try {
            return InetAddress.getByName(s);
        }
        catch (UnknownHostException uh_ex) {
            return null;
        }
    }
}

