/*
 * Decompiled with CFR 0.152.
 */
package socks;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import socks.InetRangeResolver;

public class InetRange
implements Cloneable {
    Hashtable host_names;
    Vector all = new Vector();
    Vector end_names;
    boolean useSeparateThread = true;

    public InetRange() {
        this.host_names = new Hashtable();
        this.end_names = new Vector();
    }

    public synchronized boolean add(String s) {
        if (s == null) {
            return false;
        }
        if ((s = s.trim()).length() == 0) {
            return false;
        }
        if (s.charAt(s.length() - 1) == '.') {
            int[] addr = InetRange.ip2intarray(s);
            long to = 0L;
            long from = 0L;
            if (addr == null) {
                return false;
            }
            int i = 0;
            while (i < 4) {
                if (addr[i] < 0) {
                    to = from;
                    while (i < 4) {
                        to += 255L << 8 * (3 - i++);
                    }
                    break;
                }
                from += (long)addr[i] << 8 * (3 - i);
                ++i;
            }
            Object[] objectArray = new Object[4];
            objectArray[0] = s;
            objectArray[2] = new Long(from);
            objectArray[3] = new Long(to);
            Object[] entry = objectArray;
            this.all.addElement(entry);
        } else if (s.charAt(0) == '.') {
            this.end_names.addElement(s);
            Object[] objectArray = new Object[4];
            objectArray[0] = s;
            this.all.addElement(objectArray);
        } else {
            StringTokenizer tokens = new StringTokenizer(s, " \t\r\n\f:");
            if (tokens.countTokens() > 1) {
                Object[] objectArray = new Object[4];
                objectArray[0] = s;
                Object[] entry = objectArray;
                this.resolve(entry, tokens.nextToken(), tokens.nextToken());
                this.all.addElement(entry);
            } else {
                Object[] objectArray = new Object[4];
                objectArray[0] = s;
                Object[] entry = objectArray;
                this.all.addElement(entry);
                this.host_names.put(s, entry);
                this.resolve(entry);
            }
        }
        return true;
    }

    public synchronized void add(InetAddress ip) {
        long to;
        long from = to = InetRange.ip2long(ip);
        this.all.addElement(new Object[]{ip.getHostName(), ip, new Long(from), new Long(to)});
    }

    public synchronized void add(InetAddress from, InetAddress to) {
        Object[] objectArray = new Object[4];
        objectArray[0] = String.valueOf(from.getHostAddress()) + ":" + to.getHostAddress();
        objectArray[2] = new Long(InetRange.ip2long(from));
        objectArray[3] = new Long(InetRange.ip2long(to));
        this.all.addElement(objectArray);
    }

    public synchronized boolean contains(String host) {
        return this.contains(host, true);
    }

    public synchronized boolean contains(String host, boolean attemptResolve) {
        if (this.all.size() == 0) {
            return false;
        }
        if ((host = host.trim()).length() == 0) {
            return false;
        }
        if (this.checkHost(host)) {
            return true;
        }
        if (this.checkHostEnding(host)) {
            return true;
        }
        long l = this.host2long(host);
        if (l >= 0L) {
            return this.contains(l);
        }
        if (!attemptResolve) {
            return false;
        }
        try {
            InetAddress ip = InetAddress.getByName(host);
            return this.contains(ip);
        }
        catch (UnknownHostException unknownHostException) {
            return false;
        }
    }

    public synchronized boolean contains(InetAddress ip) {
        if (this.checkHostEnding(ip.getHostName())) {
            return true;
        }
        if (this.checkHost(ip.getHostName())) {
            return true;
        }
        return this.contains(InetRange.ip2long(ip));
    }

    public synchronized String[] getAll() {
        int size = this.all.size();
        String[] all_names = new String[size];
        int i = 0;
        while (i < size) {
            Object[] entry = (Object[])this.all.elementAt(i);
            all_names[i] = (String)entry[0];
            ++i;
        }
        return all_names;
    }

    public synchronized boolean remove(String s) {
        Enumeration eEnum = this.all.elements();
        while (eEnum.hasMoreElements()) {
            Object[] entry = (Object[])eEnum.nextElement();
            if (!s.equals(entry[0])) continue;
            this.all.removeElement(entry);
            this.end_names.removeElement(s);
            this.host_names.remove(s);
            return true;
        }
        return false;
    }

    public String toString() {
        String[] all = this.getAll();
        if (all.length == 0) {
            return "";
        }
        String s = all[0];
        int i = 1;
        while (i < all.length) {
            s = String.valueOf(s) + "; " + all[i];
            ++i;
        }
        return s;
    }

    public Object clone() {
        InetRange new_range = new InetRange();
        new_range.all = (Vector)this.all.clone();
        new_range.end_names = (Vector)this.end_names.clone();
        new_range.host_names = (Hashtable)this.host_names.clone();
        return new_range;
    }

    private synchronized boolean contains(long ip) {
        Enumeration eEnum = this.all.elements();
        while (eEnum.hasMoreElements()) {
            Long to;
            Object[] obj = (Object[])eEnum.nextElement();
            Long from = obj[2] == null ? null : (Long)obj[2];
            Long l = to = obj[3] == null ? null : (Long)obj[3];
            if (from == null || from > ip || to < ip) continue;
            return true;
        }
        return false;
    }

    private boolean checkHost(String host) {
        return this.host_names.containsKey(host);
    }

    private boolean checkHostEnding(String host) {
        Enumeration eEnum = this.end_names.elements();
        while (eEnum.hasMoreElements()) {
            if (!host.endsWith((String)eEnum.nextElement())) continue;
            return true;
        }
        return false;
    }

    private void resolve(Object[] entry) {
        long ip = this.host2long((String)entry[0]);
        if (ip >= 0L) {
            entry[2] = entry[3] = new Long(ip);
        } else {
            InetRangeResolver res = new InetRangeResolver(entry);
            res.resolve(this.useSeparateThread);
        }
    }

    private void resolve(Object[] entry, String from, String to) {
        long t;
        long f = this.host2long(from);
        if (f >= 0L && (t = this.host2long(to)) >= 0L) {
            entry[2] = new Long(f);
            entry[3] = new Long(t);
        } else {
            InetRangeResolver res = new InetRangeResolver(entry, from, to);
            res.resolve(this.useSeparateThread);
        }
    }

    static long ip2long(InetAddress ip) {
        long l = 0L;
        byte[] addr = ip.getAddress();
        if (addr.length == 4) {
            int i = 0;
            while (i < 4) {
                l += ((long)addr[i] & 0xFFL) << 8 * (3 - i);
                ++i;
            }
        } else {
            return 0L;
        }
        return l;
    }

    long host2long(String host) {
        long ip = 0L;
        if (!Character.isDigit(host.charAt(0))) {
            return -1L;
        }
        int[] addr = InetRange.ip2intarray(host);
        if (addr == null) {
            return -1L;
        }
        int i = 0;
        while (i < addr.length) {
            ip += (long)(addr[i] >= 0 ? addr[i] : 0) << 8 * (3 - i);
            ++i;
        }
        return ip;
    }

    /*
     * Unable to fully structure code
     */
    static int[] ip2intarray(String host) {
        address = new int[]{-1, -1, -1, -1};
        i = 0;
        tokens = new StringTokenizer(host, ".");
        if (tokens.countTokens() <= 4) ** GOTO lbl11
        return null;
lbl-1000:
        // 1 sources

        {
            try {
                address[i++] = Integer.parseInt(tokens.nextToken()) & 255;
                continue;
            }
            catch (NumberFormatException nfe) {
                return null;
            }
lbl11:
            // 2 sources

            ** while (tokens.hasMoreTokens())
        }
lbl12:
        // 1 sources

        return address;
    }
}

