/*
 * Decompiled with CFR 0.152.
 */
package proxy;

import httptunnel.HttpTunnelConnection;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.text.SimpleDateFormat;
import java.util.Date;
import proxy.Transmitter;
import util.Logger;
import util.LoggerInterface;

public class Proxy
implements Runnable,
LoggerInterface {
    protected int retrySecs = 0;
    protected String serverHost = null;
    protected int serverPort = -1;
    protected Socket client = null;
    private Socket server = null;
    private boolean closed = false;
    private boolean MAINLOOP = false;
    private boolean ASYNC = false;
    private boolean stopped = false;
    private ServerSocket acceptSocket = null;
    private int acceptPort = -1;
    protected boolean localOnly = true;
    private boolean listenerStopped = false;
    private boolean starting = true;
    public static boolean debug = false;
    static SimpleDateFormat df = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");

    public Proxy() {
    }

    public Proxy(String host, int port, Socket clientSocket) {
        this.serverHost = host;
        this.serverPort = port;
        this.client = clientSocket;
    }

    public void close(Socket s) {
        try {
            s.close();
        }
        catch (IOException iOException) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public synchronized void cleanUp(int code, String transmitter) {
        if (this.closed) {
            return;
        }
        Logger.getLogger().logLine("Proxy: " + transmitter + " closed");
        this.close(this.server);
        this.close(this.client);
        this.closed = true;
    }

    public boolean go() {
        try {
            this.server = this.connectServer();
        }
        catch (Exception e) {
            Logger.getLogger().logLine("Proxy: Connection failed to " + this.serverHost + ", Port " + this.serverPort);
            Logger.getLogger().logLine(e.toString());
            return false;
        }
        Transmitter c = new Transmitter(this.client, this.server, this, "Client->Server");
        if (!c.start()) {
            this.close(this.server);
            return false;
        }
        Transmitter s = new Transmitter(this.server, this.client, this, "Server->Client");
        if (!s.start()) {
            this.close(this.server);
            return false;
        }
        return true;
    }

    public Socket connectServer() throws Exception {
        return new HttpTunnelConnection(this.serverHost, this.serverPort, true);
    }

    ServerSocket openListener(int port) throws Exception {
        InetAddress adr = null;
        if (this.localOnly) {
            adr = InetAddress.getByName("127.0.0.1");
        }
        return new ServerSocket(port, 0, adr);
    }

    public Proxy createProxy(String host, int port, Socket clientSocket) throws IOException {
        return new Proxy(host, port, clientSocket);
    }

    @Override
    public void run() {
        if (this.MAINLOOP) {
            this.runListenerLoop();
        } else if (!this.go()) {
            try {
                this.client.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void asyncInitMainLoop(String[] args) throws Exception {
        this.ASYNC = true;
        this.initMainLoop(args);
    }

    public void initMainLoop(String[] args) throws Exception {
        this.MAINLOOP = true;
        try {
            this.localOnly = !args[0].equalsIgnoreCase("LocalOnly=false");
            Logger.getLogger().logLine("Setting: " + args[0]);
            if (this.localOnly) {
                Logger.getLogger().logLine("Only localhost Connections to Proxy will be accepted");
            } else {
                Logger.getLogger().logLine("Remote Connections to Proxy will be accepted");
            }
            this.acceptPort = Integer.parseInt(args[1]);
            this.serverHost = args[2];
            this.serverPort = Integer.parseInt(args[3]);
            debug = args.length >= 5 ? args[4].equals("debug") : false;
            if (!this.ASYNC) {
                this.runListenerLoop();
            } else {
                new Thread(this).start();
            }
        }
        catch (Exception e) {
            Logger.getLogger().logLine("Proxy main:" + e.toString());
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runListenerLoop() {
        try {
            Object client;
            this.acceptSocket = this.openListener(this.acceptPort);
            Logger.getLogger().logLine("Waiting for Connections on port " + this.acceptPort + "...");
            this.starting = false;
            while (!this.stopped) {
                client = null;
                try {
                    client = this.acceptSocket.accept();
                }
                catch (IOException ioe) {
                    Proxy proxy = this;
                    synchronized (proxy) {
                        if (!this.stopped) {
                            if (this.retrySecs == 0) {
                                throw ioe;
                            }
                            this.acceptSocket = null;
                            while (this.acceptSocket == null && !this.stopped) {
                                Logger.getLogger().logLine("Exception in Listener:" + ioe.getMessage() + "! Retry after " + this.retrySecs + " Seconds!");
                                this.wait((long)this.retrySecs * 1000L);
                                try {
                                    this.acceptSocket = this.openListener(this.acceptPort);
                                    Logger.getLogger().logLine("Reconnected Listner on port " + this.acceptPort + "!");
                                }
                                catch (IOException ioe2) {
                                    ioe = ioe2;
                                }
                            }
                        }
                        if (this.stopped) {
                            this.listenerStopped = true;
                            this.notifyAll();
                        }
                    }
                }
                try {
                    if (this.stopped || client == null) continue;
                    Logger.getLogger().logLine("Proxy main: Got Connection...");
                    Proxy proxy = this.createProxy(this.serverHost, this.serverPort, (Socket)client);
                    new Thread(proxy).start();
                }
                catch (Exception e0) {
                    Logger.getLogger().logLine("Proxy main:" + e0.toString());
                }
            }
            client = this;
            synchronized (client) {
                this.listenerStopped = true;
                this.notifyAll();
            }
        }
        catch (Exception e1) {
            this.listenerStopped = true;
            this.starting = false;
            Logger.getLogger().logLine("*** ERROR when running proxy on port " + this.acceptPort + "! ***\r\nProxy stopped!\r\n" + e1.getMessage());
        }
    }

    public synchronized void stop() throws Exception {
        if (!this.MAINLOOP) {
            throw new IllegalStateException("Stop only possible on Main Loop Instance!;");
        }
        if (this.starting) {
            throw new Exception("Cannot stop proxy as it is currently starting!");
        }
        if (this.listenerStopped) {
            Logger.getLogger().logLine("Proxy Listener on Port " + this.acceptPort + " not running!");
            return;
        }
        this.stopped = true;
        try {
            if (this.acceptSocket != null) {
                this.acceptSocket.close();
            }
            this.notifyAll();
            while (!this.listenerStopped) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    Logger.getLogger().logException(e);
                    return;
                }
            }
            Logger.getLogger().logLine("Stopped Proxy Listener on Port " + this.acceptPort + "!");
        }
        catch (IOException e) {
            Logger.getLogger().logException(e);
        }
    }

    public static void main(String[] args) throws Exception {
        Proxy proxy = new Proxy();
        Logger.setLogger(proxy);
        proxy.initMainLoop(args);
    }

    @Override
    public void logLine(String txt) {
        System.out.println(String.valueOf(df.format(new Date())) + " " + txt);
    }

    @Override
    public void logException(Exception e) {
        e.printStackTrace();
    }

    @Override
    public void log(String txt) {
        System.out.print(txt);
    }

    @Override
    public void closeLogger() {
    }
}

