/*
 * Decompiled with CFR 0.152.
 */
package proxy;

import httptunnel.HttpTunnelServer;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import proxy.Proxy;
import util.Logger;
import util.Utils;

public class OutSideInProxy
extends Proxy {
    private boolean dynamic_mode = false;
    private boolean listenerOpenRetry = true;

    public OutSideInProxy(String host, int port, Socket clientSocket, boolean dynamic_mode) {
        super(host, port, clientSocket);
        this.dynamic_mode = dynamic_mode;
    }

    public OutSideInProxy() {
        this.retrySecs = 60;
    }

    @Override
    public Socket connectServer() throws Exception {
        try {
            InetAddress adr = InetAddress.getByName(this.serverHost);
            Socket s = new Socket(adr, this.serverPort);
            if (this.dynamic_mode) {
                this.client.getOutputStream().write("OK\n".getBytes());
                this.client.getOutputStream().flush();
            }
            return s;
        }
        catch (IOException e) {
            if (this.dynamic_mode) {
                this.client.getOutputStream().write((String.valueOf(e.toString()) + "\n").getBytes());
                this.client.getOutputStream().flush();
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    ServerSocket openListener(int port) throws Exception {
        while (true) {
            try {
                if (this.localOnly) {
                    return new HttpTunnelServer(port, "127.0.0.1");
                }
                return new HttpTunnelServer(port, "*");
            }
            catch (IOException ioe) {
                Logger.getLogger().logLine("Error opening Listener:" + ioe);
                if (!this.listenerOpenRetry) {
                    throw ioe;
                }
                Logger.getLogger().logLine("Retry in " + this.retrySecs + " seconds");
                OutSideInProxy outSideInProxy = this;
                synchronized (outSideInProxy) {
                    this.wait((long)this.retrySecs * 1000L);
                    if (!this.listenerOpenRetry) {
                        throw ioe;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void stop() throws Exception {
        this.listenerOpenRetry = false;
        OutSideInProxy outSideInProxy = this;
        synchronized (outSideInProxy) {
            this.notifyAll();
        }
        super.stop();
    }

    @Override
    public Proxy createProxy(String host, int port, Socket clientSocket) throws IOException {
        boolean dynamic = false;
        if (host.equals("%DYNAMIC%")) {
            dynamic = true;
            try {
                host = Utils.readLineFromStream(clientSocket.getInputStream());
                port = Integer.parseInt(Utils.readLineFromStream(clientSocket.getInputStream()));
            }
            catch (Exception e) {
                Logger.getLogger().logLine("Initialization of %DYNAMIC% connection failed with host = '" + host + "', port = '" + port + "'\r\n" + e.toString());
                try {
                    clientSocket.getOutputStream().write((String.valueOf(e.toString()) + "\n").getBytes());
                    clientSocket.getOutputStream().flush();
                    clientSocket.close();
                }
                catch (IOException e1) {
                    Logger.getLogger().logException(e1);
                }
                throw new IOException(e);
            }
        }
        return new OutSideInProxy(host, port, clientSocket, dynamic);
    }

    public static void main(String[] args) throws Exception {
        OutSideInProxy proxy = new OutSideInProxy();
        Logger.setLogger(proxy);
        proxy.initMainLoop(args);
    }
}

