/*
 * Decompiled with CFR 0.152.
 */
package httptunnel;

import httptunnel.Configuration;
import httptunnel.HttpTunnelConnection;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import util.Logger;
import util.Utils;

public class HttpTunnelServer
extends ServerSocket {
    HttpTunnelConnection con;
    InputStream in;
    OutputStream out;
    boolean open = false;
    boolean inAccept = false;
    int port = -1;
    int conRefreshInterval = 0;

    public HttpTunnelServer(int port, String adapterAddress) throws IOException {
        if (adapterAddress == null) {
            adapterAddress = "*";
        }
        Configuration.initConfiguration();
        this.port = port;
        this.con = new HttpTunnelConnection("localhost", Configuration.OPEN_SERVER_REQUEST_PORT);
        this.in = this.con.getInputStream();
        this.out = this.con.getOutputStream();
        this.out.write((String.valueOf(Configuration.CLIENT_ID) + "\n").getBytes());
        this.out.write((String.valueOf(port) + "\n").getBytes());
        this.out.write((String.valueOf(adapterAddress) + "\n").getBytes());
        this.out.write((String.valueOf(Configuration.CON_REFRESH_INTERVAL) + "\n").getBytes());
        this.out.write(Configuration.CON_MODE);
        this.out.flush();
        String result = Utils.readLineFromStream(this.in);
        if (!result.equals("OK")) {
            result = String.valueOf(result) + new String(Utils.readFully(this.in, 50));
            try {
                this.con.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            throw new IOException("Open Server Failed - received responds: " + result);
        }
        this.open = true;
    }

    public HttpTunnelServer(int port) throws IOException {
        this(port, null);
    }

    @Override
    public synchronized Socket accept() throws IOException {
        try {
            this.inAccept = true;
            if (!this.open) {
                throw new IOException("Remote Server Socket on port " + this.port + " is closed!");
            }
            String newCon = "";
            while (!newCon.equals("ACCEPTED")) {
                newCon = Utils.readLineFromStream(this.in);
                if (newCon == null || newCon.equals("")) {
                    this.open = false;
                    throw new IOException("Remote Server Socket on port " + this.port + " is closed!");
                }
                if (newCon.equalsIgnoreCase("NOTIFY_ALIVE")) {
                    Logger.getLogger().logLine("Received NOTIFY_ALIVE");
                    continue;
                }
                if (newCon.equals("ACCEPTED")) continue;
                throw new IOException("Accept failed - received responds: " + newCon);
            }
            String sessionId = null;
            sessionId = Utils.readLineFromStream(this.in);
            try {
                long sid = Long.parseLong(sessionId);
                sessionId = Long.valueOf(sid ^= Long.MAX_VALUE).toString();
            }
            catch (NumberFormatException e) {
                throw new IOException("Accept - receive session id - failed - received responds: " + sessionId);
            }
            InetAddress remoteAdr = null;
            ObjectInputStream objIn = new ObjectInputStream(this.in);
            try {
                remoteAdr = (InetAddress)objIn.readObject();
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new IOException("Accept failed - received remote address: " + e.getMessage());
            }
            HttpTunnelConnection httpTunnelConnection = new HttpTunnelConnection(sessionId, remoteAdr);
            return httpTunnelConnection;
        }
        finally {
            this.inAccept = false;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (!this.open) {
            return;
        }
        this.open = false;
        this.con.close();
        HttpTunnelServer httpTunnelServer = this;
        synchronized (httpTunnelServer) {
            return;
        }
    }

    @Override
    public int getLocalPort() {
        return this.port;
    }
}

