/*
 * Decompiled with CFR 0.152.
 */
package httptunnel;

import httptunnel.Configuration;
import httptunnel.HttpTunnelConnection;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import util.Encryption;
import util.Utils;
import util.http.HttpURLConnection;
import util.http.URL;

public class HTTPTunnelInputStream
extends InputStream {
    private String m_cookie;
    private String m_sessionId;
    private HttpTunnelConnection m_tunnel;
    private URL m_url;
    private InputStream m_inStream;
    private long m_bytesReceived = 0L;
    private boolean closed = false;
    HttpURLConnection receiver;

    public HTTPTunnelInputStream(HttpTunnelConnection tunnel, InputStream in) throws IOException {
        this.m_inStream = in;
        this.m_cookie = tunnel.getSessionCookie();
        this.m_sessionId = tunnel.getSessionId();
        this.m_tunnel = tunnel;
        try {
            this.m_url = new URL(Configuration.TUNNELSERVER_URL);
        }
        catch (Exception e) {
            throw new IOException(e.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean streamRetryOk() {
        boolean ok = true;
        try {
            HttpTunnelConnection httpTunnelConnection = this.m_tunnel;
            synchronized (httpTunnelConnection) {
                if (this.closed || !this.m_tunnel.isOpen()) {
                    return false;
                }
                if (this.m_inStream != null) {
                    this.m_inStream.close();
                }
            }
            this.receiver = this.m_url.openConnection(Configuration.HTTPPROXY);
            this.receiver.setSSLSocketFactory(Configuration.SSL_SOCKET_FACTORY);
            this.receiver.setConnectTimeout(Configuration.CON_TIMEOUT);
            this.receiver.setDoOutput(true);
            this.receiver.setRequestProperty("Connection", "Keep-Alive");
            this.receiver.setRequestProperty("Authorization", Configuration.ENCRAUTHSTRING);
            if (Configuration.PROXY_AUTH_REQUIRED) {
                this.receiver.setRequestProperty("Proxy-Authorization", Configuration.PROXY_AUTH_STRING);
            }
            OutputStream outStream = Encryption.getEncryptedOutputStream(this.receiver.getOutputStream(), 1024);
            outStream.write(new String("RECEIVER_RETRY\n").getBytes());
            outStream.write(new String(String.valueOf(this.m_sessionId) + "\n").getBytes());
            outStream.write(new String(String.valueOf(this.m_bytesReceived) + "\n").getBytes());
            outStream.flush();
            outStream.close();
            String msg = this.receiver.getResponseMessage();
            int code = this.receiver.getResponseCode();
            this.m_inStream = Encryption.getDecryptedStream(this.receiver.getInputStream());
            HttpTunnelConnection httpTunnelConnection2 = this.m_tunnel;
            synchronized (httpTunnelConnection2) {
                if (code != 200 || this.closed || !this.m_tunnel.isOpen()) {
                    ok = false;
                    if (this.m_inStream != null) {
                        Utils.readFully(this.m_inStream, 50);
                        this.m_inStream.close();
                    }
                }
            }
            if (!ok) {
                this.m_tunnel.setClosed();
                return false;
            }
            return true;
        }
        catch (Exception e) {
            this.m_tunnel.setClosed();
            return false;
        }
    }

    @Override
    public int read() throws IOException {
        byte[] b = new byte[1];
        int r = this.read(b);
        if (r == -1) {
            return -1;
        }
        return b[0] & 0xFF;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        boolean nextTry = true;
        int r = 0;
        try {
            while (nextTry) {
                r = this.m_inStream != null ? this.m_inStream.read(b, off, len) : -1;
                if (r != -1) {
                    this.m_bytesReceived += (long)r;
                    nextTry = false;
                    continue;
                }
                if (this.streamRetryOk()) continue;
                nextTry = false;
            }
            return r;
        }
        catch (IOException eio) {
            this.m_tunnel.setClosed();
            throw eio;
        }
    }

    @Override
    public void close() throws IOException {
        if (this.m_inStream != null) {
            this.m_inStream.close();
        }
        this.closed = true;
    }

    @Override
    public void mark(int readlimit) {
        this.m_inStream.mark(readlimit);
    }

    @Override
    public void reset() throws IOException {
        this.m_inStream.reset();
    }

    @Override
    public boolean markSupported() {
        return this.m_inStream.markSupported();
    }
}

