/*
 * Decompiled with CFR 0.152.
 */
package httptunnel;

import httptunnel.Configuration;
import httptunnel.HttpTunnelConnection;
import java.io.IOException;
import java.io.OutputStream;
import util.Encryption;
import util.TimeoutListener;
import util.TimeoutTime;
import util.TimoutNotificator;
import util.Utils;
import util.http.HttpURLConnection;
import util.http.URL;

public class HTTPTunnelChunkedOutputStream
extends OutputStream
implements TimeoutListener {
    private String m_cookie;
    private String m_sessionId;
    private HttpURLConnection m_connection;
    private HttpTunnelConnection tunnel;
    private URL m_url;
    private OutputStream chunkedOut = null;
    private boolean closed = false;
    private TimoutNotificator toNotify = TimoutNotificator.getInstance();
    private TimeoutTime timeout = new TimeoutTime(this.toNotify);

    public HTTPTunnelChunkedOutputStream(HttpTunnelConnection tunnel) throws IOException {
        this.m_cookie = tunnel.getSessionCookie();
        this.m_sessionId = tunnel.getSessionId();
        this.tunnel = tunnel;
        try {
            this.m_url = new URL(Configuration.TUNNELSERVER_URL);
        }
        catch (Exception e) {
            throw new IOException(e.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OutputStream openStreamToHttpServer() throws IOException {
        HttpTunnelConnection httpTunnelConnection = this.tunnel;
        synchronized (httpTunnelConnection) {
            if (this.chunkedOut != null) {
                return this.chunkedOut;
            }
            if (this.closed) {
                throw new IOException("Stream is closed");
            }
            this.m_connection = this.m_url.openConnection(Configuration.HTTPPROXY);
            this.m_connection.setSSLSocketFactory(Configuration.SSL_SOCKET_FACTORY);
            this.m_connection.setConnectTimeout(Configuration.CON_TIMEOUT);
            this.m_connection.setChunkedStreamingMode(1024);
            this.m_connection.setDoOutput(true);
            this.m_connection.setRequestMethod("POST");
            this.m_connection.setRequestProperty("Connection", "Keep-Alive");
            if (this.m_cookie != null) {
                this.m_connection.setRequestProperty("Cookie", this.m_cookie);
            }
            this.m_connection.setRequestProperty("Authorization", Configuration.ENCRAUTHSTRING);
            if (Configuration.PROXY_AUTH_REQUIRED) {
                this.m_connection.setRequestProperty("Proxy-Authorization", Configuration.PROXY_AUTH_STRING);
            }
            OutputStream outStream = Encryption.getEncryptedOutputStream(this.m_connection.getOutputStream(), Configuration.SEND_BUFFER_BYTES);
            outStream.write(new String("SENDER\n").getBytes());
            outStream.write(new String(String.valueOf(this.m_sessionId) + "\n").getBytes());
            outStream.flush();
            this.chunkedOut = outStream;
            this.timeout.setTimeout(Configuration.CON_REFRESH_INTERVAL);
            this.toNotify.register(this);
            return outStream;
        }
    }

    @Override
    public void write(int b) throws IOException {
        throw new IOException("write(int b) not supported in HTTPTunnelOutputStream");
    }

    @Override
    public void write(byte[] b) throws IOException {
        OutputStream outStream = this.openStreamToHttpServer();
        this.timeout.setTimeout(Configuration.CON_REFRESH_INTERVAL);
        outStream.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        OutputStream outStream = this.openStreamToHttpServer();
        this.timeout.setTimeout(Configuration.CON_REFRESH_INTERVAL);
        outStream.write(b, off, len);
    }

    @Override
    public void flush() throws IOException {
        this.timeout.setTimeout(Configuration.CON_REFRESH_INTERVAL);
        if (this.chunkedOut != null) {
            this.chunkedOut.flush();
        }
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.toNotify.unregister(this);
        if (this.chunkedOut != null) {
            this.chunkedOut.flush();
            this.chunkedOut.close();
            this.chunkedOut = null;
            String msg = this.m_connection.getResponseMessage();
            int code = this.m_connection.getResponseCode();
            if (code != 200) {
                String result = new String(Utils.readFully(Encryption.getDecryptedStream(this.m_connection.getInputStream()), 1024));
                throw new IOException(result);
            }
        }
    }

    @Override
    public void timeoutNotification() {
        if (this.closed) {
            return;
        }
        try {
            if (this.chunkedOut != null) {
                this.chunkedOut.flush();
                this.chunkedOut.close();
                this.chunkedOut = null;
                String msg = this.m_connection.getResponseMessage();
                int code = this.m_connection.getResponseCode();
                if (code != 200) {
                    String result = new String(Utils.readFully(Encryption.getDecryptedStream(this.m_connection.getInputStream()), 1024));
                    throw new IOException(result);
                }
            }
        }
        catch (Exception e) {
            System.out.println("Exception in " + this + ".timeoutNotification():" + e.toString());
            this.chunkedOut = null;
        }
    }

    @Override
    public long getTimoutTime() {
        return this.timeout.getTimeout();
    }
}

