/*
 * Decompiled with CFR 0.152.
 */
package httptunnel;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Properties;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import util.BASE64Encoder;
import util.Encryption;
import util.Logger;
import util.Utils;
import util.conpool.Connection;
import util.conpool.HttpProxy;
import util.http.HttpURLConnection;
import util.http.URL;

public class Configuration {
    public static int CON_TIMEOUT = 90000;
    public static boolean DIRECT_PASS_THROUGH;
    public static boolean PROXY_AUTH_REQUIRED;
    public static boolean USE_DYNAMIC_URL;
    public static boolean USE_PROXY;
    public static String PROXY_AUTH_STRING;
    public static String TUNNELSERVER_URL;
    public static int TUNNELSERVER_PORT;
    public static String TUNNELSERVER_HOST;
    public static String DYNAMIC_URL_LOCATION;
    public static boolean INITIALIZED;
    public static int SEND_BUFFER_BYTES;
    public static int OPEN_SERVER_REQUEST_PORT;
    public static int CMD_RQ_PORT;
    public static int CON_REFRESH_INTERVAL;
    public static byte CON_MODE;
    public static String ENCRAUTHSTRING;
    public static String CONFIG_PATH;
    public static String KEY_PATH;
    public static Proxy HTTPPROXY;
    public static boolean SSL;
    public static String REMOTE_PERM;
    public static SSLSocketFactory SSL_SOCKET_FACTORY;
    public static String CLIENT_ID;
    private static String VERSION;

    static {
        USE_PROXY = false;
        PROXY_AUTH_STRING = null;
        TUNNELSERVER_URL = null;
        TUNNELSERVER_PORT = 80;
        TUNNELSERVER_HOST = null;
        DYNAMIC_URL_LOCATION = null;
        INITIALIZED = false;
        ENCRAUTHSTRING = "";
        CONFIG_PATH = "HttpTunnel.properties";
        KEY_PATH = "key";
        HTTPPROXY = Proxy.NO_PROXY;
        SSL = false;
        REMOTE_PERM = "";
        SSL_SOCKET_FACTORY = null;
        CLIENT_ID = "<not_set>";
        VERSION = "1.5.55";
    }

    public static synchronized void updateClientID(String id) {
        CLIENT_ID = id;
    }

    public static synchronized void reset() {
        INITIALIZED = false;
    }

    public static synchronized void initConfiguration() throws IOException {
        String user_agent;
        if (INITIALIZED) {
            return;
        }
        Properties props = new Properties();
        FileInputStream in = new FileInputStream(CONFIG_PATH);
        props.load(in);
        in.close();
        if (!Encryption.isInitialized()) {
            FileInputStream keyFile = new FileInputStream(KEY_PATH);
            Encryption.init(keyFile, props.getProperty("ENCR_METHOD", "AES"));
            Logger.getLogger().logLine("*****************************************************");
            Logger.getLogger().logLine("* This is PersonalHttpTunnel Client Version: " + VERSION + " *");
            Logger.getLogger().logLine("* http://www.zenz-solutions.de/personalhttptunnel   *");
            Logger.getLogger().logLine("*****************************************************");
        }
        String permFilePath = String.valueOf(new File(CONFIG_PATH).getAbsoluteFile().getParent()) + "/remote.perm";
        Logger.getLogger().logLine("Using permission file: " + permFilePath);
        if (new File(permFilePath).exists()) {
            FileInputStream permIn = new FileInputStream(permFilePath);
            REMOTE_PERM = new String(Utils.readFully(permIn, 256));
            ((InputStream)permIn).close();
        } else {
            Logger.getLogger().logLine("No token remote permission found!\n Your access might be restricted to localhost!");
        }
        SSL = new Boolean(props.getProperty("TRANSPORT_VIA_SSL", "false"));
        if (SSL) {
            Configuration.initSSLSocketFactory(props.getProperty("SSL_SRV_CERT", "server.cer"));
        }
        TUNNELSERVER_PORT = SSL ? 443 : 80;
        DIRECT_PASS_THROUGH = new Boolean(props.getProperty("DIRECT_PASS_THROUGH", "false"));
        if (!DIRECT_PASS_THROUGH) {
            int pooltimeout = Integer.parseInt(props.getProperty("HTTP_CONNECTION_POOL_TIMEOUT_SECONDS", "300"));
            Logger.getLogger().logLine("using Http Connection Pool Timeout in seconds:" + pooltimeout);
            Connection.setPoolTimeoutSeconds(pooltimeout);
        }
        String proxyHost = props.getProperty("HttpProxyServer");
        String proxyPort = props.getProperty("HttpProxyPort");
        if (proxyHost != null && !proxyHost.equals("")) {
            USE_PROXY = true;
            InetAddress adr = InetAddress.getByName(proxyHost);
            PROXY_AUTH_REQUIRED = new Boolean(props.getProperty("proxyAuthRequired"));
            if (PROXY_AUTH_REQUIRED) {
                PROXY_AUTH_STRING = String.valueOf(props.getProperty("HttpProxyUser")) + ":" + props.getProperty("HttpProxyPassword");
                PROXY_AUTH_STRING = new BASE64Encoder().encode(PROXY_AUTH_STRING.getBytes());
                PROXY_AUTH_STRING = "Basic " + PROXY_AUTH_STRING;
            }
            HTTPPROXY = new HttpProxy(new InetSocketAddress(adr, Integer.parseInt(proxyPort)), PROXY_AUTH_STRING);
            Logger.getLogger().logLine("using Proxy" + HTTPPROXY);
            if (DIRECT_PASS_THROUGH) {
                Logger.getLogger().logLine("->>>NOTE! Direct Pass through Mode might not be supported with Proxy!<<<-");
            }
        } else if (!DIRECT_PASS_THROUGH) {
            Logger.getLogger().logLine("<<<------------------------------------------------------------------->>>");
            Logger.getLogger().logLine("<<< PERFORMANCE might be improved! By enabling Direct Pass Through!   >>>");
            Logger.getLogger().logLine("<<<           with setting 'DIRECT_PASS_THROUGH = true'               >>>");
            Logger.getLogger().logLine("<<<------------------------------------------------------------------->>>");
        }
        if (USE_DYNAMIC_URL = new Boolean(props.getProperty("useDynamicTunnelServerURL")).booleanValue()) {
            DYNAMIC_URL_LOCATION = props.getProperty("dynamicTunnelServerURLLocation");
            Configuration.setDynamicURL(props);
        } else {
            TUNNELSERVER_URL = props.getProperty("staticTunnelServerURL");
            if (SSL && !TUNNELSERVER_URL.startsWith("https:") || !SSL && !TUNNELSERVER_URL.startsWith("http:")) {
                throw new IOException("Wrong static URL! - Should start with 'https:' when SSL is enabled, with 'http:' otherwise!");
            }
        }
        SEND_BUFFER_BYTES = Integer.parseInt(props.getProperty("SEND_BUFFER_BYTES"));
        OPEN_SERVER_REQUEST_PORT = Integer.parseInt(props.getProperty("OPEN_SERVER_REQUEST_PORT", "9000"));
        CMD_RQ_PORT = Integer.parseInt(props.getProperty("CMD_RQ_PORT", "9001"));
        CON_REFRESH_INTERVAL = Integer.parseInt(props.getProperty("TUNNEL_CONNECTION_REFRESH", "0"));
        CON_MODE = Configuration.setConnectionMode(props);
        ENCRAUTHSTRING = new BASE64Encoder().encode(Encryption.encrypt(Utils.AUTHSTRING.getBytes()));
        int index = TUNNELSERVER_URL.indexOf("://");
        TUNNELSERVER_HOST = TUNNELSERVER_URL.substring(index + 3);
        index = TUNNELSERVER_HOST.indexOf(47);
        if (index != -1) {
            TUNNELSERVER_HOST = TUNNELSERVER_HOST.substring(0, index);
        }
        if ((index = TUNNELSERVER_HOST.indexOf(58)) != -1) {
            TUNNELSERVER_PORT = Integer.parseInt(TUNNELSERVER_HOST.substring(index + 1));
            TUNNELSERVER_HOST = TUNNELSERVER_HOST.substring(0, index);
        }
        if (!(user_agent = props.getProperty("USER_AGENT", "")).equals("")) {
            user_agent = user_agent.replace("${os.name}", System.getProperty("os.name")).replace("${os.version}", System.getProperty("os.version"));
            Logger.getLogger().logLine("Using custom user_agent='" + user_agent + "'");
            HttpURLConnection.setUserAgent(user_agent);
        }
        INITIALIZED = true;
    }

    private static void initSSLSocketFactory(String cert) throws IOException {
        try {
            Certificate ca;
            String certPath = String.valueOf(new File(CONFIG_PATH).getAbsoluteFile().getParent()) + "/" + cert;
            if (!new File(certPath).exists()) {
                SSL_SOCKET_FACTORY = (SSLSocketFactory)SSLSocketFactory.getDefault();
                return;
            }
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            BufferedInputStream caInput = new BufferedInputStream(new FileInputStream(certPath));
            try {
                ca = cf.generateCertificate(caInput);
                Logger.getLogger().logLine("ca=" + ((X509Certificate)ca).getSubjectDN());
            }
            finally {
                ((InputStream)caInput).close();
            }
            String keyStoreType = KeyStore.getDefaultType();
            KeyStore keyStore = KeyStore.getInstance(keyStoreType);
            keyStore.load(null, null);
            keyStore.setCertificateEntry("ca", ca);
            String tmfAlgorithm = TrustManagerFactory.getDefaultAlgorithm();
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(tmfAlgorithm);
            tmf.init(keyStore);
            SSLContext context = SSLContext.getInstance("TLS");
            context.init(null, tmf.getTrustManagers(), null);
            SSL_SOCKET_FACTORY = context.getSocketFactory();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private static byte setConnectionMode(Properties props) {
        byte mode = 0;
        if (DIRECT_PASS_THROUGH) {
            mode = (byte)(mode + Utils.CON_MODE_DIRECT);
        }
        if ((!USE_PROXY || SSL || Boolean.valueOf(props.getProperty("PROXY_SUPPORTS_CHUNKED_REQUEST", "false")).booleanValue()) && !Boolean.valueOf(props.getProperty("FORCE_CHUNKED_REQUEST_DISABLED", "false")).booleanValue()) {
            mode = (byte)(mode + Utils.CON_MODE_CHUNKED_REQUEST);
        }
        if (Boolean.valueOf(props.getProperty("ENABLE_CHUNKED_RESPONSE", "false")).booleanValue()) {
            mode = (byte)(mode + Utils.CON_MODE_CHUNKED_RESPONSE);
        }
        if (Boolean.valueOf(props.getProperty("NETWORK_BLOCKS_INPUT", "false")).booleanValue()) {
            mode = (byte)(mode + Utils.CON_MODE_NETWORK_BLOCKS_INPUT);
        }
        if ((mode & Utils.CON_MODE_CHUNKED_REQUEST) == 0) {
            Logger.getLogger().logLine("<<<------------------------------------------------------------------->>>");
            Logger.getLogger().logLine("<<< PERFORMANCE might be improved! By enabling chunked request mode!  >>>");
            Logger.getLogger().logLine("<<<      with setting 'PROXY_SUPPORTS_CHUNKED_REQUEST = true'         >>>");
            Logger.getLogger().logLine("<<<      with setting 'FORCE_CHUNKED_REQUEST_DISABLED = false'        >>>");
            Logger.getLogger().logLine("<<<------------------------------------------------------------------->>>");
        }
        if (Boolean.valueOf(props.getProperty("ENABLE_CONNECTION_MONITOR", "true")).booleanValue()) {
            mode = (byte)(mode + Utils.CON_MODE_WATCH_ENABLED);
        }
        return mode;
    }

    private static void setDynamicURL(Properties config) throws IOException {
        if (!USE_DYNAMIC_URL) {
            return;
        }
        int port = 80;
        if (SSL) {
            port = 443;
        }
        try {
            port = Integer.parseInt(config.getProperty("dynamicTunnelServerURLPort", "" + port));
        }
        catch (NumberFormatException nfe) {
            throw new IOException("Setting 'dynamicTunnelServerURLPort' is not an integer number!");
        }
        URL url = new URL(DYNAMIC_URL_LOCATION);
        HttpURLConnection receiver = url.openConnection(HTTPPROXY);
        if (PROXY_AUTH_REQUIRED) {
            receiver.setRequestProperty("Proxy-Authorization", PROXY_AUTH_STRING);
        }
        InputStream in = Encryption.getDecryptedStream(receiver.getInputStream());
        Properties props = new Properties();
        props.load(in);
        in.close();
        String proto = "http";
        if (SSL) {
            proto = "https";
        }
        String id = DYNAMIC_URL_LOCATION.substring(0, DYNAMIC_URL_LOCATION.length() - 7);
        id = id.substring(id.lastIndexOf("/") + 1);
        String dynIP = props.getProperty("ip");
        if (dynIP != null) {
            if (SSL || DIRECT_PASS_THROUGH) {
                Connection.addCustomHost(InetAddress.getByAddress(id, InetAddress.getByName(dynIP).getAddress()));
                Logger.getLogger().logLine("Mapping host name '" + id + "' to IP " + dynIP);
                TUNNELSERVER_URL = String.valueOf(proto) + "://" + id + ":" + port;
            } else {
                TUNNELSERVER_URL = String.valueOf(proto) + "://" + dynIP + ":" + port;
            }
        }
        if (dynIP == null) {
            throw new IOException("Could not retrieve dynamic tunnel server URL - Possible Issue: Invalid Key!");
        }
        Logger.getLogger().logLine("Using: " + TUNNELSERVER_URL);
    }
}

