/*
 * Decompiled with CFR 0.152.
 */
package util.http;

import java.io.IOException;
import java.io.OutputStream;

public class HttpChunkedOutputStream
extends OutputStream {
    private OutputStream lowerOut;

    public HttpChunkedOutputStream(OutputStream underlying) throws IOException {
        this.lowerOut = underlying;
    }

    @Override
    public void write(int oneByte) throws IOException {
        this.lowerOut.write("1\r\n".getBytes());
        this.lowerOut.write(oneByte);
        this.lowerOut.write("\r\n".getBytes());
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.lowerOut.write((String.valueOf(Integer.toHexString(len)) + "\r\n").getBytes());
        this.lowerOut.write(b, off, len);
        this.lowerOut.write("\r\n".getBytes());
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.lowerOut.write((String.valueOf(Integer.toHexString(b.length)) + "\r\n").getBytes());
        this.lowerOut.write(b);
        this.lowerOut.write("\r\n".getBytes());
    }

    @Override
    public void flush() throws IOException {
        this.lowerOut.flush();
    }

    @Override
    public void close() throws IOException {
        this.lowerOut.write("0\r\n\r\n".getBytes());
        this.lowerOut.flush();
    }
}

