/*
 * Decompiled with CFR 0.152.
 */
package util.commands;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import util.Utils;
import util.commands.Command;

public class ThreadDump
extends Command {
    boolean detailed = false;

    @Override
    public void runCommand(InputStream in, OutputStream out) throws IOException {
        try {
            String[] args = Utils.readLineFromStream(in).split(" ");
            if (args.length >= 1) {
                this.detailed = args[0].equalsIgnoreCase("-d");
            }
            Map<Thread, StackTraceElement[]> dump = Thread.getAllStackTraces();
            for (Thread t : dump.keySet()) {
                StackTraceElement[] stack = dump.get(t);
                out.write((t + "\n").getBytes());
                out.write("********************************************************************\n".getBytes());
                if (!this.detailed && stack.length > 0) {
                    out.write((stack[0] + "\n").getBytes());
                    continue;
                }
                int i = 0;
                while (i < stack.length) {
                    out.write((stack[i] + "\n").getBytes());
                    ++i;
                }
                out.write("\n".getBytes());
            }
            out.flush();
        }
        catch (Exception e) {
            out.write(("ThreadDump Failed! " + e).getBytes());
            out.flush();
        }
    }

    public static void main(String[] args) throws Exception {
        ByteArrayOutputStream argBytes = new ByteArrayOutputStream();
        int i = 0;
        while (i < args.length) {
            argBytes.write(args[i].getBytes());
            if (i < args.length - 1) {
                argBytes.write(" ".getBytes());
            } else {
                argBytes.write("\n".getBytes());
            }
            ++i;
        }
        argBytes.flush();
        new ThreadDump().runCommand(new ByteArrayInputStream(argBytes.toByteArray()), System.out);
    }
}

