/*
 * Decompiled with CFR 0.152.
 */
package mysoft.httptunnel;

import java.io.IOException;
import java.net.Socket;
import java.util.Hashtable;
import java.util.Properties;
import mysoft.httptunnel.RemoteServerProxy;
import mysoft.httptunnel.TunnelSessionHandler;
import util.Logger;

public class RemoteServerProxyHandler
implements Runnable {
    private boolean open = true;
    private TunnelSessionHandler m_tunnelInstance;
    private Hashtable m_allServers = new Hashtable();
    int virtualPort = 9000;
    Object acceptMon = new Object();
    Socket newServer = null;

    public RemoteServerProxyHandler(Properties config, TunnelSessionHandler tunnelInstance) throws Exception {
        this.virtualPort = Integer.parseInt(config.getProperty("OPEN_SERVER_REQUEST_PORT", "9000"));
        this.m_tunnelInstance = tunnelInstance;
        new Thread(this).start();
    }

    public int getVirtualPort() {
        return this.virtualPort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Socket acceptNewServer() throws IOException {
        Object object = this.acceptMon;
        synchronized (object) {
            block7: {
                while (this.newServer == null && this.open) {
                    try {
                        this.acceptMon.wait();
                    }
                    catch (InterruptedException e) {
                        throw new IOException(e);
                    }
                }
                if (this.open) break block7;
                return null;
            }
            Socket accepted = this.newServer;
            this.newServer = null;
            return accepted;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runNewRemoteServer(Socket s) throws IOException {
        Object object = this.acceptMon;
        synchronized (object) {
            this.newServer = s;
            this.acceptMon.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.open = false;
        Object object = this.acceptMon;
        synchronized (object) {
            this.acceptMon.notifyAll();
        }
        object = this;
        synchronized (object) {
            Object[] all = this.m_allServers.values().toArray();
            int i = 0;
            while (i < all.length) {
                ((RemoteServerProxy)all[i]).stop();
                ++i;
            }
        }
    }

    public RemoteServerProxy getOpenRemoteServerProxy(int port) {
        return (RemoteServerProxy)this.m_allServers.get(new Integer(port));
    }

    public void aliveCheck() {
        Object[] all = this.m_allServers.values().toArray();
        int i = 0;
        while (i < all.length) {
            ((RemoteServerProxy)all[i]).aliveCheck();
            ++i;
        }
    }

    public synchronized void unregister(int port) {
        this.m_allServers.remove(new Integer(port));
    }

    @Override
    public void run() {
        while (this.open) {
            try {
                Socket newServer = this.acceptNewServer();
                if (!this.open) continue;
                RemoteServerProxy remoteServerProxy = new RemoteServerProxy(newServer, this.m_tunnelInstance, this);
                Logger.getLogger().logLine("New Remote Server accepted: " + newServer);
                int port = remoteServerProxy.init();
                if (port == -1) continue;
                this.m_allServers.put(new Integer(port), remoteServerProxy);
            }
            catch (Exception e) {
                if (!this.open) continue;
                Logger.getLogger().logException(e);
            }
        }
    }
}

