/*
 * Decompiled with CFR 0.152.
 */
package mysoft.httptunnel;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import mysoft.httptunnel.TunnelServer;
import mysoft.httptunnel.TunnelSession;
import util.Logger;
import util.Utils;

public class DirectPassThroughSession
extends TunnelSession
implements Runnable {
    private String sHost;
    private int sPort;
    private Socket sSocket;
    private InputStream cIn;
    private OutputStream cOut;
    private InputStream sIn;
    private OutputStream sOut;
    private boolean attached = false;
    private long not_attached_creation_ts = 0L;
    private String clientID = "";
    private boolean valid = true;

    public DirectPassThroughSession(String clientID, InputStream in, OutputStream out, String host, int port) {
        this.clientID = clientID;
        this.sHost = host;
        this.sPort = port;
        this.cIn = in;
        this.cOut = out;
        this.attached = true;
    }

    public DirectPassThroughSession(String clientID) {
        this.clientID = clientID;
        this.not_attached_creation_ts = System.currentTimeMillis();
    }

    public void connect(String socketClientID) throws Exception {
        Logger.getLogger().logLine("Connecting DirectPassThroughSession...");
        this.sSocket = this.connectTunnel(this.clientID, socketClientID, this.sHost, this.sPort);
        this.sIn = this.sSocket.getInputStream();
        this.sOut = this.sSocket.getOutputStream();
        this.cOut.write("OK\n".getBytes());
        this.cOut.write(Utils.serializeObject(this.sSocket.getInetAddress()));
        this.cOut.flush();
        Logger.getLogger().logLine("done!");
    }

    public void connect(Socket server) throws IOException {
        this.sSocket = server;
        this.sIn = this.sSocket.getInputStream();
        this.sOut = this.sSocket.getOutputStream();
        this.sHost = server.getInetAddress().getHostAddress();
        this.sPort = server.getPort();
    }

    public void attachClient(InputStream cIn, OutputStream cOut) throws IOException {
        this.attached = true;
        this.cIn = cIn;
        this.cOut = cOut;
        cOut.write("OK\n".getBytes());
        cOut.flush();
    }

    public void doSession() {
        try {
            try {
                Logger.getLogger().logLine("Starting DirectPassThroughSession:" + this.sHost + ":" + this.sPort);
                TunnelServer.threadPool.startThread(this);
                this.tranferData(this.sIn, this.cOut, "S->C");
            }
            catch (Exception e) {
                Logger.getLogger().logLine(e.getMessage());
                this.closeServerIgnoreException();
            }
        }
        finally {
            this.closeServerIgnoreException();
        }
    }

    private synchronized void closeServerIgnoreException() {
        if (this.sSocket == null) {
            return;
        }
        try {
            try {
                Logger.getLogger().logLine("Closing Connection to:" + this.sHost + ":" + this.sPort);
                this.sSocket.shutdownOutput();
                this.sSocket.shutdownInput();
                this.sSocket.close();
            }
            catch (Exception e) {
                Logger.getLogger().logLine(e.getMessage());
                this.sSocket = null;
            }
        }
        finally {
            this.sSocket = null;
        }
    }

    private void tranferData(InputStream in, OutputStream out, String role) {
        byte[] buffer = new byte[TunnelServer.WRITE_BUFSIZE];
        try {
            try {
                int r;
                while ((r = in.read(buffer)) != -1) {
                    out.write(buffer, 0, r);
                    out.flush();
                }
            }
            catch (Exception exception) {
                this.closeServerIgnoreException();
                Logger.getLogger().logLine("Terminated transfer:" + role + " for " + this.sHost + ":" + this.sPort + "!");
            }
        }
        finally {
            this.closeServerIgnoreException();
            Logger.getLogger().logLine("Terminated transfer:" + role + " for " + this.sHost + ":" + this.sPort + "!");
        }
    }

    @Override
    public void setInvalid() {
        this.valid = false;
    }

    @Override
    public void run() {
        this.tranferData(this.cIn, this.sOut, "C->S");
    }

    @Override
    public boolean isAlive() {
        if (this.attached) {
            return this.valid;
        }
        return System.currentTimeMillis() - this.not_attached_creation_ts < 60000L;
    }

    @Override
    public void killSession() throws Exception {
        this.closeServerIgnoreException();
    }

    @Override
    public String getClientId() {
        return this.clientID;
    }
}

