/*
 * Decompiled with CFR 0.152.
 */
package util.http;

import java.io.IOException;
import java.io.InputStream;
import java.net.SocketTimeoutException;
import util.http.HttpChunkedInputStream;
import util.http.HttpURLConnection;

public class HttpResponseInputStream
extends InputStream {
    private boolean chunked;
    private long contentLength;
    private HttpURLConnection con;
    InputStream lowerIn;
    int count = 0;
    boolean eof = false;
    boolean error = false;
    boolean closed = false;

    public HttpResponseInputStream(HttpURLConnection httpURLConnection, boolean chunkedTransfer, long contentLength, InputStream in) {
        this.chunked = chunkedTransfer;
        this.contentLength = contentLength;
        this.con = httpURLConnection;
        this.eof = !this.chunked && contentLength == 0L;
        this.lowerIn = this.chunked ? new HttpChunkedInputStream(in) : in;
    }

    @Override
    public int read() throws IOException {
        if (this.error) {
            throw new IOException("Stream is in Error State!");
        }
        if (this.eof) {
            return -1;
        }
        if (!this.chunked && this.contentLength >= 0L) {
            boolean bl = this.eof = (long)this.count == this.contentLength;
            if (this.eof) {
                this.con.responseCompleted(true);
                return -1;
            }
        }
        try {
            int r = this.lowerIn.read();
            if (r == -1 && !this.chunked && this.contentLength >= 0L && (long)this.count < this.contentLength) {
                throw new IOException("Unexpected end of Stream!");
            }
            if (r != -1) {
                ++this.count;
            }
            boolean bl = this.eof = r == -1;
            if (this.eof) {
                this.con.responseCompleted(this.chunked);
            }
            return r;
        }
        catch (IOException e) {
            if (!(e instanceof SocketTimeoutException)) {
                this.error = true;
                this.con.errorCleanup();
            }
            throw e;
        }
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.error) {
            throw new IOException("Stream is in Error State!");
        }
        if (this.eof) {
            return -1;
        }
        if (!this.chunked && this.contentLength >= 0L) {
            boolean bl = this.eof = (long)this.count == this.contentLength;
            if (this.eof) {
                this.con.responseCompleted(true);
                return -1;
            }
        }
        try {
            int r = this.lowerIn.read(b, off, len);
            if (r != -1) {
                this.count += r;
            }
            if (r == -1 && !this.chunked && this.contentLength >= 0L && (long)this.count < this.contentLength) {
                throw new IOException("Unexpected end of Stream!");
            }
            boolean bl = this.eof = r == -1;
            if (this.eof) {
                this.con.responseCompleted(this.chunked);
            }
            return r;
        }
        catch (IOException e) {
            if (!(e instanceof SocketTimeoutException)) {
                this.error = true;
                this.con.errorCleanup();
            }
            throw e;
        }
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    private void closeLowerIgnoreException() {
        try {
            this.lowerIn.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    synchronized void sleep(long millis) {
        try {
            this.wait(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.eof || this.closed) {
            return;
        }
        this.closed = true;
        if (!this.chunked && this.contentLength < 0L) {
            this.closeLowerIgnoreException();
            this.con.responseCompleted(false);
        } else {
            int i = 0;
            while (i < 10) {
                this.sleep(100L);
                if (this.eof) {
                    return;
                }
                ++i;
            }
            this.closeLowerIgnoreException();
            this.con.responseCompleted(false);
        }
    }
}

