/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import util.PipedSocketInputStream;
import util.PipedSocketOutputStream;

public class PipedSocket
extends Socket {
    private PipedSocket otherEndSocket;
    private PipedSocketInputStream in;
    private PipedSocketOutputStream out;
    String name;
    int id;
    static Integer ID = new Integer(0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PipedSocket(String name) throws IOException {
        Integer n = ID;
        synchronized (n) {
            ID = ID + 1;
            this.id = ID;
        }
        this.name = name;
        this.in = new PipedSocketInputStream();
        this.out = new PipedSocketOutputStream();
        this.otherEndSocket = new PipedSocket(this);
    }

    private PipedSocket(PipedSocket socket) throws IOException {
        this.id = socket.id;
        this.name = String.valueOf(socket.name) + "'";
        this.in = new PipedSocketInputStream();
        this.out = new PipedSocketOutputStream();
        this.otherEndSocket = socket;
        this.connectStreams();
    }

    private void connectStreams() throws IOException {
        this.in.connect(this.otherEndSocket.out);
        this.out.connect(this.otherEndSocket.in);
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.in;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.out;
    }

    @Override
    public void close() throws IOException {
        this.out.flush();
        this.out.close();
        this.in.close();
    }

    @Override
    public void shutdownInput() {
    }

    @Override
    public void shutdownOutput() {
    }

    @Override
    public void setSoTimeout(int to) {
        this.in.setTimeout(to);
    }

    @Override
    public String toString() {
        return String.valueOf(this.name) + "_" + this.id;
    }

    public Socket getOtherEnd() {
        return this.otherEndSocket;
    }
}

