/*
 * Decompiled with CFR 0.152.
 */
package udpproxy;

import java.io.IOException;
import java.io.InputStream;
import java.net.DatagramPacket;
import java.net.SocketTimeoutException;
import udpproxy.UDPBridge;
import util.Utils;

public class UDPResponse
extends InputStream {
    private UDPBridge udpBridge;
    private byte[] packet = null;
    private int remainingBytes = 0;
    private int length = 0;
    private boolean eof = false;

    public UDPResponse(UDPBridge udpBridge) {
        this.udpBridge = udpBridge;
    }

    @Override
    public synchronized int read() throws IOException {
        if (this.udpBridge.current_status == 1) {
            try {
                this.wait(this.udpBridge.getSoTimeout());
                if (this.udpBridge.current_status == 1) {
                    throw new SocketTimeoutException();
                }
            }
            catch (InterruptedException e) {
                throw new IOException(e.getMessage());
            }
        }
        if (this.udpBridge.current_status == 4) {
            this.eof = true;
            return -1;
        }
        if (this.remainingBytes == 0) {
            if (this.udpBridge.current_status == 2) {
                this.udpBridge.close();
                return -1;
            }
            DatagramPacket receivePacket = null;
            try {
                receivePacket = new DatagramPacket(new byte[this.udpBridge.bufSize], this.udpBridge.bufSize);
                this.udpBridge.datagramSocket.receive(receivePacket);
            }
            catch (IOException ioe) {
                if (this.udpBridge.current_status == 4) {
                    this.eof = true;
                    return -1;
                }
                throw ioe;
            }
            if (!this.udpBridge.serverMode) {
                byte[] dataSizeBytes = Utils.intToByteArray(receivePacket.getLength());
                this.packet = new byte[receivePacket.getLength() + 4];
                System.arraycopy(dataSizeBytes, 0, this.packet, 0, 4);
                System.arraycopy(receivePacket.getData(), receivePacket.getOffset(), this.packet, 4, receivePacket.getLength());
            } else {
                byte[] clientInfoBytes = (String.valueOf(receivePacket.getAddress().getHostAddress()) + ":" + receivePacket.getPort()).getBytes();
                byte[] clientInfoBytesSize = Utils.intToByteArray(clientInfoBytes.length);
                byte[] dataSizeBytes = Utils.intToByteArray(receivePacket.getLength());
                this.packet = new byte[8 + receivePacket.getLength() + clientInfoBytes.length];
                System.arraycopy(clientInfoBytesSize, 0, this.packet, 0, 4);
                System.arraycopy(dataSizeBytes, 0, this.packet, 4, 4);
                System.arraycopy(clientInfoBytes, 0, this.packet, 8, clientInfoBytes.length);
                System.arraycopy(receivePacket.getData(), receivePacket.getOffset(), this.packet, 8 + clientInfoBytes.length, receivePacket.getLength());
            }
            this.remainingBytes = this.length = this.packet.length;
        }
        int val = this.packet[this.length - this.remainingBytes] & 0xFF;
        --this.remainingBytes;
        return val;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.eof) {
            return -1;
        }
        int r = 0;
        int val = this.read();
        if (val == -1) {
            return -1;
        }
        int i = off;
        while (i < off + len) {
            if (val != -1) {
                ++r;
                b[i] = (byte)val;
            }
            if (val == -1 || this.remainingBytes <= 0) {
                return r;
            }
            if (i < off + len - 1) {
                val = this.read();
            }
            ++i;
        }
        return len;
    }

    @Override
    public void close() {
        this.udpBridge.close();
    }

    public void response(String response) {
        byte[] responsebytes = response.getBytes();
        byte[] packetSize = Utils.intToByteArray(responsebytes.length);
        this.packet = new byte[responsebytes.length + 4];
        System.arraycopy(packetSize, 0, this.packet, 0, 4);
        System.arraycopy(responsebytes, 0, this.packet, 4, responsebytes.length);
        this.remainingBytes = this.length = this.packet.length;
    }

    public void responseInitOK() {
        this.response("OK");
    }

    public void responseInitException(Exception e) {
        this.response("UDP Tunel Bridge Error during Init: " + e.toString());
    }
}

