/*
 * Decompiled with CFR 0.152.
 */
package udpproxy;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.Socket;
import java.net.SocketException;
import udpproxy.UDPRequest;
import udpproxy.UDPResponse;
import util.Logger;

public class UDPBridge
extends Socket {
    protected static final byte INIT = 1;
    protected static final byte INITERROR = 2;
    protected static final byte IO = 3;
    protected static final byte CLOSED = 4;
    protected byte current_status = 1;
    protected int bufSize = 1024;
    private UDPRequest request = new UDPRequest(this);
    private UDPResponse response = new UDPResponse(this);
    protected DatagramSocket datagramSocket = null;
    protected InetAddress destination = null;
    protected int destinationPort = -1;
    protected boolean serverMode = false;
    private int soTimeout = 0;

    @Override
    public OutputStream getOutputStream() {
        return this.request;
    }

    @Override
    public InputStream getInputStream() {
        return this.response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestPackageReceived(byte[] packet) throws IOException {
        if (this.current_status == 1) {
            this.initSession(packet);
            UDPResponse uDPResponse = this.response;
            synchronized (uDPResponse) {
                if (this.current_status != 2) {
                    this.current_status = (byte)3;
                }
                this.response.notifyAll();
            }
        } else {
            this.processRequestPackage(packet);
        }
    }

    private void processRequestPackage(byte[] packet) throws IOException {
        DatagramPacket sendPacket = new DatagramPacket(packet, packet.length, this.destination, this.destinationPort);
        this.datagramSocket.send(sendPacket);
    }

    private void initSession(byte[] initPacket) {
        String[] args = new String(initPacket).split(" ");
        try {
            this.serverMode = args[0].equalsIgnoreCase("server");
            this.destination = InetAddress.getByName(args[1]);
            this.destinationPort = Integer.parseInt(args[2]);
            this.bufSize = Integer.parseInt(args[3]);
            if (!this.serverMode) {
                if (!this.destination.isMulticastAddress()) {
                    this.datagramSocket = new DatagramSocket();
                } else {
                    this.datagramSocket = new MulticastSocket();
                    ((MulticastSocket)this.datagramSocket).joinGroup(this.destination);
                }
            } else {
                this.datagramSocket = new DatagramSocket(this.destinationPort, this.destination);
            }
            this.datagramSocket.setSoTimeout(this.soTimeout);
            this.response.responseInitOK();
        }
        catch (Exception e) {
            this.current_status = (byte)2;
            this.response.responseInitException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.current_status == 4) {
            return;
        }
        this.current_status = (byte)4;
        if (this.datagramSocket != null) {
            this.datagramSocket.close();
            Logger.getLogger().logLine("CLOSED:" + this.datagramSocket);
        }
        UDPResponse uDPResponse = this.response;
        synchronized (uDPResponse) {
            this.response.notifyAll();
        }
    }

    @Override
    public void setSoTimeout(int timeout) throws SocketException {
        this.soTimeout = timeout;
        if (this.datagramSocket != null) {
            this.datagramSocket.setSoTimeout(this.soTimeout);
        }
    }

    @Override
    public int getSoTimeout() {
        return this.soTimeout;
    }

    @Override
    public void shutdownInput() throws IOException {
    }

    @Override
    public void shutdownOutput() throws IOException {
    }
}

