/*
 * Decompiled with CFR 0.152.
 */
package mysoft.httptunnel.threadpool;

import java.util.Vector;
import mysoft.httptunnel.threadpool.PooledThread;

public class ThreadPool {
    Vector queue = new Vector();
    PooledThread[] threads = null;
    boolean stopped = false;

    public ThreadPool(int maxThreads) {
        this.threads = new PooledThread[maxThreads];
        int i = 0;
        while (i < maxThreads) {
            PooledThread thread = new PooledThread(this);
            new Thread(thread).start();
            this.threads[i] = thread;
            ++i;
        }
    }

    public synchronized Runnable getWork() throws InterruptedException {
        while (this.queue.size() == 0 && !this.stopped) {
            this.wait();
        }
        if (this.stopped) {
            return null;
        }
        return (Runnable)this.queue.remove(this.queue.size() - 1);
    }

    public synchronized void startThread(Runnable runnable) {
        this.queue.add(0, runnable);
        this.notifyAll();
    }

    public synchronized void stop() {
        this.stopped = true;
        this.notifyAll();
    }

    public synchronized boolean isStopped() {
        return this.stopped;
    }
}

