/*
 * Decompiled with CFR 0.152.
 */
package mysoft.httptunnel;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Hashtable;
import mysoft.httptunnel.DirectPassThroughSession;
import mysoft.httptunnel.HTTPTunnelSession;
import mysoft.httptunnel.TunnelServer;
import mysoft.httptunnel.TunnelSession;
import util.Encryption;
import util.Logger;
import util.Utils;
import util.http.HttpChunkedOutputStream;

public class TunnelSessionHandler {
    protected static Hashtable sessions = new Hashtable();
    private long lastSessionID = Long.MIN_VALUE;
    private boolean stopped = false;
    private DeadSessionCleanup deadSessionCleanup = new DeadSessionCleanup();

    public TunnelSessionHandler() {
        new Thread(this.deadSessionCleanup).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getNextSessionID() {
        Hashtable hashtable = sessions;
        synchronized (hashtable) {
            ++this.lastSessionID;
            return this.lastSessionID;
        }
    }

    private HTTPTunnelSession getTunnelSession(String sessionId) throws IOException {
        HTTPTunnelSession tunnelSession = (HTTPTunnelSession)sessions.get(sessionId);
        if (tunnelSession == null) {
            throw new IOException("Session does not exist - maybe already closed!" + sessionId);
        }
        return tunnelSession;
    }

    public OutputStream finalizeHeaderAndSendMsg(boolean chunked, boolean finalizeOutStream, int rccode, String returnMsg, byte[] additionalData, OutputStream plainOut) throws Exception {
        if (rccode == 0) {
            plainOut.write("HTTP/1.1 200 OK\r\n".getBytes());
        } else {
            plainOut.write("HTTP/1.1 202 Accepted\r\n".getBytes());
        }
        plainOut.write("Content-Type: binary\r\n".getBytes());
        plainOut.write("Server: localhost\r\n".getBytes());
        plainOut.write(("Keep-Alive: timeout=" + TunnelServer.CONREUSETIMEOUT + ", max=200\r\n").getBytes());
        plainOut.write("Connection: Keep-Alive\r\n".getBytes());
        byte[] msg = new byte[]{};
        if (returnMsg != null) {
            msg = (String.valueOf(returnMsg) + "\n").getBytes();
        }
        byte[] allMsg = msg;
        if (additionalData != null) {
            allMsg = new byte[msg.length + additionalData.length];
            System.arraycopy(msg, 0, allMsg, 0, msg.length);
            System.arraycopy(additionalData, 0, allMsg, msg.length, additionalData.length);
        }
        if (finalizeOutStream) {
            if (allMsg.length > 0) {
                ByteArrayOutputStream bytes = new ByteArrayOutputStream();
                OutputStream encr = Encryption.getEncryptedOutputStream(bytes, 1024);
                encr.write(allMsg);
                encr.flush();
                encr.close();
                allMsg = bytes.toByteArray();
            }
            if (!chunked) {
                plainOut.write(("Content-Length: " + allMsg.length + "\r\n").getBytes());
            }
        }
        if (chunked) {
            plainOut.write("Transfer-Encoding: chunked\r\n".getBytes());
        }
        plainOut.write("\r\n".getBytes());
        plainOut.flush();
        OutputStream encrout = null;
        if (chunked) {
            plainOut = new HttpChunkedOutputStream(plainOut);
        }
        if (finalizeOutStream) {
            plainOut.write(allMsg);
            plainOut.flush();
            if (chunked) {
                plainOut.close();
            }
        } else {
            encrout = Encryption.getEncryptedOutputStream(plainOut, TunnelServer.WRITE_BUFSIZE);
            encrout.write(allMsg);
            encrout.flush();
        }
        return encrout;
    }

    public boolean doSession(InputStream inStream, OutputStream out, Socket httpclient, boolean chunkedRequest) throws Exception {
        block33: {
            try {
                OutputStream plainOut = out;
                inStream = Encryption.getDecryptedStream(inStream);
                String mode = Utils.readLineFromStream(inStream);
                if (mode.equals("RECEIVER")) {
                    String clientID = Utils.readLineFromStream(inStream);
                    String host = Utils.readLineFromStream(inStream);
                    String portStr = Utils.readLineFromStream(inStream);
                    String conRefreshInterval = Utils.readLineFromStream(inStream);
                    String remoteAccessPerm = Utils.readLineFromStream(inStream);
                    byte conmode = (byte)inStream.read();
                    boolean doChunked = (conmode & Utils.CON_MODE_CHUNKED_RESPONSE) != 0;
                    boolean sessionDied = false;
                    try {
                        int port = Integer.parseInt(portStr);
                        this.checkPermission(host, port, remoteAccessPerm);
                        HTTPTunnelSession tunnelSession = new HTTPTunnelSession(clientID, host, port, Integer.parseInt(conRefreshInterval), conmode);
                        InetAddress remote = tunnelSession.connect(httpclient.getInetAddress().getHostAddress());
                        long sid = this.getNextSessionID();
                        String sessionId = Long.valueOf(sid).toString();
                        sessions.put(sessionId, tunnelSession);
                        OutputStream outStream = this.finalizeHeaderAndSendMsg(doChunked, false, 0, Long.valueOf(sid ^ Long.MAX_VALUE).toString(), Utils.serializeObject(remote), plainOut);
                        if ((conmode & Utils.CON_MODE_NETWORK_BLOCKS_INPUT) == 0) {
                            if (tunnelSession.runReceiverChannel(outStream, httpclient)) {
                                sessions.remove(sessionId);
                            }
                            sessionDied = tunnelSession.sessionDied();
                        }
                        try {
                            if (doChunked && !sessionDied) {
                                outStream.close();
                            }
                        }
                        catch (IOException eio) {
                            Logger.getLogger().logLine("Failed to finalize Output - Dead Http Client on " + host + ":" + portStr + " " + eio.toString());
                            sessionDied = true;
                        }
                        return doChunked && !sessionDied;
                    }
                    catch (Exception e) {
                        Logger.getLogger().logLine("Receiver Exception on " + host + ":" + portStr + " " + e.toString());
                        if (!sessionDied) {
                            this.finalizeHeaderAndSendMsg(false, true, 100, e.toString(), null, plainOut);
                        }
                        break block33;
                    }
                }
                if (mode.equals("RESOLVE")) {
                    String host = Utils.readLineFromStream(inStream);
                    try {
                        InetAddress remote = InetAddress.getByName(host);
                        this.finalizeHeaderAndSendMsg(false, true, 0, null, Utils.serializeObject(remote), plainOut);
                    }
                    catch (Exception e) {
                        Logger.getLogger().logLine("RESOLVE failed:" + e.toString());
                        this.finalizeHeaderAndSendMsg(false, true, 100, e.toString(), null, plainOut);
                    }
                    break block33;
                }
                if (mode.equals("RECEIVER_RETRY")) {
                    String sessionId = "";
                    boolean sessionDied = false;
                    try {
                        sessionId = Utils.readLineFromStream(inStream);
                        HTTPTunnelSession tunnelSession = this.getTunnelSession(sessionId);
                        boolean doChunked = (tunnelSession.getMode() & Utils.CON_MODE_CHUNKED_RESPONSE) != 0;
                        tunnelSession.retryReceiverChannel(new Long(Utils.readLineFromStream(inStream)));
                        OutputStream outStream = this.finalizeHeaderAndSendMsg(doChunked, false, 0, null, null, plainOut);
                        if (tunnelSession.runReceiverChannel(outStream, httpclient)) {
                            sessions.remove(sessionId);
                        }
                        sessionDied = tunnelSession.sessionDied();
                        if (doChunked && !sessionDied) {
                            try {
                                outStream.close();
                            }
                            catch (Exception eio) {
                                Logger.getLogger().logLine("Failed to finalize Output - Dead Http Client on " + tunnelSession + " " + eio.toString());
                                sessionDied = true;
                            }
                        }
                        return doChunked && !sessionDied;
                    }
                    catch (Exception e) {
                        sessions.remove(sessionId);
                        Logger.getLogger().logLine("Retry failed:" + e.toString());
                        if (!sessionDied) {
                            this.finalizeHeaderAndSendMsg(false, true, 100, e.toString(), null, plainOut);
                        }
                        break block33;
                    }
                }
                if (mode.equals("SENDER")) {
                    HTTPTunnelSession tunnelSession = null;
                    try {
                        String sessionId = Utils.readLineFromStream(inStream);
                        tunnelSession = this.getTunnelSession(sessionId);
                        tunnelSession.sendStream(inStream, chunkedRequest, httpclient);
                        this.finalizeHeaderAndSendMsg(false, true, 0, null, null, plainOut);
                        break block33;
                    }
                    catch (Exception e) {
                        Logger.getLogger().logLine("Sent failed:" + e.toString());
                        if (tunnelSession != null && !tunnelSession.sessionDied()) {
                            try {
                                this.finalizeHeaderAndSendMsg(false, true, 100, e.toString(), null, plainOut);
                            }
                            catch (Exception e2) {
                                Logger.getLogger().logLine("finalize failed:" + e2.toString());
                            }
                        }
                        return !chunkedRequest;
                    }
                }
                if (mode.equals("CLOSE_SESSION")) {
                    try {
                        String sessionId = Utils.readLineFromStream(inStream);
                        HTTPTunnelSession tunnelSession = this.getTunnelSession(sessionId);
                        sessions.remove(sessionId);
                        tunnelSession.closeSession();
                        this.finalizeHeaderAndSendMsg(false, true, 0, null, null, plainOut);
                    }
                    catch (Exception e) {
                        Logger.getLogger().logLine("Close failed:" + e.toString());
                        this.finalizeHeaderAndSendMsg(false, true, 100, e.toString(), null, plainOut);
                    }
                    break block33;
                }
                try {
                    Logger.getLogger().logLine("Invalid Command! - connection will be closed!");
                    plainOut.write("\r\n".getBytes());
                    plainOut.write("Error - Invalid Data!".getBytes());
                    plainOut.flush();
                }
                catch (Exception exc) {
                    this.finalizeHeaderAndSendMsg(false, true, 100, "Invalid Data!", null, plainOut);
                    Logger.getLogger().logException(exc);
                }
                return false;
            }
            catch (Exception e) {
                Logger.getLogger().logException(e);
                return false;
            }
        }
        return true;
    }

    private void checkPermission(String host, int port, String remoteAccessPerm) throws IOException {
        if (!(!TunnelServer.RESTRICT_REMOTE || TunnelServer.REMOTE_PERM_TOKEN.equals(remoteAccessPerm) || host.toLowerCase().equals("localhost") || host.startsWith("127.0.0") || host.equals("::1") || host.equals("$WATCHDOG$"))) {
            throw new IOException("Only Access to localhost is permitted!");
        }
    }

    public void handleDirectPassThroughSession(Socket client) throws IOException {
        InputStream in = Encryption.getDecryptedStream(client.getInputStream());
        OutputStream out = Encryption.getEncryptedOutputStream(client.getOutputStream(), TunnelServer.WRITE_BUFSIZE);
        long randomLong = (long)(Math.random() * 9.223372036854776E18);
        out.write((String.valueOf(randomLong ^ Long.MAX_VALUE) + "\n").getBytes());
        out.flush();
        try {
            long responseLong = Long.parseLong(Utils.readLineFromStream(in));
            if (responseLong != randomLong) {
                throw new IOException("Response doesn't match!");
            }
            Logger.getLogger().logLine("Handshake OK");
        }
        catch (Exception e) {
            throw new IOException("Handshake for DirectPassThroughConnection failed:" + e.toString());
        }
        try {
            String cmd = Utils.readLineFromStream(in);
            if (cmd.equals("CONNECT")) {
                String clientID = Utils.readLineFromStream(in);
                String host = Utils.readLineFromStream(in);
                int port = Integer.parseInt(Utils.readLineFromStream(in));
                String remoteAccessPerm = Utils.readLineFromStream(in);
                this.checkPermission(host, port, remoteAccessPerm);
                if (!clientID.equals("<not_set>") && !host.equals("$WATCHDOG$") && sessions.get(clientID) == null) {
                    throw new IOException("Invalid Client: " + clientID + "! No client watcher for this client is registered!");
                }
                DirectPassThroughSession session = new DirectPassThroughSession(clientID, in, out, host, port);
                session.connect(client.getInetAddress().getHostAddress());
                String id = host.equals("$WATCHDOG$") ? this.register(session, clientID) : this.register(session, null);
                session.doSession();
                sessions.remove(id);
            }
            if (cmd.equals("ATTACH")) {
                String id = Utils.readLineFromStream(in);
                Object tunnelSession = sessions.get(id);
                if (tunnelSession == null || !(tunnelSession instanceof DirectPassThroughSession)) {
                    throw new Exception("Received TunnelSession " + tunnelSession + " for id " + id);
                }
                ((DirectPassThroughSession)tunnelSession).attachClient(in, out);
                ((DirectPassThroughSession)tunnelSession).doSession();
                sessions.remove(id);
            }
        }
        catch (Exception e) {
            Logger.getLogger().logLine("Exception during init of DirectPassThrough:" + e.getMessage());
            out.write((String.valueOf(e.getMessage()) + "\n").getBytes());
            out.flush();
        }
    }

    public String register(Object tunnelSession, String id) {
        String sessionId = id;
        if (sessionId == null) {
            sessionId = new Long(this.getNextSessionID()).toString();
        }
        sessions.put(sessionId, tunnelSession);
        return sessionId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        DeadSessionCleanup deadSessionCleanup = this.deadSessionCleanup;
        synchronized (deadSessionCleanup) {
            this.stopped = true;
            this.deadSessionCleanup.notifyAll();
        }
    }

    public void invalidateSessions(String clientId) {
        Object[] all = sessions.keySet().toArray();
        int i = 0;
        while (i < all.length) {
            TunnelSession session = (TunnelSession)sessions.get(all[i]);
            if (session != null && session.getClientId().equals(clientId)) {
                session.setInvalid();
            }
            ++i;
        }
    }

    private class DeadSessionCleanup
    implements Runnable {
        private DeadSessionCleanup() {
        }

        @Override
        public synchronized void run() {
            while (!TunnelSessionHandler.this.stopped) {
                try {
                    Object[] all = sessions.keySet().toArray();
                    int i = 0;
                    while (i < all.length) {
                        TunnelSession session = (TunnelSession)sessions.get(all[i]);
                        if (session != null && !session.isAlive()) {
                            Logger.getLogger().logLine("Dead Session Cleanup - removing: " + session);
                            session.killSession();
                            sessions.remove(all[i]);
                        }
                        ++i;
                    }
                    if (TunnelServer.biDirectionalTunnel != null) {
                        TunnelServer.biDirectionalTunnel.aliveCheck();
                    }
                    this.wait(5000L);
                }
                catch (Exception e) {
                    Logger.getLogger().logException(e);
                }
            }
            Logger.getLogger().logLine("DeadSessionCleanup terminated!");
        }
    }
}

