/*
 * Decompiled with CFR 0.152.
 */
package mysoft.httptunnel;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Proxy;
import java.util.Properties;
import util.BASE64Encoder;
import util.Logger;
import util.Utils;
import util.http.HttpURLConnection;
import util.http.URL;

public class DynIPPublisher {
    public static void publishToDynDNS(String ip, String urlStr, String user, String pwd) {
        try {
            urlStr = urlStr.replace("${IP}", ip);
            Logger.getLogger().logLine("Processing publishing to DYN DNS Service via URL:" + urlStr);
            URL url = new URL(urlStr);
            HttpURLConnection receiver = url.openConnection(Proxy.NO_PROXY);
            String dynDNSAuth = null;
            if (user != null && !user.equals("")) {
                dynDNSAuth = "Basic " + new BASE64Encoder().encode((String.valueOf(user) + ":" + pwd).getBytes());
            }
            if (dynDNSAuth != null) {
                receiver.setRequestProperty("Authorization", dynDNSAuth);
            }
            receiver.setConnectTimeout(100000);
            receiver.setReadTimeout(100000);
            InputStream in = receiver.getInputStream();
            String response = new String(Utils.readFully(in, 256));
            Logger.getLogger().logLine("");
            Logger.getLogger().logLine(">>> BEGIN MESSAGE RECEIVED FROM DYN DNS REGISTRATION!");
            Logger.getLogger().logLine(response);
            Logger.getLogger().logLine(">>> END MESSAGE RECEIVED FROM DYN DNS REGISTRATION!");
            Logger.getLogger().logLine("");
        }
        catch (IOException eio) {
            Logger.getLogger().logLine("Failed to publish IP to external Dyn DNS Service: " + eio.toString());
        }
    }

    public static void main(String[] args) throws IOException {
        if (args.length == 0) {
            Logger.getLogger().logLine("Missing param! provide IP as parameter!");
            System.exit(-1);
        }
        String ip = args[0];
        Properties config = new Properties();
        FileInputStream in = new FileInputStream("dynip.cfg");
        config.load(in);
        in.close();
        String[] entries = config.keySet().toArray(new String[config.size()]);
        int i = 0;
        while (i < entries.length) {
            String entry = entries[i];
            if (entry.toLowerCase().startsWith("url.")) {
                String url = config.getProperty(entry).trim();
                String domain = entry.substring(4);
                String user = config.getProperty("user." + domain, "").trim();
                String pwd = config.getProperty("password." + domain, "").trim();
                Logger.getLogger().logLine("Publishing IP '" + ip + "' for domain " + domain);
                DynIPPublisher.publishToDynDNS(ip, url, user, pwd);
                Logger.getLogger().logLine("");
            }
            ++i;
        }
    }
}

