/*
 * Decompiled with CFR 0.152.
 */
package httpproxy;

import httpproxy.ChunkedDataTransfer;
import httpproxy.HttpProxyServer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class HttpProxyRequest
extends OutputStream {
    private static int HEADEREND = 0xD0A0D0A;
    private HttpProxyServer server;
    private int last4Bytes = 0;
    private ByteArrayOutputStream headerBytes = null;
    boolean ssl = false;
    private long reqContentLength = 0L;
    private int bytesBodySent = 0;
    private boolean chunked;
    private ChunkedDataTransfer chunkedTransfer;
    private OutputStream sslOut;
    private boolean closed = false;

    public HttpProxyRequest(HttpProxyServer server) {
        this.server = server;
    }

    public synchronized void initRequest() {
        this.last4Bytes = 0;
        this.headerBytes = new ByteArrayOutputStream();
        this.ssl = false;
        this.server.current_status = 1;
        this.notifyAll();
    }

    @Override
    public void write(int b) throws IOException {
        this.write(new byte[]{(byte)b}, 0, 1);
    }

    @Override
    public synchronized void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public synchronized void write(byte[] b, int offs, int len) throws IOException {
        this.server.resetIdleTimeOut();
        boolean processed = false;
        while (!processed) {
            int processedBytes = 0;
            if (this.closed) {
                throw new IOException("Server already closed!");
            }
            if (this.server.current_status == 1) {
                this.last4Bytes = (this.last4Bytes << 8) + (b[offs] & 0xFF);
                processedBytes = 1;
                this.headerBytes.write(b[offs] & 0xFF);
                if (this.last4Bytes == HEADEREND) {
                    this.headerBytes.flush();
                    this.server.requestHeaderReceived(this.headerBytes.toByteArray());
                    this.headerBytes = null;
                }
            } else if (this.server.current_status == 4) {
                processed = true;
                processedBytes = this.writeRequestBody(b, offs, len);
            } else if (this.ssl) {
                this.sslOut.write(b, offs, len);
                processedBytes = len;
            } else {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    throw new IOException(e.getMessage());
                }
            }
            offs += processedBytes;
            boolean bl = processed = (len -= processedBytes) == 0;
        }
    }

    public int writeRequestBody(byte[] b, int offs, int len) throws IOException {
        if (!this.chunked) {
            int cnt = (int)Math.min((long)len, this.reqContentLength - (long)this.bytesBodySent);
            this.server.httpSrv_Out.write(b, offs, cnt);
            this.bytesBodySent += cnt;
            if ((long)this.bytesBodySent == this.reqContentLength) {
                this.server.requestComplete();
            }
            return cnt;
        }
        boolean chunkFinal = !this.chunkedTransfer.write(b, offs, len);
        int processedBytes = this.chunkedTransfer.lastBytesProcessed;
        if (chunkFinal) {
            this.chunkedTransfer = null;
            this.server.requestComplete();
        }
        return processedBytes;
    }

    public synchronized void startSSL() {
        this.ssl = true;
        this.sslOut = this.server.httpSrv_Out;
        if (this.sslOut == null) {
            this.closed = true;
        }
        this.notifyAll();
    }

    @Override
    public void close() {
        this.server.close();
    }

    public synchronized void closeRequest() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.sslOut = null;
        this.notifyAll();
    }

    @Override
    public synchronized void flush() throws IOException {
        if (this.closed) {
            return;
        }
        if (!this.ssl && this.server.current_status != 4) {
            return;
        }
        if (this.ssl) {
            this.sslOut.flush();
        } else if (this.server.httpSrv_Out != null) {
            this.server.httpSrv_Out.flush();
        }
    }

    public void initRequestBody(long reqContentLength, boolean chunked) {
        this.chunked = chunked;
        this.reqContentLength = reqContentLength;
        this.bytesBodySent = 0;
        if (chunked) {
            this.chunkedTransfer = new ChunkedDataTransfer(this.server.httpSrv_Out);
        }
    }
}

