/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.IOException;
import java.io.OutputStream;
import util.XORKey;

public class XOROutputStream
extends OutputStream {
    OutputStream m_outStream;
    long keyPos = -2L;
    private static long LAST_STARTPOS = -2L;
    private static Object LAST_STARTPOS_MONITOR = new Object();

    public XOROutputStream(OutputStream outStream, long keyPos) throws IOException {
        if (XORKey.keyBytes == null) {
            throw new IOException("XOR Key not initialized!");
        }
        this.keyPos = keyPos;
        this.m_outStream = outStream;
        if (keyPos != -2L) {
            this.m_outStream.write((int)keyPos);
        }
    }

    public XOROutputStream(OutputStream outStream) throws IOException {
        this(outStream, -2L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(int b) throws IOException {
        if (this.keyPos == -2L) {
            Object object = LAST_STARTPOS_MONITOR;
            synchronized (object) {
                while (this.keyPos == LAST_STARTPOS || this.keyPos == -2L) {
                    double randomVal = Math.random() * 255.0;
                    this.keyPos = (int)randomVal;
                }
                LAST_STARTPOS = this.keyPos;
            }
            this.m_outStream.write((int)this.keyPos);
        }
        int keyOffs = (int)(this.keyPos % (long)XORKey.keyBytes.length);
        ++this.keyPos;
        this.m_outStream.write(b ^ XORKey.keyBytes[keyOffs] & 0xFF);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        if (this.keyPos == -2L) {
            double randomVal = Math.random() * 255.0;
            this.keyPos = (int)randomVal;
            this.m_outStream.write((int)this.keyPos);
        }
        int i = off;
        while (i < len + off) {
            b[i] = (byte)this.xor(b[i] & 0xFF);
            ++i;
        }
        this.m_outStream.write(b, off, len);
    }

    private int xor(int b) {
        int keyOffs = (int)(this.keyPos % (long)XORKey.keyBytes.length);
        ++this.keyPos;
        return b ^ XORKey.keyBytes[keyOffs] & 0xFF;
    }

    @Override
    public void flush() throws IOException {
        this.m_outStream.flush();
    }

    @Override
    public void close() throws IOException {
        this.m_outStream.close();
    }

    public static int getEncryptedLength(byte[] msg) {
        return msg.length + 1;
    }
}

