/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.RandomAccess;
import util.ObjectPackagingManager;

public class PackedSortedList
implements List,
RandomAccess {
    private boolean inMemory;
    private int object_size;
    private byte[] datapack = null;
    private int count = 0;
    private File persistedPackFile;
    private RandomAccessFile persistedPackData = null;
    private ObjectPackagingManager objMgr;

    public PackedSortedList(int size, ObjectPackagingManager objMgr) {
        this.objMgr = objMgr;
        this.object_size = objMgr.objectSize();
        this.datapack = new byte[size * this.object_size];
        this.inMemory = true;
    }

    private PackedSortedList(byte[] datapack, int count, boolean inMemory, File persistedPackFile, ObjectPackagingManager objMgr) {
        this.objMgr = objMgr;
        this.object_size = objMgr.objectSize();
        this.datapack = datapack;
        this.count = count;
        this.inMemory = inMemory;
        this.persistedPackFile = persistedPackFile;
    }

    private int binarySearch(Object key) {
        return Collections.binarySearch(this, key);
    }

    @Override
    public boolean add(Object key) {
        int pos = -(this.binarySearch(key) + 1);
        if (pos < 0) {
            return false;
        }
        this.addInternal(pos, key);
        return true;
    }

    private void addInternal(int pos, Object key) {
        if (pos != this.count) {
            System.arraycopy(this.datapack, pos * this.object_size, this.datapack, pos * this.object_size + this.object_size, (this.count - pos) * this.object_size);
        }
        this.objMgr.objectToBytes(key, this.datapack, pos * this.object_size);
        ++this.count;
    }

    public void add(int arg0, Object arg1) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection collection) {
        Iterator it = collection.iterator();
        while (it.hasNext()) {
            this.add(it.next());
        }
        return true;
    }

    public boolean addAll(int arg0, Collection arg1) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    private void releaseDataPack(boolean openedDataPack) {
        if (openedDataPack) {
            try {
                this.persistedPackData.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.persistedPackData = null;
        }
    }

    private boolean aquireDataPack() throws FileNotFoundException {
        if (this.persistedPackData == null) {
            this.persistedPackData = new RandomAccessFile(this.persistedPackFile, "r");
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object key) {
        int pos = -1;
        if (!this.inMemory) {
            PackedSortedList packedSortedList = this;
            synchronized (packedSortedList) {
                boolean openedDataPack = false;
                try {
                    try {
                        openedDataPack = this.aquireDataPack();
                        pos = this.binarySearch(key);
                    }
                    catch (Exception e) {
                        throw new IllegalStateException(e);
                    }
                }
                finally {
                    this.releaseDataPack(openedDataPack);
                }
            }
        }
        pos = this.binarySearch(key);
        return pos > -1;
    }

    @Override
    public boolean containsAll(Collection arg0) {
        throw new UnsupportedOperationException();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object get(int pos) {
        if (pos >= this.count) {
            return null;
        }
        int offs = pos * this.object_size;
        if (this.inMemory) {
            return this.objMgr.bytesToObject(this.datapack, offs);
        }
        PackedSortedList packedSortedList = this;
        synchronized (packedSortedList) {
            boolean openedDataPack = false;
            try {
                openedDataPack = this.aquireDataPack();
                this.persistedPackData.seek(offs);
                byte[] obj = new byte[this.object_size];
                this.persistedPackData.readFully(obj);
                Object object = this.objMgr.bytesToObject(obj, 0);
                return object;
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
            finally {
                this.releaseDataPack(openedDataPack);
            }
        }
    }

    @Override
    public int indexOf(Object arg0) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEmpty() {
        return this.count == 0;
    }

    @Override
    public Iterator iterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int lastIndexOf(Object arg0) {
        throw new UnsupportedOperationException();
    }

    public ListIterator listIterator() {
        throw new UnsupportedOperationException();
    }

    public ListIterator listIterator(int arg0) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object arg0) {
        throw new UnsupportedOperationException();
    }

    public Object remove(int arg0) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection arg0) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection arg0) {
        throw new UnsupportedOperationException();
    }

    public Object set(int arg0, Object arg1) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return this.count;
    }

    public List subList(int arg0, int arg1) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object[] toArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object[] toArray(Object[] arg0) {
        throw new UnsupportedOperationException();
    }

    public void persist(String path) throws IOException {
        if (!this.inMemory) {
            throw new IOException("PackedSortedList can not be persisted when not in Memory!");
        }
        FileOutputStream out = new FileOutputStream(path);
        out.write(this.datapack, 0, this.count * this.object_size);
        out.flush();
        out.close();
    }

    public static PackedSortedList load(String path, boolean inMemory, ObjectPackagingManager objMgr) throws IOException {
        File f = new File(path);
        int size = (int)f.length();
        if (!f.exists() || !f.canRead()) {
            throw new IOException("Cannot read " + path);
        }
        byte[] buf = null;
        if (inMemory) {
            FileInputStream in = new FileInputStream(f);
            buf = new byte[size];
            int r = 0;
            int offs = 0;
            while ((r = in.read(buf, offs, size - offs)) != -1 && offs != size) {
                offs += r;
            }
            in.close();
        }
        return new PackedSortedList(buf, size / objMgr.objectSize(), inMemory, f, objMgr);
    }

    public void clearAndReleaseAllMemory() {
        this.count = 0;
        this.datapack = new byte[0];
    }
}

