/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.util.Calendar;
import util.Logger;

public class DateRetriever
implements Runnable {
    private static int PRECISION_MILLIS = 1000;
    private static DateRetriever RETRIEVER_INSTANCE = new DateRetriever();
    private Thread _thread = null;
    private String current;
    private boolean picked = false;

    public static String getDateString() {
        return RETRIEVER_INSTANCE.retrieveDateString();
    }

    private String int2Str(int val) {
        if (val < 10) {
            return "0" + val;
        }
        return "" + val;
    }

    private String dateStr(Calendar cal) {
        return String.valueOf(this.int2Str(cal.get(2) + 1)) + "/" + this.int2Str(cal.get(5)) + "/" + cal.get(1) + " " + this.int2Str(cal.get(11)) + ":" + this.int2Str(cal.get(12)) + ":" + this.int2Str(cal.get(13));
    }

    private synchronized String retrieveDateString() {
        this.picked = true;
        if (this._thread != null) {
            return this.current;
        }
        this.current = this.dateStr(Calendar.getInstance());
        this._thread = new Thread(this);
        this._thread.setDaemon(true);
        this._thread.start();
        return this.current;
    }

    private void waitMillis(long millis) {
        try {
            this.wait(millis);
        }
        catch (InterruptedException e) {
            Logger.getLogger().logException(e);
        }
    }

    @Override
    public synchronized void run() {
        this._thread = Thread.currentThread();
        this.waitMillis(PRECISION_MILLIS);
        while (this.picked) {
            this.current = this.dateStr(Calendar.getInstance());
            this.picked = false;
            this.waitMillis(PRECISION_MILLIS);
        }
        this._thread = null;
    }
}

