/*
 * Decompiled with CFR 0.152.
 */
package upnp;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.SocketTimeoutException;
import java.util.HashMap;
import java.util.Vector;
import upnp.UpnpProxyManager;
import util.Logger;

public class UpnpSearchRequestProcessor
implements Runnable {
    UpnpProxyManager proxy;
    MulticastSocket listener;
    boolean stopped = false;

    public UpnpSearchRequestProcessor(UpnpProxyManager proxy) throws IOException {
        this.proxy = proxy;
        this.go();
    }

    private void go() {
        try {
            this.listener = new MulticastSocket(1900);
            this.listener.joinGroup(InetAddress.getByName("239.255.255.250"));
            new Thread(this).start();
        }
        catch (IOException e) {
            Logger.getLogger().logLine(e.toString());
        }
    }

    private String getClientKey(DatagramPacket req) {
        return String.valueOf(req.getAddress().getHostAddress()) + ":" + req.getPort();
    }

    private boolean checkClientReq(DatagramPacket req) {
        if (this.proxy.localOnly && !this.proxy.localIPs.contains(req.getAddress().getHostAddress())) {
            if (this.proxy.debug) {
                Logger.getLogger().logLine("Search Request from remote host " + req.getAddress().getHostAddress() + " is disabled!");
            }
            return false;
        }
        return true;
    }

    @Override
    public synchronized void run() {
        this.stopped = false;
        Logger.getLogger().logLine("DLNASearchRequestProcessor started!");
        while (!this.stopped) {
            try {
                DatagramPacket req = new DatagramPacket(new byte[8192], 8192);
                this.listener.receive(req);
                if (!this.checkClientReq(req)) continue;
                Logger.getLogger().logLine("Received Request:" + req.getSocketAddress());
                Vector<DatagramPacket> requests = new Vector<DatagramPacket>();
                requests.addElement(req);
                HashMap<String, Vector<DatagramPacket>> allClients = new HashMap<String, Vector<DatagramPacket>>();
                allClients.put(this.getClientKey(req), requests);
                this.listener.setSoTimeout(100);
                boolean timedOut = false;
                int count = 0;
                while (!timedOut || count == 50) {
                    try {
                        req = new DatagramPacket(new byte[8192], 8192);
                        ++count;
                        this.listener.receive(req);
                        if (!this.checkClientReq(req)) continue;
                        Logger.getLogger().logLine("Received Request:" + req.getSocketAddress());
                        requests = (Vector<DatagramPacket>)allClients.get(this.getClientKey(req));
                        if (requests == null) {
                            requests = new Vector<DatagramPacket>();
                            allClients.put(this.getClientKey(req), requests);
                        }
                        requests.addElement(req);
                    }
                    catch (SocketTimeoutException sto) {
                        timedOut = true;
                    }
                }
                this.listener.setSoTimeout(0);
                Vector[] allClientRequests = allClients.values().toArray(new Vector[0]);
                int i = 0;
                while (i < allClientRequests.length) {
                    DatagramPacket[] allreq = allClientRequests[i].toArray(new DatagramPacket[0]);
                    this.proxy.sendDLNAResponse(this.listener, allreq);
                    ++i;
                }
            }
            catch (IOException e) {
                if (this.stopped) continue;
                Logger.getLogger().logLine(e.getMessage());
            }
        }
        Logger.getLogger().logLine("DLNASearchRequestProcessor stopped!");
    }

    public void stop() {
        this.stopped = true;
        if (this.listener != null) {
            this.listener.close();
        }
    }

    public void networkStateChanged() throws IOException {
        this.stopped = true;
        if (this.listener != null) {
            this.listener.close();
        }
        this.go();
    }
}

