/*
 * Decompiled with CFR 0.152.
 */
package upnp;

import httpproxy.HttpProxyServer;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.HashSet;
import upnp.UpnpHttpProcessor;
import upnp.UpnpProxyManager;
import upnp.UpnpSessionProcessor;
import util.Logger;
import util.Utils;

public class UpnpProxy
implements Runnable {
    public static String WORKDIR = "";
    protected String localIP;
    protected int localPort;
    private Socket client = null;
    private HttpProxyServer server = null;
    private boolean closed = false;
    private boolean MAINLOOP = false;
    private boolean stopped = false;
    private ServerSocket acceptSocket = null;
    private boolean listenerStopped = false;
    private boolean localOnly = true;
    private HashSet openConnections;
    private UpnpProxyManager proxyMgr = null;
    public boolean debug = false;

    public UpnpProxy() {
    }

    private UpnpProxy(int localPort, Socket clientSocket, boolean debug) {
        this.localIP = clientSocket.getLocalAddress().getHostAddress();
        this.localPort = localPort;
        this.client = clientSocket;
        this.debug = debug;
    }

    public UpnpProxy(UpnpProxyManager proxyMgr, int localPort, boolean localOnly, boolean debug) throws IOException {
        this.proxyMgr = proxyMgr;
        this.localPort = localPort;
        this.localOnly = localOnly;
        this.debug = debug;
        if (debug) {
            Utils.deleteFolder(String.valueOf(WORKDIR) + "log/upnpdebug");
        }
        this.MAINLOOP = true;
        this.openConnections = new HashSet();
        this.acceptSocket = this.openListener();
        new Thread(this).start();
    }

    public void close(Socket s) {
        try {
            s.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized void cleanUp(int code, String transmitter) {
        if (this.closed) {
            return;
        }
        Logger.getLogger().logLine("UPnP Proxy:" + transmitter + " closed!");
        this.close(this.server);
        this.close(this.client);
        this.closed = true;
    }

    public boolean go() {
        try {
            this.server = (HttpProxyServer)this.connectServer();
        }
        catch (Exception e) {
            Logger.getLogger().logLine("UPnP Proxy: Connection failed!");
            Logger.getLogger().logLine(e.toString());
            return false;
        }
        try {
            UpnpSessionProcessor c = new UpnpSessionProcessor(this.client, this.server, this);
            c.start();
            return true;
        }
        catch (IOException e) {
            this.close(this.server);
            this.close(this.client);
            Logger.getLogger().logException(e);
            return false;
        }
    }

    public Socket connectServer() throws Exception {
        UpnpHttpProcessor con = new UpnpHttpProcessor();
        return con;
    }

    ServerSocket openListener() throws IOException {
        return new ServerSocket(this.localPort);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UpnpProxy createProxy(int localPort, Socket clientSocket, boolean debug) {
        HashSet hashSet = this.openConnections;
        synchronized (hashSet) {
            UpnpProxy con = new UpnpProxy(localPort, clientSocket, debug);
            this.openConnections.add(con);
            return con;
        }
    }

    @Override
    public void run() {
        if (this.MAINLOOP) {
            this.runListenerLoop();
        } else if (!this.go()) {
            try {
                this.client.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runListenerLoop() {
        int port = this.acceptSocket.getLocalPort();
        Logger.getLogger().logLine("UPnP Proxy:Waiting for Connections on port " + port + "...");
        while (!this.stopped) {
            try {
                Socket client = this.acceptSocket.accept();
                if (this.localOnly && !this.proxyMgr.isLocalIP(client.getInetAddress().getHostAddress())) {
                    Logger.getLogger().logLine("UPnP Proxy:Non local Access refused due to localOnly setting! Socket:" + client);
                    client.close();
                    continue;
                }
                Logger.getLogger().logLine("UPnP Proxy: Got Connection...");
                UpnpProxy proxy = this.createProxy(this.localPort, client, this.debug);
                new Thread(proxy).start();
            }
            catch (Exception e0) {
                UpnpProxy upnpProxy = this;
                synchronized (upnpProxy) {
                    if (!this.stopped) {
                        Logger.getLogger().logLine("UPnP Proxy:" + e0.toString());
                    }
                    this.listenerStopped = true;
                    this.notifyAll();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void killSessions() {
        Object[] proxies;
        HashSet hashSet = this.openConnections;
        synchronized (hashSet) {
            proxies = this.openConnections.toArray();
            this.openConnections.clear();
        }
        int i = 0;
        while (i < proxies.length) {
            ((UpnpProxy)proxies[i]).close(((UpnpProxy)proxies[i]).server);
            ++i;
        }
    }

    public synchronized void stop() {
        if (!this.MAINLOOP) {
            throw new IllegalStateException("Stop only possible on Main Loop Instance!;");
        }
        this.killSessions();
        this.stopped = true;
        try {
            int port = this.acceptSocket.getLocalPort();
            this.acceptSocket.close();
            Logger.getLogger().logLine("UPnP Proxy:Stopped Proxy Listener on Port " + port + "!");
            while (!this.listenerStopped) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    Logger.getLogger().logException(e);
                    return;
                }
            }
        }
        catch (IOException e) {
            Logger.getLogger().logException(e);
        }
    }
}

