/*
 * Decompiled with CFR 0.152.
 */
package udpproxy;

import httptunnel.HttpTunnelConnection;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import util.Logger;
import util.TimeoutListener;
import util.TimeoutTime;
import util.TimoutNotificator;
import util.Utils;

public class DirectUDPSession
implements TimeoutListener {
    private HttpTunnelConnection con;
    private DataInputStream conIn;
    private OutputStream conOut;
    private TimoutNotificator toNotify = TimoutNotificator.getInstance();
    private TimeoutTime timeout = new TimeoutTime(this.toNotify);
    private long to = 0L;
    private boolean closed = false;

    public DirectUDPSession(InetAddress adr, int port, int bufSize, int to) throws IOException {
        try {
            this.to = to;
            this.con = new HttpTunnelConnection("$UDPBRIDGE$", 0, true);
            this.conIn = new DataInputStream(this.con.getInputStream());
            this.conOut = this.con.getOutputStream();
            byte[] initPackage = ("client " + adr.getHostAddress() + " " + port + " " + bufSize).getBytes();
            byte[] packetSize = Utils.intToByteArray(initPackage.length);
            this.conOut.write(packetSize);
            this.conOut.write(initPackage);
            this.conOut.flush();
            byte[] response = new byte[this.conIn.readInt()];
            this.conIn.readFully(response);
            String responseStr = new String(response);
            if (!responseStr.equals("OK")) {
                try {
                    this.con.close();
                }
                catch (IOException ioe) {
                    Logger.getLogger().logLine(ioe.getMessage());
                }
                throw new IOException(responseStr);
            }
            this.timeout.setTimeout(to);
            this.toNotify.register(this);
        }
        catch (IOException ioe) {
            if (this.con != null) {
                this.con.close();
            }
            throw ioe;
        }
    }

    public void requestPackage(byte[] req) throws IOException {
        try {
            this.timeout.setTimeout(this.to);
            this.conOut.write(Utils.intToByteArray(req.length));
            this.conOut.write(req, 0, req.length);
            this.conOut.flush();
        }
        catch (IOException e) {
            Logger.getLogger().log("Exception during dispatch:" + e.getMessage());
            this.close();
            throw e;
        }
    }

    public byte[] readResponsePackage() throws IOException {
        int size;
        block4: {
            try {
                byte[] packetSize = new byte[4];
                this.timeout.setTimeout(this.to);
                this.conIn.readFully(packetSize);
                size = Utils.byteArrayToInt(packetSize);
                if (size != -1) break block4;
                return null;
            }
            catch (IOException e) {
                if (this.closed) {
                    return null;
                }
                throw e;
            }
        }
        byte[] packet = new byte[size];
        this.conIn.readFully(packet);
        return packet;
    }

    public void close() {
        try {
            this.closed = true;
            TimoutNotificator.getInstance().unregister(this);
            this.con.close();
        }
        catch (IOException e) {
            Logger.getLogger().logLine(e.toString());
        }
    }

    @Override
    public void timeoutNotification() {
        this.close();
    }

    @Override
    public long getTimoutTime() {
        return this.timeout.getTimeout();
    }
}

