/*
 * Decompiled with CFR 0.152.
 */
package proxy;

import java.net.InetAddress;
import java.util.StringTokenizer;

public class Subnet {
    private byte[] addr;
    private byte[] mask;

    public Subnet(InetAddress inetAddr, byte[] mask) {
        this.addr = inetAddr.getAddress();
        this.mask = mask;
        int i = 0;
        while (i < 4) {
            this.addr[i] = (byte)(this.addr[i] & mask[i]);
            ++i;
        }
    }

    public Subnet(InetAddress inetAddr, short d) {
        if (d > 32) {
            throw new IllegalArgumentException("Invalid format: " + d);
        }
        this.addr = inetAddr.getAddress();
        int m = -1 << d & 0xFFFFFFFF;
        this.mask = new byte[4];
        int i = 0;
        while (i < 4) {
            this.mask[i] = (byte)(m >> 8 * (3 - i) & 0xFF);
            this.addr[i] = (byte)(this.addr[i] & this.mask[i]);
            ++i;
        }
    }

    public Subnet(String subnet) throws IllegalArgumentException {
        try {
            int j = subnet.indexOf(47);
            if (j == -1) {
                this.addr = Subnet.parseString(subnet);
                this.mask = new byte[4];
                this.mask[3] = -1;
                this.mask[2] = -1;
                this.mask[1] = -1;
                this.mask[0] = -1;
            } else {
                this.addr = Subnet.parseString(subnet.substring(0, j));
                String s = subnet.substring(j + 1);
                if (s.indexOf(46) == -1) {
                    short d = Short.parseShort(s);
                    int m = -1 << 32 - d & 0xFFFFFFFF;
                    this.mask = new byte[4];
                    int i = 0;
                    while (i < 4) {
                        this.mask[i] = (byte)(m >> 8 * (3 - i) & 0xFF);
                        this.addr[i] = (byte)(this.addr[i] & this.mask[i]);
                        ++i;
                    }
                } else {
                    this.mask = Subnet.parseString(s);
                    int i = 0;
                    while (i < 4) {
                        this.addr[i] = (byte)(this.addr[i] & this.mask[i]);
                        ++i;
                    }
                }
            }
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException("Invalid format: " + subnet);
        }
    }

    public boolean isInSubnet(InetAddress inetAddr) {
        byte[] address = inetAddr.getAddress();
        int i = 0;
        while (i < 4) {
            if (this.addr[i] != (byte)(address[i] & this.mask[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String toString() {
        return String.valueOf(this.addr[0] & 0xFF) + "." + (this.addr[1] & 0xFF) + "." + (this.addr[2] & 0xFF) + "." + (this.addr[3] & 0xFF) + "/" + (this.mask[0] & 0xFF) + "." + (this.mask[1] & 0xFF) + "." + (this.mask[2] & 0xFF) + "." + (this.mask[3] & 0xFF);
    }

    private static byte[] parseString(String s) {
        StringTokenizer st = new StringTokenizer(s, ".");
        byte[] addr = new byte[4];
        int i = 0;
        while (i < 4) {
            addr[i] = (byte)Integer.parseInt(st.nextToken());
            ++i;
        }
        return addr;
    }
}

