/*
 * Decompiled with CFR 0.152.
 */
package httptunnel;

import httptunnel.Configuration;
import httptunnel.HttpTunnelConnection;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import util.Encryption;
import util.Utils;
import util.http.HttpURLConnection;
import util.http.URL;

public class HTTPTunnelOutputStream
extends OutputStream {
    private String m_cookie;
    private String m_sessionId;
    private HttpURLConnection m_connection;
    private URL m_url;

    public HTTPTunnelOutputStream(HttpTunnelConnection tunnel) throws IOException {
        this.m_cookie = tunnel.getSessionCookie();
        this.m_sessionId = tunnel.getSessionId();
        try {
            this.m_url = new URL(Configuration.TUNNELSERVER_URL);
        }
        catch (Exception e) {
            throw new IOException(e.toString());
        }
    }

    private OutputStream openStreamToHttpServer() throws IOException {
        this.m_connection = this.m_url.openConnection(Configuration.HTTPPROXY);
        this.m_connection.setSSLSocketFactory(Configuration.SSL_SOCKET_FACTORY);
        this.m_connection.setConnectTimeout(Configuration.CON_TIMEOUT);
        this.m_connection.setDoOutput(true);
        this.m_connection.setRequestMethod("POST");
        this.m_connection.setRequestProperty("Connection", "Keep-Alive");
        if (this.m_cookie != null) {
            this.m_connection.setRequestProperty("Cookie", this.m_cookie);
        }
        this.m_connection.setRequestProperty("Authorization", Configuration.ENCRAUTHSTRING);
        if (Configuration.PROXY_AUTH_REQUIRED) {
            this.m_connection.setRequestProperty("Proxy-Authorization", Configuration.PROXY_AUTH_STRING);
        }
        OutputStream outStream = Encryption.getEncryptedOutputStream(this.m_connection.getOutputStream(), Configuration.SEND_BUFFER_BYTES);
        outStream.write(new String("SENDER\n").getBytes());
        outStream.write(new String(String.valueOf(this.m_sessionId) + "\n").getBytes());
        return outStream;
    }

    private void closeStreamToHttpServer(OutputStream outStream) throws IOException {
        outStream.flush();
        outStream.close();
        String msg = this.m_connection.getResponseMessage();
        int code = this.m_connection.getResponseCode();
        InputStream inStream = Encryption.getDecryptedStream(this.m_connection.getInputStream());
        try {
            byte[] respondsBytes = Utils.readFully(inStream, 50);
            String response = new String(respondsBytes);
            if (code != 200) {
                throw new IOException(response);
            }
        }
        finally {
            try {
                inStream.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void write(int b) throws IOException {
        throw new IOException("write(int b) not supported in HTTPTunnelOutputStream");
    }

    @Override
    public void write(byte[] b) throws IOException {
        OutputStream outStream = this.openStreamToHttpServer();
        outStream.write(b);
        this.closeStreamToHttpServer(outStream);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        OutputStream outStream = this.openStreamToHttpServer();
        outStream.write(b, off, len);
        this.closeStreamToHttpServer(outStream);
    }

    @Override
    public void close() throws IOException {
    }
}

