/*
 * Decompiled with CFR 0.152.
 */
package httptunnel;

import httptunnel.Configuration;
import httptunnel.HttpTunnelConnection;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import util.Logger;
import util.TimeoutListener;
import util.TimeoutTime;
import util.TimoutNotificator;
import util.Utils;
import util.conpool.Connection;

public class ConnectionWatcherClient
implements Runnable,
TimeoutListener {
    private static Object INIT_MON = new Object();
    private static ConnectionWatcherClient INSTANCE;
    private static Thread INIT_THR;
    private static String CLIENT_ID;
    private static final int IDLE_TO = 30000;
    HashSet connections = new HashSet();
    private static int CON_CNT;
    HttpTunnelConnection con = new HttpTunnelConnection("$WATCHDOG$", 0, true);
    OutputStream out;
    InputStream in;
    boolean closed = false;
    boolean invalid = false;
    long lastResponseTime = 0L;
    private TimeoutTime idleTimeout;

    static {
        INIT_THR = null;
        CLIENT_ID = null;
        CON_CNT = 0;
    }

    private ConnectionWatcherClient() throws IOException {
        this.connections.add(this.con);
        ++CON_CNT;
        this.in = this.con.getInputStream();
        this.out = this.con.getOutputStream();
        this.lastResponseTime = System.currentTimeMillis();
        this.idleTimeout = new TimeoutTime(TimoutNotificator.getInstance());
        this.idleTimeout.setTimeout(30000L);
        TimoutNotificator.getInstance().register(this);
        new Thread(this).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String initConnectionWatcher(HttpTunnelConnection con) throws IOException {
        Object object = INIT_MON;
        synchronized (object) {
            if ((Configuration.CON_MODE & Utils.CON_MODE_WATCH_ENABLED) == 0) {
                ++CON_CNT;
                return Configuration.CLIENT_ID;
            }
            if (INSTANCE == null) {
                if (INIT_THR == Thread.currentThread()) {
                    return CLIENT_ID;
                }
                INIT_THR = Thread.currentThread();
                CLIENT_ID = "CLID" + (long)(9.223372036854776E18 * Math.random());
                try {
                    INSTANCE = new ConnectionWatcherClient();
                }
                finally {
                    INIT_THR = null;
                }
                Configuration.updateClientID(CLIENT_ID);
            }
            ConnectionWatcherClient.INSTANCE.connections.add(con);
            ++CON_CNT;
            return Configuration.CLIENT_ID;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closedConnection(HttpTunnelConnection con) {
        Object object = INIT_MON;
        synchronized (object) {
            if (INSTANCE != null && con.clientID.equals(Configuration.CLIENT_ID)) {
                ConnectionWatcherClient.INSTANCE.connections.remove(con);
                --CON_CNT;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void invalidate(boolean kill) {
        ConnectionWatcherClient instance = null;
        Object object = INIT_MON;
        synchronized (object) {
            instance = INSTANCE;
            if (instance != null) {
                instance.invalid = true;
                if (kill) {
                    Logger.getLogger().logLine("ConnectionWatcher: hard inavidate => Killing connections!");
                    Connection.invalidate();
                } else {
                    try {
                        Logger.getLogger().logLine("ConnectionWatcher: Soft invalidate");
                        instance.closed = true;
                        instance.con.close();
                    }
                    catch (IOException eio) {
                        instance.closed = false;
                        Logger.getLogger().logLine("ConnectionWatcher: Exception during Soft Invalidate:" + eio);
                        ConnectionWatcherClient.invalidate(true);
                        return;
                    }
                }
                ConnectionWatcherClient.INSTANCE.connections.clear();
                CON_CNT = 0;
                INSTANCE = null;
            }
        }
        if (instance != null) {
            TimoutNotificator.getInstance().unregister(instance);
            Logger.getLogger().logLine("ConnectionWatcher: invalidated!");
        }
    }

    @Override
    public void run() {
        block11: {
            try {
                try {
                    int r = 0;
                    while (r != -1) {
                        r = this.in.read();
                        Logger.getLogger().logLine("ConnectionWatcher - received response:" + r);
                        this.lastResponseTime = System.currentTimeMillis();
                    }
                }
                catch (IOException e) {
                    Logger.getLogger().logLine("ConnectionWatcher:" + e.getMessage());
                    if (!this.closed) {
                        Logger.getLogger().logLine("ConnectionWatcher:lost Connection to Server!");
                        if (!this.invalid) {
                            ConnectionWatcherClient.invalidate(true);
                        }
                        break block11;
                    }
                    Logger.getLogger().logLine("ConnectionWatcher:closed!");
                }
            }
            finally {
                if (!this.closed) {
                    Logger.getLogger().logLine("ConnectionWatcher:lost Connection to Server!");
                    if (!this.invalid) {
                        ConnectionWatcherClient.invalidate(true);
                    }
                } else {
                    Logger.getLogger().logLine("ConnectionWatcher:closed!");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void timeoutNotification() {
        try {
            Object object = INIT_MON;
            synchronized (object) {
                if (this.connections.size() == 1) {
                    ConnectionWatcherClient.invalidate(false);
                    return;
                }
                long curMillis = System.currentTimeMillis();
                if ((double)(curMillis - this.lastResponseTime) > 45000.0) {
                    Logger.getLogger().logLine("ConnectionWatcher:Server connection seems dead! No Response since " + (curMillis - this.lastResponseTime) + " milliseconds!");
                    ConnectionWatcherClient.invalidate(true);
                    return;
                }
            }
            Logger.getLogger().logLine("ConnectionWatcher: Sending ALIVE PING");
            this.out.write(this.connections.size());
            this.out.flush();
            this.idleTimeout.setTimeout(30000L);
            TimoutNotificator.getInstance().register(this);
        }
        catch (IOException e) {
            Logger.getLogger().logLine("ConnectionWatcher: Exception during Beeing ALIVE PING:" + e.getMessage());
            ConnectionWatcherClient.invalidate(true);
        }
    }

    @Override
    public long getTimoutTime() {
        return this.idleTimeout.getTimeout();
    }
}

