/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import keygen.SSLKeyGenerator;
import keygen.TunnelKeyGenerator;
import util.Utils;

public class TunnelSetup {
    private static String DYN_URL = "https://www.zenz-solutions.de/personalhttptunnel/internal/";
    private static String IP_FILE = "ip.txt";
    private static String SRV_PROPS = "Server/TunnelServer.properties";
    private static String CLIENT_PROPS = "Client/HttpTunnel.properties";
    String key = null;
    String id = null;
    String remotePerm = null;

    public static void main(String[] args) {
        try {
            new TunnelSetup().go();
            System.out.println("\nTunnel Setup completed successfully!");
            System.out.println("See 'www.zenz-solutions.de/personalhttptunnel/' for next steps!");
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            System.out.println("Tunnel Setup failed!");
        }
    }

    private void go() throws Exception {
        this.checkProperties();
        this.generateKeys();
        this.registerDynamicIP();
        this.generateClientProperties();
        this.generateServerProperties();
        this.writeKeyFiles();
        SSLKeyGenerator.generateKeyPair(this.id);
        SSLKeyGenerator.exportCert();
    }

    private void checkProperties() throws Exception {
        File clientPropsf = new File(CLIENT_PROPS);
        File serverPropsf = new File(SRV_PROPS);
        if (!clientPropsf.exists() || clientPropsf.isDirectory() || !serverPropsf.exists() || serverPropsf.isDirectory()) {
            throw new Exception("File not found! No 'Server/TunnelServer.properties' or 'Client/HttpTunnel.properties' found ! Make sure setup is executed in the unzipped package root folder!");
        }
    }

    private void generateClientProperties() throws Exception {
        System.out.println("Writing Tunnel Client Configuration ...");
        BufferedReader clientPropsIn = new BufferedReader(new InputStreamReader(new FileInputStream(CLIENT_PROPS)));
        ByteArrayOutputStream newPropsBytes = new ByteArrayOutputStream();
        PrintWriter newPropsWriter = new PrintWriter(new OutputStreamWriter(newPropsBytes));
        String line = null;
        while ((line = clientPropsIn.readLine()) != null) {
            if (line.startsWith("dynamicTunnelServerURLLocation")) {
                line = "dynamicTunnelServerURLLocation = " + DYN_URL + this.id + "/" + IP_FILE;
            }
            newPropsWriter.println(line);
        }
        newPropsWriter.flush();
        newPropsWriter.close();
        clientPropsIn.close();
        FileOutputStream newPropsFile = new FileOutputStream(CLIENT_PROPS);
        newPropsFile.write(newPropsBytes.toByteArray());
        newPropsFile.flush();
        newPropsFile.close();
    }

    private void generateServerProperties() throws Exception {
        System.out.println("Writing Tunnel Server Configuration ...");
        BufferedReader clientPropsIn = new BufferedReader(new InputStreamReader(new FileInputStream(SRV_PROPS)));
        ByteArrayOutputStream newPropsBytes = new ByteArrayOutputStream();
        PrintWriter newPropsWriter = new PrintWriter(new OutputStreamWriter(newPropsBytes));
        String line = null;
        while ((line = clientPropsIn.readLine()) != null) {
            if (line.startsWith("IdForDynamicIP")) {
                line = "IdForDynamicIP = " + this.id;
            }
            newPropsWriter.println(line);
        }
        newPropsWriter.flush();
        newPropsWriter.close();
        clientPropsIn.close();
        FileOutputStream newPropsFile = new FileOutputStream(SRV_PROPS);
        newPropsFile.write(newPropsBytes.toByteArray());
        newPropsFile.flush();
        newPropsFile.close();
    }

    private void registerDynamicIP() throws Exception {
        System.out.println("Register for dynamic IP Resolution...");
        try {
            URL url = new URL(String.valueOf(DYN_URL) + "RegisterNewID.php?id=" + this.id);
            HttpURLConnection receiver = (HttpURLConnection)url.openConnection();
            InputStream in = receiver.getInputStream();
            String response = new String(Utils.readFully(in, 256));
            System.out.println();
            System.out.println(">>>>>> BEGIN MESSAGE RECEIVED FROM REGISTRATION!");
            System.out.println(response);
            System.out.println("<<<<<< END MESSAGE RECEIVED FROM REGISTRATION!");
            System.out.println();
            if (!response.startsWith("OK")) {
                throw new Exception("Error during space registration for dynamic IP resolution! - See message from registration!");
            }
        }
        catch (IOException e) {
            String msg = "I/O Error during space registration for dynamic IP resolution\r\nMake sure Internet Connection is available!\r\n";
            throw new IOException(String.valueOf(msg) + " - " + e.getMessage());
        }
    }

    private void generateKeys() throws Exception {
        System.out.println("Generating Key ... ");
        String[] result = new TunnelKeyGenerator().generateKeys();
        this.key = result[0];
        this.id = result[1].substring(0, result[1].length() - 2).replace("/", "-").replace("+", ".");
        this.remotePerm = result[2];
    }

    private void writeKeyFiles() throws Exception {
        System.out.println("Writing Key Files...");
        FileOutputStream fout = new FileOutputStream("Client/key");
        fout.write(this.key.getBytes());
        fout.flush();
        fout.close();
        fout = new FileOutputStream("Server/key");
        fout.write(this.key.getBytes());
        fout.flush();
        fout.close();
        fout = new FileOutputStream("Server/remote.perm");
        fout.write(this.remotePerm.getBytes());
        fout.flush();
        fout.close();
        fout = new FileOutputStream("Client/remote.perm");
        fout.write(this.remotePerm.getBytes());
        fout.flush();
        fout.close();
    }
}

