/*
 * Decompiled with CFR 0.152.
 */
package util.http;

import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Proxy;
import javax.net.ssl.SSLSocketFactory;
import util.Logger;
import util.Utils;
import util.conpool.Connection;
import util.conpool.HttpProxy;
import util.http.BufferedHttpContentOutputStream;
import util.http.ChunkedHttpContentOutputStream;
import util.http.HttpHeader;
import util.http.HttpResponseInputStream;

public class HttpURLConnection {
    private static byte INIT = 1;
    private static byte CONNECT = (byte)2;
    private static byte REC_REQ_BODY = (byte)3;
    private static byte SEND_HEADER = (byte)4;
    private static byte REC_SEND_REQ_BODY = (byte)5;
    private static byte SEND_REQ_BODY = (byte)6;
    private static byte REC_REPONSE_HEADER = (byte)7;
    private static byte REC_REPONSE_BODY = (byte)8;
    private static byte SESSION_COMPLETED = (byte)9;
    private static String user_agent = "Mozilla/5.0 (" + System.getProperty("os.name") + "; " + System.getProperty("os.version") + ")";
    private static HttpHeader REQ_TEMPLATE = new HttpHeader(1);
    private static boolean INITIALIZED = false;
    private byte status = INIT;
    private long contentLength = -1L;
    private boolean connection_close = false;
    private boolean chunked = false;
    private String url = null;
    private HttpHeader reqHeader;
    private HttpHeader resHeader;
    private Proxy usedproxy = null;
    private boolean chunkedReq = false;
    private String method = "GET";
    private Connection con = null;
    private int connect_to = 360000;
    private int read_to = 0;
    private boolean https;
    private SSLSocketFactory sslSocketFactory = null;

    public static void setUserAgent(String uag) {
        user_agent = uag;
    }

    public void setSSLSocketFactory(SSLSocketFactory sslSocketFactory) {
        this.sslSocketFactory = sslSocketFactory;
    }

    public HttpURLConnection(String url, Proxy httpProxy) throws IOException {
        this.url = url;
        if (httpProxy != Proxy.NO_PROXY) {
            if (httpProxy.type() != Proxy.Type.HTTP) {
                throw new IOException("Wrong proxy type specified! Need proxy of type HTTP!");
            }
            this.usedproxy = new HttpProxy((InetSocketAddress)httpProxy.address());
        } else {
            this.usedproxy = httpProxy;
        }
        if (url.length() < 5) {
            throw new IOException("Invalid URL: " + url);
        }
        this.https = url.substring(0, 5).equalsIgnoreCase("https");
        this.initRequest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initRequest() {
        if (INITIALIZED) {
            this.reqHeader = REQ_TEMPLATE.clone();
        } else {
            HttpHeader httpHeader = REQ_TEMPLATE;
            synchronized (httpHeader) {
                if (!INITIALIZED) {
                    REQ_TEMPLATE.setValue("User-Agent", user_agent);
                    REQ_TEMPLATE.setValue("Accept", "text/html, image/gif, image/jpeg, *; q= 2,.*/*; q= 2");
                    REQ_TEMPLATE.setValue("Connection", "keep-alive");
                    INITIALIZED = true;
                }
                this.reqHeader = REQ_TEMPLATE.clone();
            }
        }
    }

    public void setConnectTimeout(int timeout) {
        this.connect_to = timeout;
    }

    public void setReadTimeout(int timeout) {
        this.read_to = timeout;
    }

    public void setDoOutput(boolean b) throws IOException {
        if (this.status != INIT) {
            throw new IOException("Illegal State for setting request properties");
        }
        this.method = "POST";
    }

    public void setRequestProperty(String key, String value) throws IOException {
        if (this.status != INIT) {
            throw new IOException("Illegal State for setting request properties");
        }
        this.reqHeader.setValue(key, value);
    }

    public void setRequestMethod(String string) throws IOException {
        if (this.status != INIT) {
            throw new IOException("Illegal State for setting request properties");
        }
        this.method = string;
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.status != INIT) {
            throw new IOException("Illegal State for retrieving output stream!");
        }
        if (!this.method.equals("POST") && !this.method.equals("PUT")) {
            throw new IOException("Requestmethod must either be POST or PUT");
        }
        if (!this.chunkedReq) {
            this.status = REC_REQ_BODY;
            return new BufferedHttpContentOutputStream(this);
        }
        this.status = CONNECT;
        this.connectServer();
        this.con.getOutputStream().write(this.reqHeader.getServerRequestHeader(this.usedproxy != Proxy.NO_PROXY && !this.https).getBytes());
        this.con.getOutputStream().flush();
        this.reqHeader = null;
        this.status = REC_SEND_REQ_BODY;
        return new ChunkedHttpContentOutputStream(this, this.con.getOutputStream());
    }

    public String getResponseMessage() throws IOException {
        if (this.status == INIT && !this.chunkedReq) {
            this.bodyCompleted(null);
        }
        if (this.status < REC_REPONSE_HEADER) {
            throw new IOException("Illegal State for retrieving response!");
        }
        return this.resHeader.getResponseMessage();
    }

    public InputStream getInputStreamInternal() throws IOException {
        if (this.status == SESSION_COMPLETED) {
            throw new IOException("Illegal State for retrieving response! Inputstream already taken before!");
        }
        if (this.status == INIT && !this.chunkedReq) {
            this.bodyCompleted(null);
        }
        if (this.status != REC_REPONSE_HEADER) {
            throw new IOException("Illegal State for retrieving response!");
        }
        this.status = REC_REPONSE_BODY;
        InputStream in = null;
        if (this.con != null) {
            in = this.con.getInputStream();
        }
        return new HttpResponseInputStream(this, this.chunked, this.contentLength, in);
    }

    public InputStream getInputStream() throws IOException {
        InputStream in = this.getInputStreamInternal();
        int rc = this.resHeader.getResponseCode();
        if (rc >= 400) {
            IOException e = new IOException("HTTP Error:" + rc + "\r\n" + new String(Utils.readFully(in, 1024)));
            throw e;
        }
        return in;
    }

    public int getResponseCode() throws IOException {
        if (this.status == INIT && !this.chunkedReq) {
            this.bodyCompleted(null);
        }
        if (this.status < REC_REPONSE_HEADER) {
            throw new IOException("Illegal State for retrieving response!");
        }
        return this.resHeader.getResponseCode();
    }

    public void setChunkedStreamingMode(int i) throws IOException {
        if (this.status != INIT) {
            throw new IOException("Illegal State for setting request properties");
        }
        this.chunkedReq = true;
        this.reqHeader.setValue("Transfer-Encoding", "chunked");
    }

    private void connectServer() throws IOException {
        this.reqHeader.setRequest(String.valueOf(this.method) + " " + this.url + " " + "HTTP/1.1");
        if (!this.https) {
            this.con = this.usedproxy != Proxy.NO_PROXY ? Connection.connect((InetSocketAddress)this.usedproxy.address(), this.connect_to) : Connection.connect(this.reqHeader.remote_host_name, this.reqHeader.remote_port, this.connect_to);
        } else {
            if (this.usedproxy != Proxy.NO_PROXY) {
                ((HttpProxy)this.usedproxy).setProxyAuth(this.reqHeader.removeValue("Proxy-Authorization"));
            }
            this.con = Connection.connect(this.reqHeader.remote_host_name, this.reqHeader.remote_port, this.connect_to, true, this.sslSocketFactory, this.usedproxy);
        }
    }

    public void bodyCompleted(ByteArrayOutputStream buffer) throws IOException {
        boolean refreshedAlready = false;
        boolean done = false;
        if (buffer != null) {
            this.reqHeader.setValue("Content-Length", String.valueOf(buffer.size()));
        } else {
            this.reqHeader.setValue("Content-Length", "0");
        }
        this.status = CONNECT;
        this.connectServer();
        while (!done) {
            try {
                this.con.getOutputStream().write(this.reqHeader.getServerRequestHeader(this.usedproxy != Proxy.NO_PROXY && !this.https).getBytes());
                this.con.getOutputStream().flush();
                this.status = SEND_REQ_BODY;
                if (buffer != null) {
                    this.con.getOutputStream().write(buffer.toByteArray(), 0, buffer.size());
                    this.con.getOutputStream().flush();
                }
                this.status = REC_REPONSE_HEADER;
                this.readResponseHeader();
                this.reqHeader = null;
                if (this.contentLength == 0L && !this.chunked) {
                    this.con.release(this.resHeader.getResponseCode() < 400 && !this.connection_close);
                    this.con = null;
                }
                done = true;
            }
            catch (EOFException eof) {
                if (refreshedAlready) {
                    this.errorCleanup();
                    throw eof;
                }
                Logger.getLogger().logLine("Refreshing connection: " + this.con);
                refreshedAlready = true;
                this.con.refreshConnection();
            }
        }
    }

    public void chunkedBodyCompleted() throws IOException {
        this.status = REC_REPONSE_HEADER;
        try {
            this.readResponseHeader();
        }
        catch (EOFException ioe) {
            this.errorCleanup();
            throw ioe;
        }
        if (this.contentLength == 0L && !this.chunked) {
            this.con.release(this.resHeader.getResponseCode() < 400 && !this.connection_close);
            this.con = null;
        }
    }

    private void readResponseHeader() throws IOException {
        try {
            this.con.setSoTimeout(this.connect_to);
            this.resHeader = new HttpHeader(this.con.getInputStream(), 2);
            this.con.setSoTimeout(this.read_to);
            this.contentLength = this.resHeader.getContentLength();
            this.connection_close = this.resHeader.getConnectionClose();
            this.chunked = this.resHeader.chunkedTransfer();
        }
        catch (EOFException e) {
            throw e;
        }
        catch (IOException e) {
            this.errorCleanup();
            throw e;
        }
    }

    public synchronized void responseCompleted(boolean reuse) {
        boolean bl = reuse = reuse && this.resHeader.getResponseCode() < 400;
        if (this.con != null) {
            this.con.release(!this.connection_close && reuse);
            this.con = null;
        }
        this.status = SESSION_COMPLETED;
    }

    public void errorCleanup() {
        this.status = SESSION_COMPLETED;
        if (this.con != null) {
            this.con.release(false);
            this.con = null;
        }
    }
}

