/*
 * Decompiled with CFR 0.152.
 */
package util.conpool;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.Socket;
import util.http.HttpHeader;

public class HttpProxy
extends Proxy {
    private String authString;
    private InetSocketAddress proxyAdr;

    public HttpProxy(InetSocketAddress adr, String authString) {
        super(Proxy.Type.HTTP, adr);
        this.proxyAdr = adr;
        this.authString = authString;
    }

    public HttpProxy(InetSocketAddress adr) {
        this(adr, null);
    }

    public void setProxyAuth(String authString) {
        this.authString = authString;
    }

    public Socket openTunnel(InetSocketAddress adr, int conTimeout) throws IOException {
        String host = !adr.getAddress().getHostAddress().equals("0.0.0.0") ? adr.getAddress().getHostAddress() : adr.getHostName();
        HttpHeader header = new HttpHeader(1);
        header.setRequest("CONNECT " + host + ":" + adr.getPort() + " HTTP/1.1");
        if (this.authString != null) {
            header.setValue("Proxy-Authorization", this.authString);
        }
        String request = header.getServerRequestHeader();
        InetSocketAddress conAdr = new InetSocketAddress(InetAddress.getByAddress(adr.getHostName(), this.proxyAdr.getAddress().getAddress()), this.proxyAdr.getPort());
        Socket proxyCon = new Socket();
        proxyCon.connect(conAdr, conTimeout);
        proxyCon.setSoTimeout(conTimeout);
        proxyCon.getOutputStream().write(request.getBytes());
        proxyCon.getOutputStream().flush();
        header = new HttpHeader(proxyCon.getInputStream(), 2);
        if (header.responsecode != 200) {
            proxyCon.shutdownInput();
            proxyCon.shutdownOutput();
            proxyCon.close();
            throw new IOException("Proxy refused Tunnel\n" + header.getResponseMessage());
        }
        proxyCon.setSoTimeout(0);
        return proxyCon;
    }
}

