/*
 * Decompiled with CFR 0.152.
 */
package util.commands;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import util.Utils;
import util.commands.Command;

public class SendWakeOnLanPacket
extends Command {
    @Override
    public void runCommand(InputStream in, OutputStream out) throws IOException {
        try {
            String[] args = Utils.readLineFromStream(in).split(" ");
            if (args.length < 3) {
                throw new IOException("Expected Params:\"[IP] [MACADRESS] [PORT]\"");
            }
            String IP = args[0];
            String MACADDR = args[1];
            int port = Integer.parseInt(args[2]);
            byte[] MACBYTE = new byte[6];
            String[] hex = MACADDR.split("(\\:|\\-)");
            int i = 0;
            while (i < 6) {
                MACBYTE[i] = (byte)Integer.parseInt(hex[i], 16);
                ++i;
            }
            byte[] bytes = new byte[6 + 16 * MACBYTE.length];
            int i2 = 0;
            while (i2 < 6) {
                bytes[i2] = -1;
                ++i2;
            }
            i2 = 6;
            while (i2 < bytes.length) {
                System.arraycopy(MACBYTE, 0, bytes, i2, MACBYTE.length);
                i2 += MACBYTE.length;
            }
            InetAddress address = InetAddress.getByName(IP);
            DatagramPacket packet = new DatagramPacket(bytes, bytes.length, address, port);
            DatagramSocket socket = new DatagramSocket();
            socket.send(packet);
            socket.close();
            out.write(("OK! Magic Packet was sent to " + IP + "," + MACADDR + "," + port + "!\n").getBytes());
            out.flush();
        }
        catch (Exception e) {
            out.write(("ERROR! Magic Packet sent Failed! - " + e + "\n").getBytes());
            out.flush();
        }
    }

    public static void main(String[] args) throws Exception {
        ByteArrayOutputStream argBytes = new ByteArrayOutputStream();
        int i = 0;
        while (i < args.length) {
            argBytes.write(args[i].getBytes());
            if (i < args.length - 1) {
                argBytes.write(" ".getBytes());
            } else {
                argBytes.write("\n".getBytes());
            }
            ++i;
        }
        argBytes.flush();
        new SendWakeOnLanPacket().runCommand(new ByteArrayInputStream(argBytes.toByteArray()), System.out);
    }
}

