/*
 * Decompiled with CFR 0.152.
 */
package util.commands;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import util.Logger;
import util.Utils;
import util.commands.Command;

public class CommandRunner
implements Runnable {
    private Socket client = null;

    public CommandRunner(Socket client) {
        this.client = client;
        new Thread(this).start();
    }

    @Override
    public void run() {
        try {
            try {
                this.execCommand(this.client);
            }
            catch (IOException e) {
                Logger.getLogger().logLine("CommandRunner - catched IOException during initialization of execCommand - " + e);
                try {
                    this.client.close();
                }
                catch (IOException e2) {
                    Logger.getLogger().logLine("CommandRunner - catched IOException during Socket close - " + e2);
                }
            }
        }
        finally {
            try {
                this.client.close();
            }
            catch (IOException e) {
                Logger.getLogger().logLine("CommandRunner - catched IOException during Socket close - " + e);
            }
        }
    }

    private void execCommand(Socket client) throws IOException {
        InputStream in = client.getInputStream();
        OutputStream out = client.getOutputStream();
        try {
            String cmd = Utils.readLineFromStream(in);
            Command commandObj = null;
            Logger.getLogger().logLine("CommandRunner - received command:<" + cmd + ">");
            try {
                commandObj = Command.getCommandImpl(cmd);
            }
            catch (Exception e) {
                String msg = "Command failed! Cannot get Command Impl for <" + cmd + ">! - " + e;
                Logger.getLogger().logLine(msg);
                out.write((String.valueOf(msg) + "\n").getBytes());
            }
            if (commandObj != null) {
                commandObj.runCommand(in, out);
                Logger.getLogger().logLine("CommandRunner - command:<" + cmd + "> terminated!");
            }
        }
        finally {
            in.close();
            out.flush();
            out.close();
        }
    }
}

