/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;
import util.BASE64Decoder;
import util.BASE64Encoder;

public class Utils {
    public static String AUTHSTRING = "29HbfE4lKnGdJvFztrkljXgJ";
    public static byte CON_MODE_CHUNKED_RESPONSE = 1;
    public static byte CON_MODE_CHUNKED_REQUEST = (byte)2;
    public static byte CON_MODE_NETWORK_BLOCKS_INPUT = (byte)4;
    public static byte CON_MODE_DIRECT = (byte)8;
    public static byte CON_MODE_WATCH_ENABLED = (byte)16;

    public static int byteArrayToInt(byte[] b) {
        return b[3] & 0xFF | (b[2] & 0xFF) << 8 | (b[1] & 0xFF) << 16 | (b[0] & 0xFF) << 24;
    }

    public static byte[] intToByteArray(int a) {
        return new byte[]{(byte)(a >> 24 & 0xFF), (byte)(a >> 16 & 0xFF), (byte)(a >> 8 & 0xFF), (byte)(a & 0xFF)};
    }

    public static byte[] longToByteArray(long value) {
        return new byte[]{(byte)(value >> 56), (byte)(value >> 48), (byte)(value >> 40), (byte)(value >> 32), (byte)(value >> 24), (byte)(value >> 16), (byte)(value >> 8), (byte)value};
    }

    public static void writeLongToByteArray(long value, byte[] b, int offs) {
        b[offs + 0] = (byte)(value >> 56);
        b[offs + 1] = (byte)(value >> 48);
        b[offs + 2] = (byte)(value >> 40);
        b[offs + 3] = (byte)(value >> 32);
        b[offs + 4] = (byte)(value >> 24);
        b[offs + 5] = (byte)(value >> 16);
        b[offs + 6] = (byte)(value >> 8);
        b[offs + 7] = (byte)value;
    }

    public static long byteArrayToLong(byte[] b, int offs) {
        return (long)(b[7 + offs] & 0xFF) | (long)(b[6 + offs] & 0xFF) << 8 | (long)(b[5 + offs] & 0xFF) << 16 | (long)(b[4 + offs] & 0xFF) << 24 | (long)(b[3 + offs] & 0xFF) << 32 | (long)(b[2 + offs] & 0xFF) << 40 | (long)(b[1 + offs] & 0xFF) << 48 | (long)(b[0 + offs] & 0xFF) << 56;
    }

    public static long getLongStringHash(String str) {
        int a = 0;
        int b = 0;
        int len = str.length();
        byte[] bytes = str.getBytes();
        int i = 0;
        while (i < len) {
            a = 31 * a + (bytes[i] & 0xFF);
            b = 31 * b + (bytes[len - i - 1] & 0xFF);
            ++i;
        }
        return (long)a << 32 | (long)b & 0xFFFFFFFFL;
    }

    public static String readLineFromStream(InputStream in, boolean crlf, boolean nullOnEOF) throws IOException {
        int i = 0;
        StringBuffer str = new StringBuffer();
        boolean exit = false;
        int r = -1;
        int last = 0;
        boolean firstRead = true;
        while (!exit) {
            r = in.read();
            if (firstRead && nullOnEOF && r == -1) {
                return null;
            }
            firstRead = false;
            byte b = (byte)(r & 0xFF);
            boolean bl = exit = r == -1 || b == 10 && (!crlf || last == 13);
            if (exit) continue;
            str.append((char)b);
            ++i;
            last = b;
        }
        if (i > 0 && last == 13) {
            --i;
        }
        return str.substring(0, i);
    }

    public static String readLineFromStream(InputStream in, boolean crlf) throws IOException {
        return Utils.readLineFromStream(in, crlf, false);
    }

    public static String readLineFromStreamRN(InputStream in) throws IOException {
        return Utils.readLineFromStream(in, true);
    }

    public static String readLineFromStream(InputStream in) throws IOException {
        return Utils.readLineFromStream(in, false);
    }

    public static byte[] readFully(InputStream in, int bufSize) throws IOException {
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        int r = 0;
        byte[] buf = new byte[bufSize];
        while ((r = in.read(buf, 0, bufSize)) != -1) {
            bytesOut.write(buf, 0, r);
        }
        return bytesOut.toByteArray();
    }

    public static byte[] serializeObject(Object obj) throws IOException {
        ByteArrayOutputStream objOut = new ByteArrayOutputStream();
        ObjectOutputStream dataOut = new ObjectOutputStream(objOut);
        dataOut.writeObject(obj);
        dataOut.flush();
        dataOut.close();
        return objOut.toByteArray();
    }

    public static String getServerTime() {
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        return dateFormat.format(calendar.getTime());
    }

    public static String[] parseURI(String uri) throws IOException {
        try {
            String url = uri;
            url = url.substring(7);
            int idx = url.indexOf(47);
            if (idx == -1) {
                idx = url.length();
            }
            String hostEntry = url.substring(0, idx);
            url = idx == url.length() ? "/" : url.substring(idx);
            return new String[]{hostEntry, url};
        }
        catch (Exception e) {
            throw new IOException("Cannot parse URI '" + uri + "'! - " + e.toString());
        }
    }

    public static String base64EncodeURL(String txt) throws IOException {
        return new String(new BASE64Encoder().encodeBuffer(txt.getBytes("UTF-8"))).trim().replace('/', '_').replace('+', '-');
    }

    public static String base64DecodeURL(String txt) throws IOException {
        return new String(new BASE64Decoder().decodeBuffer(txt.replace('_', '/').replace('-', '+')));
    }

    public static void deleteFolder(String path) {
        File dir = new File(path);
        if (dir.exists() && dir.isDirectory()) {
            File[] files = dir.listFiles();
            int i = 0;
            while (i < files.length) {
                if (files[i].isDirectory()) {
                    Utils.deleteFolder(files[i].getAbsolutePath());
                } else {
                    files[i].delete();
                }
                ++i;
            }
            dir.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sleep(long millis) {
        Object obj;
        Object object = obj = new Object();
        synchronized (object) {
            try {
                obj.wait(millis);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

