/*
 * Decompiled with CFR 0.152.
 */
package udpproxy;

import java.io.IOException;
import java.io.OutputStream;
import udpproxy.UDPBridge;
import util.Utils;

public class UDPRequest
extends OutputStream {
    private UDPBridge udpBridge;
    private byte[] packetSizeBytes = new byte[4];
    private byte[] packet;
    private int remainingPacketLength = 0;
    private byte packetSizeBytePos = 0;

    public UDPRequest(UDPBridge udpBridge) {
        this.udpBridge = udpBridge;
    }

    @Override
    public void write(int b) throws IOException {
        if (this.remainingPacketLength > 0) {
            this.packet[this.packet.length - this.remainingPacketLength] = (byte)b;
            --this.remainingPacketLength;
            if (this.remainingPacketLength == 0) {
                this.udpBridge.requestPackageReceived(this.packet);
                this.packetSizeBytePos = 0;
            }
        } else if (this.packetSizeBytePos != -1) {
            this.packetSizeBytes[this.packetSizeBytePos] = (byte)b;
            this.packetSizeBytePos = (byte)(this.packetSizeBytePos + 1);
            if (this.packetSizeBytePos == 4) {
                this.packetSizeBytePos = (byte)-1;
                this.remainingPacketLength = Utils.byteArrayToInt(this.packetSizeBytes);
                this.packet = new byte[this.remainingPacketLength];
                if (this.remainingPacketLength == 0) {
                    this.udpBridge.requestPackageReceived(this.packet);
                    this.packetSizeBytePos = 0;
                }
            }
        }
    }

    @Override
    public void close() {
        this.udpBridge.close();
    }
}

