/*
 * Decompiled with CFR 0.152.
 */
package mysoft.httptunnel;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Proxy;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.net.ssl.SSLSocketFactory;
import mysoft.httptunnel.DynIPPublisher;
import mysoft.httptunnel.TunnelServer;
import util.BASE64Encoder;
import util.Encryption;
import util.ExecutionEnvironment;
import util.Logger;
import util.Utils;
import util.http.HttpURLConnection;
import util.http.URL;

public class WanIPPublisher
implements Runnable {
    private String dynWANIPRetrievalURL = null;
    private String dynWANIPRetrievalPattern = "";
    private long dynWANIPCheckInterval = 300000L;
    private SSLSocketFactory localSSLSocketFactory = null;
    private static String DYN_URL = "https://www.zenz-solutions.de/personalhttptunnel/internal/";
    Properties config = null;
    String id = "";
    private boolean stopped = false;
    private String lastIP = "";
    private String dynDNSUrlStr = null;
    private String dynDNSAuth = null;
    private boolean use_dynip_cfg = false;

    public WanIPPublisher(Properties config) throws Exception {
        this.config = config;
        this.id = config.getProperty("IdForDynamicIP", "");
        this.dynWANIPRetrievalURL = config.getProperty("WANIPRetrievalURL", "");
        this.dynWANIPRetrievalPattern = config.getProperty("WANIPRetrievalPattern", "");
        this.dynWANIPRetrievalPattern = this.dynWANIPRetrievalPattern.replace("<CHR10>", "\n").replace("<CHR13>", "\r");
        if (this.id.equals("")) {
            Logger.getLogger().logLine("configuration for 'IdForDynamicIP' is not set - only DynIP publishing will be used!");
        }
        this.dynWANIPCheckInterval = Long.parseLong(config.getProperty("WANIPCheckInterval", "300000"));
        this.use_dynip_cfg = Boolean.parseBoolean(config.getProperty("dnsDNSPublish_use_dynip.cfg", "false"));
        this.dynDNSUrlStr = config.getProperty("dynDNSPublishURL");
        String user = config.getProperty("dynDNSPublishUSR");
        String pwd = config.getProperty("dynDNSPublishPWD", "");
        if (user != null) {
            this.dynDNSAuth = "Basic " + new BASE64Encoder().encode((String.valueOf(user) + ":" + pwd).getBytes());
        }
    }

    boolean isDigit(Character c) {
        return c.charValue() == '0' || c.charValue() == '1' || c.charValue() == '2' || c.charValue() == '3' || c.charValue() == '4' || c.charValue() == '5' || c.charValue() == '6' || c.charValue() == '7' || c.charValue() == '8' || c.charValue() == '9';
    }

    boolean isPosInt(String val) {
        try {
            int i = Integer.parseInt(val);
            return i >= 0;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public String getWanIP() throws Exception {
        StringTokenizer tokenizer;
        String wanip = "<unknown>";
        URL url = new URL(this.dynWANIPRetrievalURL);
        HttpURLConnection receiver = url.openConnection(Proxy.NO_PROXY);
        receiver.setConnectTimeout(100000);
        receiver.setReadTimeout(100000);
        InputStream in = receiver.getInputStream();
        ByteArrayOutputStream contentbytes = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        int r = 0;
        while ((r = in.read(buf)) != -1) {
            contentbytes.write(buf, 0, r);
        }
        contentbytes.flush();
        contentbytes.close();
        in.close();
        String content = new String(contentbytes.toByteArray());
        if (!this.dynWANIPRetrievalPattern.equals("")) {
            int pos = content.indexOf(this.dynWANIPRetrievalPattern);
            if (pos == -1) {
                Logger.getLogger().logLine("WAN IP pattern not found on " + this.dynWANIPRetrievalURL);
                return wanip;
            }
            content = content.substring(pos + this.dynWANIPRetrievalPattern.length());
        }
        if ((tokenizer = new StringTokenizer(content, ".")).countTokens() < 4) {
            Logger.getLogger().logLine("wan ip not found on " + this.dynWANIPRetrievalURL);
            return wanip;
        }
        String ip = "";
        String token = tokenizer.nextToken();
        if (!this.isPosInt(token)) {
            Logger.getLogger().logLine("wan ip not found on " + this.dynWANIPRetrievalURL);
            return wanip;
        }
        ip = String.valueOf(ip) + token + ".";
        token = tokenizer.nextToken();
        if (!this.isPosInt(token)) {
            Logger.getLogger().logLine("wan ip not found on " + this.dynWANIPRetrievalURL);
            return wanip;
        }
        ip = String.valueOf(ip) + token + ".";
        token = tokenizer.nextToken();
        if (!this.isPosInt(token)) {
            Logger.getLogger().logLine("wan ip not found on " + this.dynWANIPRetrievalURL);
            return wanip;
        }
        ip = String.valueOf(ip) + token + ".";
        String last = tokenizer.nextToken();
        String lastPart = "";
        lastPart = "" + last.charAt(0);
        if (!this.isPosInt(lastPart)) {
            Logger.getLogger().logLine("wan ip not found on " + this.dynWANIPRetrievalURL);
            return wanip;
        }
        if (last.length() > 1 && this.isDigit(Character.valueOf(last.charAt(1)))) {
            lastPart = String.valueOf(lastPart) + last.charAt(1);
        }
        if (last.length() > 2 && this.isDigit(Character.valueOf(last.charAt(1))) && this.isDigit(Character.valueOf(last.charAt(2)))) {
            lastPart = String.valueOf(lastPart) + last.charAt(2);
        }
        wanip = ip = String.valueOf(ip) + lastPart;
        return wanip;
    }

    public void publishToDynDNS(String ip) {
        try {
            if (this.use_dynip_cfg) {
                DynIPPublisher.main(new String[]{ip});
            } else {
                if (this.dynDNSUrlStr == null) {
                    return;
                }
                String urlStr = this.dynDNSUrlStr.replace("${IP}", ip);
                Logger.getLogger().logLine("Processing publishing to DYN DNS Service via URL:" + urlStr);
                URL url = new URL(urlStr);
                HttpURLConnection receiver = url.openConnection(Proxy.NO_PROXY);
                if (this.dynDNSAuth != null) {
                    receiver.setRequestProperty("Authorization", this.dynDNSAuth);
                }
                receiver.setConnectTimeout(100000);
                receiver.setReadTimeout(100000);
                InputStream in = receiver.getInputStream();
                String response = new String(Utils.readFully(in, 256));
                Logger.getLogger().logLine("");
                Logger.getLogger().logLine(">>> BEGIN MESSAGE RECEIVED FROM DYN DNS REGISTRATION!");
                Logger.getLogger().logLine(response);
                Logger.getLogger().logLine(">>> END MESSAGE RECEIVED FROM DYN DNS REGISTRATION!");
                Logger.getLogger().logLine("");
            }
        }
        catch (IOException eio) {
            Logger.getLogger().logLine("Failed to publish IP to external Dyn DNS Service: " + eio.toString());
        }
    }

    public void publishWanIP(String ip) throws Exception {
        this.publishToDynDNS(ip);
        if (!this.id.equals("")) {
            Logger.getLogger().logLine("Processing publishing of dynamic IP to zenz-solutions...");
            String publishStr = "ip=" + ip;
            ByteArrayOutputStream encrbytes = new ByteArrayOutputStream();
            OutputStream encrOut = Encryption.getEncryptedOutputStream(encrbytes, 1024);
            encrOut.write(publishStr.getBytes());
            encrOut.flush();
            encrOut.close();
            publishStr = new BASE64Encoder().encode(encrbytes.toByteArray());
            publishStr = publishStr.replace("/", "-").replace("+", ".");
            try {
                String urlstr = String.valueOf(DYN_URL) + "RegisterIP.php?id=" + this.id + "&ip=" + publishStr;
                URL url = new URL(urlstr);
                HttpURLConnection receiver = url.openConnection(Proxy.NO_PROXY);
                receiver.setConnectTimeout(100000);
                receiver.setReadTimeout(100000);
                InputStream in = receiver.getInputStream();
                String response = new String(Utils.readFully(in, 256));
                Logger.getLogger().logLine("");
                Logger.getLogger().logLine(">>>>>> BEGIN MESSAGE RECEIVED FROM REGISTRATION!");
                Logger.getLogger().logLine(response);
                Logger.getLogger().logLine("<<<<<< END MESSAGE RECEIVED FROM REGISTRATION!");
                Logger.getLogger().logLine("");
                if (!response.startsWith("OK")) {
                    throw new Exception("Error during registration of dynamic IP! - See message from registration!");
                }
            }
            catch (IOException e) {
                String msg = "I/O Error during registration of dynamic IP! - Make sure Internet Connection is available!\r\n" + e.getMessage();
                throw new IOException(String.valueOf(msg) + " - " + e.getMessage());
            }
        }
    }

    @Override
    public synchronized void run() {
        boolean lastSuccess = true;
        while (!this.stopped) {
            try {
                String wanIP;
                if (!(this.stopped || !this.lastIP.equals("") && this.internalPingSuccess() || (wanIP = this.getWanIP()).equals(this.lastIP) || wanIP.equals("<unknown>"))) {
                    Logger.getLogger().logLine("New WAN IP detected: " + wanIP);
                    this.publishWanIP(wanIP);
                    this.lastIP = wanIP;
                    Logger.getLogger().logLine("New WAN IP published: " + wanIP);
                    lastSuccess = true;
                }
            }
            catch (Exception e) {
                if (lastSuccess) {
                    Logger.getLogger().logLine("Exception in retrieving and publishing WAN IP:" + e.toString());
                }
                lastSuccess = false;
            }
            try {
                this.wait(this.dynWANIPCheckInterval);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    private boolean internalPingSuccess() {
        String pingURL = "";
        boolean sslPing = false;
        try {
            pingURL = TunnelServer.config.getProperty("external_url", "").trim();
            if (pingURL.equals("")) {
                if (Integer.parseInt(this.config.getProperty("port", "8000")) != -1) {
                    pingURL = "http://" + this.lastIP + ":" + TunnelServer.config.getProperty("external_port", "80");
                } else if (Integer.parseInt(this.config.getProperty("ssl_port", "4430")) != -1) {
                    pingURL = "https://" + this.lastIP + ":" + TunnelServer.config.getProperty("external_port", "443");
                    sslPing = true;
                } else {
                    throw new Exception("No Server available!");
                }
            }
            URL url = new URL(pingURL);
            HttpURLConnection receiver = url.openConnection(Proxy.NO_PROXY);
            if (sslPing) {
                receiver.setSSLSocketFactory(this.getLocalSSLSocketFactory());
            }
            receiver.setRequestProperty("Authorization", TunnelServer.RANDOMSTR);
            receiver.setConnectTimeout(2000);
            receiver.setReadTimeout(2000);
            InputStream in = receiver.getInputStream();
            String response = Utils.readLineFromStream(in);
            Utils.readFully(in, 100);
            if (!response.equals(TunnelServer.RANDOMSTR)) {
                throw new Exception("Invalid Ping response received:" + response);
            }
            return true;
        }
        catch (Exception e) {
            Logger.getLogger().logLine("Internal Ping Failed:" + e.getMessage());
            Logger.getLogger().logLine("Internal Ping URL:'" + pingURL + "'");
            Logger.getLogger().logLine("Refer to setting `external_port\u00b4 in tunnelserver.properties!");
            return false;
        }
    }

    private SSLSocketFactory getLocalSSLSocketFactory() throws IOException {
        if (this.localSSLSocketFactory == null) {
            this.localSSLSocketFactory = TunnelServer.getLocalSSLSocketFactory(String.valueOf(ExecutionEnvironment.getEnvironment().getWorkDir()) + TunnelServer.config.getProperty("sslKeystore", "keystore.jks"), TunnelServer.config.getProperty("sslKeystorePassword", ""));
        }
        return this.localSSLSocketFactory;
    }

    public synchronized void stop() {
        this.stopped = true;
        this.notifyAll();
    }
}

