/*
 * Decompiled with CFR 0.152.
 */
package mysoft.httptunnel;

import java.net.Socket;
import mysoft.httptunnel.TunnelClientWatchDog;
import mysoft.httptunnel.TunnelServer;
import udpproxy.UDPBridge;
import util.Logger;
import util.PipedSocket;
import util.commands.CommandRunner;

public abstract class TunnelSession {
    public abstract boolean isAlive();

    public abstract void killSession() throws Exception;

    public abstract String getClientId();

    public abstract void setInvalid();

    public Socket connectTunnel(String clientID, String socketClientId, String host, int port) throws Exception {
        Logger.getLogger().logLine("Tunnel Connecting to: " + host + ":" + port + "...");
        if (port == 0 && host.equals("$HTTPPROXY$")) {
            return TunnelServer.httpProxy.connectServer(socketClientId);
        }
        if (port == 0 && host.equals("$WATCHDOG$")) {
            return new TunnelClientWatchDog(clientID);
        }
        if (port == 0 && host.equals("$UDPBRIDGE$")) {
            return new UDPBridge();
        }
        if (port == TunnelServer.CMD_RUNNER_PORT && (host.equals("localhost") || host.startsWith("127.0.0.1") || host.equals("::1"))) {
            PipedSocket pipedSocket = new PipedSocket("CommandRunner");
            new CommandRunner(pipedSocket.getOtherEnd());
            return pipedSocket;
        }
        if (TunnelServer.biDirectionalTunnel != null && port == TunnelServer.biDirectionalTunnel.getVirtualPort() && (host.equals("localhost") || host.startsWith("127.0.0.1") || host.equals("::1"))) {
            PipedSocket pipedSocket = new PipedSocket("ReverseTunnel");
            TunnelServer.biDirectionalTunnel.runNewRemoteServer(pipedSocket.getOtherEnd());
            return pipedSocket;
        }
        return new Socket(host, port);
    }
}

