/*
 * Decompiled with CFR 0.152.
 */
package mysoft.httptunnel;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.security.KeyStore;
import java.util.HashSet;
import java.util.Properties;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import mysoft.httptunnel.RemoteServerProxyHandler;
import mysoft.httptunnel.TunnelSessionHandler;
import mysoft.httptunnel.WanIPPublisher;
import mysoft.httptunnel.threadpool.ThreadPool;
import proxy.HttpProxy;
import util.BASE64Encoder;
import util.Encryption;
import util.ExecutionEnvironment;
import util.FileLogger;
import util.GroupedLogger;
import util.Logger;
import util.LoggerInterface;
import util.Utils;
import util.http.HttpChunkedInputStream;

public class TunnelServer
implements Runnable {
    private static String VERSION = "1.5.55.1";
    public static String WORKDIR = "";
    protected static int CONREUSETIMEOUT = 200;
    protected static String RANDOMSTR = "";
    protected static Properties config = null;
    protected static TunnelSessionHandler m_tunnelInstance = null;
    protected static ThreadPool threadPool = null;
    private static ClientSocketChecker clientChecker = null;
    private static int socketCheckTimeout = 5000;
    protected static RemoteServerProxyHandler biDirectionalTunnel = null;
    protected static HttpProxy httpProxy = null;
    protected static int WRITE_BUFSIZE = 1024;
    private static boolean debug = false;
    private Socket m_client = null;
    private boolean validHeaderReceived = false;
    private boolean clientInvalid = false;
    private long creationTS = 0L;
    private ServerSocket m_server = null;
    private boolean ssl = false;
    private String role = "";
    private boolean killed = false;
    private boolean listenerStopped = false;
    private WanIPPublisher wanIPPublisher = null;
    private static String ENCRAUTHSTRING = "";
    private static LoggerInterface LOGGER = null;
    private TunnelServer sslServer = null;
    private TunnelServer plainServer = null;
    protected static boolean RESTRICT_REMOTE = false;
    protected static String REMOTE_PERM_TOKEN = "";
    public static int CMD_RUNNER_PORT = 9001;

    public TunnelServer(Socket client, boolean ssl) {
        this.ssl = ssl;
        this.m_client = client;
        this.role = "SESSION";
        threadPool.startThread(this);
        this.creationTS = System.currentTimeMillis();
        clientChecker.addSession(this);
    }

    public TunnelServer(int port, boolean ssl) throws IOException {
        this.ssl = ssl;
        this.role = "LISTENER_LOOP";
        boolean listener_localOnly = Boolean.parseBoolean(config.getProperty("listener_local_only", "false"));
        if (ssl) {
            SSLServerSocketFactory ssf = TunnelServer.getSSLServerFactory(String.valueOf(ExecutionEnvironment.getEnvironment().getWorkDir()) + config.getProperty("sslKeystore", "keystore.jks"), config.getProperty("sslKeystorePassword", ""));
            this.m_server = listener_localOnly ? ssf.createServerSocket(port, 0, InetAddress.getByName("127.0.0.1")) : ssf.createServerSocket(port, 0, null);
        } else {
            this.m_server = listener_localOnly ? new ServerSocket(port, 0, InetAddress.getByName("127.0.0.1")) : new ServerSocket(port, 0, null);
        }
    }

    private static SSLServerSocketFactory getSSLServerFactory(String keystoreFile, String password) throws IOException {
        Logger.getLogger().logLine("Init SSL Keystore: " + keystoreFile);
        try {
            String storeType;
            if (keystoreFile.toUpperCase().endsWith(".JKS")) {
                storeType = "JKS";
            } else if (keystoreFile.toUpperCase().endsWith(".BKS")) {
                storeType = "BKS";
            } else {
                throw new IOException("Keystore file should be either a '.JKS' or '.BKS' file!");
            }
            KeyStore keyStore = KeyStore.getInstance(storeType);
            FileInputStream keyStoreStream = new FileInputStream(keystoreFile);
            keyStore.load(keyStoreStream, password.toCharArray());
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            keyManagerFactory.init(keyStore, password.toCharArray());
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(keyManagerFactory.getKeyManagers(), null, null);
            SSLServerSocketFactory factory = sslContext.getServerSocketFactory();
            return factory;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    protected static SSLSocketFactory getLocalSSLSocketFactory(String keystoreFile, String password) throws IOException {
        try {
            String storeType;
            if (keystoreFile.toUpperCase().endsWith(".JKS")) {
                storeType = "JKS";
            } else if (keystoreFile.toUpperCase().endsWith(".BKS")) {
                storeType = "BKS";
            } else {
                throw new IOException("Keystore file should be either a '.JKS' or '.BKS' file!");
            }
            KeyStore keyStore = KeyStore.getInstance(storeType);
            FileInputStream keyStoreStream = new FileInputStream(keystoreFile);
            keyStore.load(keyStoreStream, password.toCharArray());
            TrustManagerFactory keyManagerFactory = TrustManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            keyManagerFactory.init(keyStore);
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, keyManagerFactory.getTrustManagers(), null);
            SSLSocketFactory factory = sslContext.getSocketFactory();
            return factory;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public TunnelServer() throws Exception {
        config = new Properties();
        FileInputStream in = new FileInputStream(String.valueOf(WORKDIR) + "TunnelServer.properties");
        config.load(in);
        in.close();
        if (LOGGER == null) {
            FileLogger fileLogger = new FileLogger(String.valueOf(WORKDIR) + "log", config.getProperty("LogName", "tunnelserverlog"), Integer.parseInt(config.getProperty("LogSize", "1048576").trim()), Integer.parseInt(config.getProperty("LogSlotCount", "2").trim()), null);
            fileLogger.enableTimestamp(true);
            LOGGER = new GroupedLogger(new LoggerInterface[]{Logger.getLogger(), fileLogger});
            Logger.setLogger(LOGGER);
        }
        Logger.getLogger().logLine("***************************************************");
        Logger.getLogger().logLine("*    This is PersonalHttpTunnel Version: " + VERSION + "   *");
        Logger.getLogger().logLine("* http://www.zenz-solutions.de/personalhttptunnel *");
        Logger.getLogger().logLine("***************************************************");
        RANDOMSTR = "" + (long)(9.223372036854776E18 * Math.random());
        RESTRICT_REMOTE = Boolean.parseBoolean(config.getProperty("restrict_remote", "false"));
        if (RESTRICT_REMOTE) {
            FileInputStream permIn = new FileInputStream(String.valueOf(WORKDIR) + "remote.perm");
            REMOTE_PERM_TOKEN = new String(Utils.readFully(permIn, 256));
            ((InputStream)permIn).close();
        }
        int threads = Integer.parseInt(config.getProperty("threads", "50"));
        WRITE_BUFSIZE = Integer.parseInt(config.getProperty("SEND_BUFFER_BYTES", "1024"));
        Encryption.init(new FileInputStream(String.valueOf(WORKDIR) + "key"), config.getProperty("ENCR_METHOD", "AES"));
        ENCRAUTHSTRING = new BASE64Encoder().encode(Encryption.encrypt(Utils.AUTHSTRING.getBytes()));
        CMD_RUNNER_PORT = Integer.parseInt(config.getProperty("CMD_RQ_PORT", "9001"));
        if (new Boolean(config.getProperty("publishDynIP", "true")).booleanValue()) {
            this.wanIPPublisher = new WanIPPublisher(config);
            new Thread(this.wanIPPublisher).start();
        }
        m_tunnelInstance = new TunnelSessionHandler();
        threadPool = new ThreadPool(threads);
        clientChecker = new ClientSocketChecker();
        new Thread(clientChecker).start();
        biDirectionalTunnel = new Boolean(config.getProperty("allowRemoteServerProxy", "false")) != false ? new RemoteServerProxyHandler(config, m_tunnelInstance) : null;
        HttpProxy.WORKDIR = WORKDIR;
        httpProxy = new HttpProxy();
        httpProxy.initMainLoop(new String[]{"-async"});
        int port = Integer.parseInt(config.getProperty("ssl_port", "-1"));
        if (port != -1) {
            this.sslServer = new TunnelServer(port, true);
            new Thread(this.sslServer).start();
        }
        if ((port = Integer.parseInt(config.getProperty("port", "8000"))) != -1) {
            this.plainServer = new TunnelServer(port, false);
            new Thread(this.plainServer).start();
        }
    }

    private void sendDefaultPage(OutputStream out) {
        try {
            int r;
            FileInputStream in = new FileInputStream(String.valueOf(WORKDIR) + "default.html");
            byte[] buf = new byte[1024];
            while ((r = in.read(buf)) != -1) {
                out.write(buf, 0, r);
            }
            out.flush();
            in.close();
        }
        catch (Exception e) {
            Logger.getLogger().logLine("sendDefaultPage failed: " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block52: {
            OutputStream out = null;
            DataInputStream inStr = null;
            if (this.role.equals("SESSION")) {
                try {
                    try {
                        if (debug) {
                            Logger.getLogger().logLine("++++++++++++++++++new Session:" + this);
                        }
                        out = this.m_client.getOutputStream();
                        inStr = new DataInputStream(this.m_client.getInputStream());
                        boolean socketActive = true;
                        while (socketActive) {
                            InputStream in;
                            this.m_client.setSoTimeout(CONREUSETIMEOUT * 1000);
                            boolean headercomplete = false;
                            int length = 0;
                            Object authstr = null;
                            String ln = Utils.readLineFromStream(inStr, false, true);
                            if (ln != null && ln.equals(ENCRAUTHSTRING)) {
                                this.validHeaderReceived = true;
                                this.m_client.setSoTimeout(0);
                                m_tunnelInstance.handleDirectPassThroughSession(this.m_client);
                                break block52;
                            }
                            socketActive = ln != null;
                            headercomplete = ln == null;
                            String lengthStr = null;
                            String authStr = null;
                            boolean chunked = false;
                            while (!headercomplete && socketActive) {
                                String origLn = ln;
                                ln = ln.toLowerCase();
                                int chunkedIndex = -1;
                                int authindex = -1;
                                int index = -1;
                                if (lengthStr == null) {
                                    index = ln.indexOf("content-length");
                                }
                                if (index != -1 || !chunked) {
                                    // empty if block
                                }
                                if ((chunkedIndex = ln.indexOf("transfer-encoding:")) == -1 && authStr == null) {
                                    authindex = ln.indexOf("authorization:");
                                }
                                if (index != -1) {
                                    index = ln.indexOf(":");
                                    lengthStr = ln.substring(index + 1).trim();
                                    length = Integer.parseInt(lengthStr);
                                }
                                if (chunkedIndex != -1) {
                                    index = ln.indexOf(":");
                                    chunked = ln.substring(index + 1).trim().equalsIgnoreCase("chunked");
                                }
                                if (authindex != -1) {
                                    index = ln.indexOf(":");
                                    authStr = origLn.substring(index + 1).trim();
                                }
                                socketActive = (ln = Utils.readLineFromStream(inStr, false, true)) != null;
                                boolean bl = headercomplete = ln == null || ln.equals("");
                            }
                            this.m_client.setSoTimeout(0);
                            this.validHeaderReceived = true;
                            if (socketActive && length == 0 && !chunked && authStr != null && authStr.equals(RANDOMSTR)) {
                                socketActive = false;
                                out.write("HTTP/1.1 200 OK\r\n\r\n".getBytes());
                                out.write((String.valueOf(RANDOMSTR) + "\n").getBytes());
                                out.flush();
                                if (debug) {
                                    Logger.getLogger().logLine("Internal Ping Received!");
                                }
                            } else if (socketActive && length == 0 && !chunked) {
                                socketActive = false;
                                out.write("HTTP/1.1 200 OK\r\n\r\n".getBytes());
                                this.sendDefaultPage(out);
                                Logger.getLogger().logLine("Invalid Data! 0 length Content! - Send Default Page! Client:" + this.m_client.getRemoteSocketAddress());
                            } else if (socketActive && (authStr == null || !authStr.equals(ENCRAUTHSTRING))) {
                                socketActive = false;
                                Logger.getLogger().logLine("Unauthorized! - Socket will be closed!");
                                out.write("HTTP/1.1 401 Unauthorized\r\n\r\n".getBytes());
                            }
                            if (!socketActive) continue;
                            if (!chunked) {
                                byte[] buf = new byte[length];
                                inStr.readFully(buf);
                                in = new ByteArrayInputStream(buf);
                            } else {
                                in = new HttpChunkedInputStream(inStr);
                            }
                            socketActive = m_tunnelInstance.doSession(in, out, this.m_client, chunked);
                        }
                        break block52;
                    }
                    catch (SocketTimeoutException e) {
                        Logger.getLogger().logLine(this + ":Socket REUSE TIMEOUT!");
                        try {
                            if (!this.clientInvalid) {
                                if (out != null) {
                                    out.flush();
                                }
                                if (!this.ssl) {
                                    this.m_client.shutdownOutput();
                                    this.m_client.shutdownInput();
                                }
                                this.m_client.close();
                            }
                            break block52;
                        }
                        catch (Exception e2) {
                            Logger.getLogger().logLine("Exception in TunnelServer.run() during final Connection Cleanup:" + e2.getMessage());
                        }
                        break block52;
                    }
                    catch (Exception e) {
                        block53: {
                            if (this.clientInvalid) {
                                Logger.getLogger().logLine(this + ":Socket Invalid - Socket closed!");
                                break block53;
                            }
                            Logger.getLogger().logLine("Catched Exception on " + this.m_client + "! - " + e);
                        }
                        try {
                            if (!this.clientInvalid) {
                                if (out != null) {
                                    out.flush();
                                }
                                if (!this.ssl) {
                                    this.m_client.shutdownOutput();
                                    this.m_client.shutdownInput();
                                }
                                this.m_client.close();
                            }
                            break block52;
                        }
                        catch (Exception e3) {
                            Logger.getLogger().logLine("Exception in TunnelServer.run() during final Connection Cleanup:" + e3.getMessage());
                        }
                        break block52;
                    }
                }
                finally {
                    try {
                        if (!this.clientInvalid) {
                            if (out != null) {
                                out.flush();
                            }
                            if (!this.ssl) {
                                this.m_client.shutdownOutput();
                                this.m_client.shutdownInput();
                            }
                            this.m_client.close();
                        }
                    }
                    catch (Exception e) {
                        Logger.getLogger().logLine("Exception in TunnelServer.run() during final Connection Cleanup:" + e.getMessage());
                    }
                }
            }
            Logger.getLogger().logLine("TunnelServer ready! Waiting for connection requests on " + this.m_server);
            while (!this.killed) {
                try {
                    Socket client = this.m_server.accept();
                    client.setSoTimeout(0);
                    if (debug) {
                        Logger.getLogger().logLine("New Client Connected: " + client);
                    }
                    new TunnelServer(client, this.ssl);
                }
                catch (IOException e) {
                    TunnelServer tunnelServer = this;
                    synchronized (tunnelServer) {
                        if (!this.killed) {
                            Logger.getLogger().logException(e);
                        }
                        this.listenerStopped = true;
                        this.notifyAll();
                    }
                }
            }
        }
    }

    public void checkClient() {
        try {
            if (System.currentTimeMillis() - this.creationTS < (long)socketCheckTimeout) {
                return;
            }
            clientChecker.removeSession(this);
            if (!this.validHeaderReceived) {
                Logger.getLogger().logLine("No valid data from client within timeout! - Socket will be closed! -" + this.m_client);
                this.clientInvalid = true;
                if (!this.ssl) {
                    this.m_client.shutdownInput();
                    this.m_client.shutdownOutput();
                }
                if (!this.m_client.isClosed()) {
                    this.m_client.close();
                }
            }
        }
        catch (Exception e) {
            Logger.getLogger().logLine("Exception during client check:" + e.getMessage());
        }
    }

    public synchronized void kill() throws Exception {
        if (this.sslServer != null) {
            this.sslServer.stopListener();
        }
        if (this.plainServer != null) {
            this.plainServer.stopListener();
        }
        if (this.wanIPPublisher != null) {
            this.wanIPPublisher.stop();
        }
        if (biDirectionalTunnel != null) {
            biDirectionalTunnel.stop();
        }
        if (m_tunnelInstance != null) {
            m_tunnelInstance.stop();
        }
        clientChecker.kill();
        httpProxy.stop();
        Logger.getLogger().logLine("Tunnel down!");
        threadPool.stop();
    }

    public synchronized void stopListener() throws Exception {
        this.killed = true;
        this.m_server.close();
        Logger.getLogger().logLine(this.m_server + " closed!");
        Logger.getLogger().logLine("waiting for Listner Loop to stop...");
        while (!this.listenerStopped) {
            this.wait();
        }
    }

    private class ClientSocketChecker
    implements Runnable {
        HashSet sessions = new HashSet();
        boolean killed = false;

        private ClientSocketChecker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.killed) {
                try {
                    Object[] all = null;
                    ClientSocketChecker clientSocketChecker = this;
                    synchronized (clientSocketChecker) {
                        all = this.sessions.toArray();
                    }
                    int i = 0;
                    while (i < all.length) {
                        ((TunnelServer)all[i]).checkClient();
                        ++i;
                    }
                    clientSocketChecker = this;
                    synchronized (clientSocketChecker) {
                        this.wait(1000L);
                    }
                }
                catch (Exception e) {
                    Logger.getLogger().logException(e);
                }
            }
        }

        public synchronized void addSession(TunnelServer session) {
            this.sessions.add(session);
        }

        public synchronized void removeSession(TunnelServer session) {
            this.sessions.remove(session);
        }

        public synchronized void kill() {
            this.killed = true;
            this.notifyAll();
        }
    }
}

