/*
 * Decompiled with CFR 0.152.
 */
package mysoft.httptunnel;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import mysoft.httptunnel.TunnelServer;
import util.Logger;
import util.TimeoutListener;
import util.TimeoutTime;
import util.TimoutNotificator;

public class TunnelClientWatchDog
extends Socket
implements TimeoutListener {
    private int to = 0;
    private int reply = -1;
    boolean closed = false;
    private static final int IDLE_TO = 60000;
    private String clientId;
    private InputStream in;
    private OutputStream out;
    private TimeoutTime idleTimeout;

    public TunnelClientWatchDog(String clientId) {
        this.clientId = clientId;
        this.in = new ClientWatchDogInputStream();
        this.out = new ClientWatchDogOutputStream();
        this.idleTimeout = new TimeoutTime(TimoutNotificator.getInstance());
        this.idleTimeout.setTimeout(60000L);
        TimoutNotificator.getInstance().register(this);
        Logger.getLogger().logLine("Initialized TunnelClientWatchDog for ID=" + clientId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeWatchDog() {
        InputStream inputStream = this.in;
        synchronized (inputStream) {
            if (this.closed) {
                return;
            }
            this.closed = true;
            this.in.notify();
        }
        TimoutNotificator.getInstance().unregister(this);
    }

    @Override
    public InputStream getInputStream() {
        return this.in;
    }

    @Override
    public OutputStream getOutputStream() {
        return this.out;
    }

    @Override
    public void close() {
        this.closeWatchDog();
    }

    @Override
    public void shutdownInput() {
    }

    @Override
    public void shutdownOutput() {
    }

    @Override
    public void setSoTimeout(int to) {
        this.to = to;
    }

    @Override
    public void timeoutNotification() {
        Logger.getLogger().logLine("Tunnelclient with ID=" + this.clientId + " is dead!");
        this.close();
        TunnelServer.m_tunnelInstance.invalidateSessions(this.clientId);
    }

    @Override
    public long getTimoutTime() {
        return this.idleTimeout.getTimeout();
    }

    static /* synthetic */ int access$3(TunnelClientWatchDog tunnelClientWatchDog) {
        return tunnelClientWatchDog.reply;
    }

    static /* synthetic */ int access$4(TunnelClientWatchDog tunnelClientWatchDog) {
        return tunnelClientWatchDog.to;
    }

    private class ClientWatchDogInputStream
    extends InputStream {
        private ClientWatchDogInputStream() {
        }

        /*
         * Exception decompiling
         */
        @Override
        public synchronized int read() throws IOException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int val = this.read();
            if (val != -1) {
                b[0] = (byte)val;
                return 1;
            }
            return -1;
        }

        @Override
        public void close() {
            TunnelClientWatchDog.this.closeWatchDog();
        }
    }

    private class ClientWatchDogOutputStream
    extends OutputStream {
        private ClientWatchDogOutputStream() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(int b) throws IOException {
            TunnelClientWatchDog.this.idleTimeout.setTimeout(60000L);
            InputStream inputStream = TunnelClientWatchDog.this.in;
            synchronized (inputStream) {
                TunnelClientWatchDog.this.reply = b;
                TunnelClientWatchDog.this.in.notifyAll();
            }
        }

        @Override
        public void close() {
            TunnelClientWatchDog.this.closeWatchDog();
        }
    }
}

