/*
 * Decompiled with CFR 0.152.
 */
package mysoft.httptunnel;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import mysoft.httptunnel.DirectPassThroughSession;
import mysoft.httptunnel.HTTPTunnelSession;
import mysoft.httptunnel.RemoteServerProxyHandler;
import mysoft.httptunnel.TunnelSession;
import mysoft.httptunnel.TunnelSessionHandler;
import util.Logger;
import util.Utils;

public class RemoteServerProxy
implements Runnable {
    private static int NOTIFY_ALIVE_MSG_TIME_INTERVAL = 300000;
    private InputStream in = null;
    private OutputStream out = null;
    private ServerSocket proxyServer = null;
    private boolean open = false;
    private TunnelSessionHandler m_tunnelInstance;
    private Socket m_realServer;
    private int port = -1;
    private int conRefreshInterval = 0;
    private byte conMode = 0;
    private String clientID = "";
    private RemoteServerProxyHandler m_remoteServerProxyHandler;

    public RemoteServerProxy(Socket realServer, TunnelSessionHandler tunnelInstance, RemoteServerProxyHandler remoteServerProxyHandler) {
        this.m_remoteServerProxyHandler = remoteServerProxyHandler;
        this.m_tunnelInstance = tunnelInstance;
        this.m_realServer = realServer;
    }

    public int init() {
        try {
            this.in = this.m_realServer.getInputStream();
            this.out = this.m_realServer.getOutputStream();
            this.clientID = Utils.readLineFromStream(this.in);
            this.port = Integer.parseInt(Utils.readLineFromStream(this.in));
            String adapterAddress = Utils.readLineFromStream(this.in);
            this.conRefreshInterval = Integer.parseInt(Utils.readLineFromStream(this.in));
            this.conMode = (byte)this.in.read();
            RemoteServerProxy existing = this.m_remoteServerProxyHandler.getOpenRemoteServerProxy(this.port);
            if (existing != null && !existing.aliveCheck()) {
                Utils.sleep(100L);
            }
            this.proxyServer = adapterAddress.equals("*") ? new ServerSocket(this.port) : new ServerSocket(this.port, 0, InetAddress.getByName(adapterAddress));
            this.open = true;
            this.out.write("OK\n".getBytes());
            this.out.flush();
            Logger.getLogger().logLine("Opened Remote Server Proxy " + this + " on port: " + this.port);
            new Thread(this).start();
            return this.port;
        }
        catch (Exception e) {
            Logger.getLogger().logLine("Failed to open Remote Server Proxy! " + e.getMessage());
            try {
                if (this.out != null) {
                    this.out.write((String.valueOf(e.getMessage()) + "\n").getBytes());
                    this.out.flush();
                    this.out.close();
                }
                this.m_realServer.shutdownInput();
                this.m_realServer.shutdownOutput();
                this.m_realServer.close();
            }
            catch (IOException e1) {
                Logger.getLogger().logException(e1);
            }
            return -1;
        }
    }

    @Override
    public void run() {
        while (this.open) {
            Socket client = null;
            try {
                this.proxyServer.setSoTimeout(NOTIFY_ALIVE_MSG_TIME_INTERVAL);
                client = this.proxyServer.accept();
                InetAddress inetAdr = client.getInetAddress();
                String host = inetAdr.getHostName();
                int port = client.getPort();
                TunnelSession tunnelSession = null;
                if ((this.conMode & Utils.CON_MODE_DIRECT) == 0) {
                    tunnelSession = new HTTPTunnelSession(this.clientID, host, port, this.conRefreshInterval, this.conMode);
                    ((HTTPTunnelSession)tunnelSession).connect(client);
                } else {
                    tunnelSession = new DirectPassThroughSession(this.clientID);
                    tunnelSession.connect(client);
                }
                String id = this.m_tunnelInstance.register(tunnelSession, null);
                long sid = Long.parseLong(id) ^ Long.MAX_VALUE;
                this.out.write(("ACCEPTED\n" + sid + "\n").getBytes());
                this.out.write(Utils.serializeObject(inetAdr));
                this.out.flush();
                Logger.getLogger().logLine("Connection to Remote Server Proxy " + this + " from " + host + ":" + port);
            }
            catch (SocketTimeoutException sto) {
                try {
                    this.out.write("NOTIFY_ALIVE\n".getBytes());
                    this.out.flush();
                }
                catch (IOException ioe) {
                    if (!this.open) continue;
                    Logger.getLogger().logException(ioe);
                }
            }
            catch (Exception e) {
                if (this.open) {
                    Logger.getLogger().logException(e);
                }
                if (client == null) continue;
                try {
                    client.shutdownInput();
                    client.shutdownOutput();
                    client.close();
                }
                catch (IOException e1) {
                    Logger.getLogger().logException(e);
                }
            }
        }
        Logger.getLogger().logLine("Terminated Listener for Remote Server Proxy " + this + " on port: " + this.port);
    }

    public synchronized void stop() {
        if (!this.open) {
            return;
        }
        this.open = false;
        try {
            this.proxyServer.close();
            this.m_remoteServerProxyHandler.unregister(this.port);
        }
        catch (IOException e) {
            Logger.getLogger().logException(e);
        }
    }

    public boolean aliveCheck() {
        boolean alive;
        block16: {
            try {
                this.m_realServer.setSoTimeout(1);
                this.in.read();
                alive = false;
            }
            catch (SocketTimeoutException sto) {
                alive = true;
                try {
                    this.m_realServer.setSoTimeout(0);
                }
                catch (SocketException e) {
                    Logger.getLogger().logException(e);
                    alive = false;
                }
                break block16;
            }
            catch (IOException ioe) {
                try {
                    alive = false;
                    break block16;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    try {
                        this.m_realServer.setSoTimeout(0);
                    }
                    catch (SocketException e) {
                        Logger.getLogger().logException(e);
                        alive = false;
                    }
                }
            }
            try {
                this.m_realServer.setSoTimeout(0);
            }
            catch (SocketException e) {
                Logger.getLogger().logException(e);
                alive = false;
            }
        }
        if (!alive) {
            this.stop();
        }
        return alive;
    }
}

