/*
 * Decompiled with CFR 0.152.
 */
package mysoft.httptunnel;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import mysoft.httptunnel.TunnelServer;
import mysoft.httptunnel.TunnelSession;
import util.Logger;
import util.Utils;

public class HTTPTunnelSession
extends TunnelSession {
    private String clientID;
    private String host;
    private int port;
    private InputStream serverIn;
    private OutputStream serverOut;
    private Socket socketToServer;
    private OutputStream toClient;
    private boolean m_closeSessionCalled = false;
    private long m_lastSent = 0L;
    private long m_lastReceiver = 0L;
    private Socket httpRecClient = null;
    private Socket httpSendClient = null;
    private boolean lastAliveCheckOK = true;
    private boolean valid = true;
    private byte mode;
    boolean sessionDead = false;
    private Object waitMon = new Object();
    private boolean do_internal_alivecheck = false;
    private long bytesSendToClient;
    private int conRefreshInterval;

    public HTTPTunnelSession(String clientID, String host, int port, int conRefreshInterval, byte mode) {
        this.clientID = clientID;
        this.host = host;
        this.port = port;
        this.conRefreshInterval = conRefreshInterval;
        this.mode = mode;
        this.do_internal_alivecheck = (mode & Utils.CON_MODE_WATCH_ENABLED) == 0;
        this.m_lastReceiver = System.currentTimeMillis();
    }

    public InetAddress connect(String socketClientId) throws Exception {
        this.socketToServer = this.connectTunnel(this.clientID, socketClientId, this.host, this.port);
        this.serverIn = new BufferedInputStream(this.socketToServer.getInputStream());
        this.serverOut = this.socketToServer.getOutputStream();
        this.bytesSendToClient = 0L;
        return this.socketToServer.getInetAddress();
    }

    public void connect(Socket socketToServer) throws Exception {
        this.socketToServer = socketToServer;
        this.serverIn = new BufferedInputStream(socketToServer.getInputStream());
        this.serverOut = socketToServer.getOutputStream();
        this.bytesSendToClient = 0L;
    }

    public byte getMode() {
        return this.mode;
    }

    public boolean runReceiverChannel(OutputStream client, Socket httpClient) {
        Logger.getLogger().logLine("receiverchannel " + this + " started!");
        this.httpRecClient = httpClient;
        try {
            this.httpRecClient.setSoTimeout(1);
        }
        catch (SocketException e1) {
            Logger.getLogger().logException(e1);
        }
        try {
            boolean allowBlocking = (this.mode & Utils.CON_MODE_NETWORK_BLOCKS_INPUT) == 0;
            this.socketToServer.setSoTimeout(this.conRefreshInterval);
            this.toClient = client;
            byte[] buf = new byte[TunnelServer.WRITE_BUFSIZE];
            int r = 0;
            while (!this.m_closeSessionCalled && (r = this.serverIn.read(buf)) != -1) {
                this.toClient.write(buf, 0, r);
                this.toClient.flush();
                this.bytesSendToClient += (long)r;
                if (allowBlocking) continue;
                this.socketToServer.setSoTimeout(100);
            }
            if (!this.m_closeSessionCalled) {
                this.closeSocketIgnoreException();
            }
            return true;
        }
        catch (InterruptedIOException eio) {
            Logger.getLogger().logLine("Blocking IO not allowed or Timeout in runReceiver():" + this);
            this.m_lastReceiver = System.currentTimeMillis();
            return false;
        }
        catch (Exception e) {
            if (!this.m_closeSessionCalled) {
                Logger.getLogger().logException(e);
                Logger.getLogger().logLine("Exception in runReceiver() occurred " + e.toString());
                this.closeSocketIgnoreException();
            }
            return true;
        }
        finally {
            Logger.getLogger().logLine("receiverchannel " + this + " terminated");
            this.httpRecClient = null;
            try {
                httpClient.setSoTimeout(0);
            }
            catch (Exception e) {
                Logger.getLogger().logException(e);
            }
        }
    }

    public void retryReceiverChannel(long bytesReceived) throws IOException {
        if (this.socketToServer.isClosed()) {
            throw new IOException(this + ":Retry failed - Already closed");
        }
        if (this.bytesSendToClient != bytesReceived) {
            this.closeSocketIgnoreException();
            throw new IOException(this + ":Retry failed : Inconsistent state detected: Client reports data received " + bytesReceived + " bytes, Server reports data sent " + this.bytesSendToClient + " bytes");
        }
    }

    public synchronized void sendStream(InputStream fromClient, boolean chunkedRequest, Socket httpclient) throws Exception {
        try {
            this.httpSendClient = httpclient;
            if (this.conRefreshInterval != 0) {
                httpclient.setSoTimeout(this.conRefreshInterval + 10000);
            }
            byte[] buf = new byte[TunnelServer.WRITE_BUFSIZE];
            int r = 0;
            while ((r = fromClient.read(buf)) != -1) {
                this.m_lastSent = System.currentTimeMillis();
                this.serverOut.write(buf, 0, r);
                this.serverOut.flush();
            }
        }
        finally {
            this.httpSendClient = null;
            if (chunkedRequest) {
                Logger.getLogger().logLine("SendStream - chunked request terminated:" + this);
            }
        }
    }

    private void closeSocketIgnoreException() {
        try {
            this.socketToServer.close();
        }
        catch (IOException e) {
            Logger.getLogger().logLine(e.getMessage());
        }
    }

    public synchronized void closeSession() throws Exception {
        this.m_closeSessionCalled = true;
        Logger.getLogger().logLine("Tunnel Closing Conection to: " + this.host + ":" + this.port + "...");
        this.socketToServer.shutdownInput();
        this.socketToServer.shutdownOutput();
        this.serverIn.close();
        this.serverOut.close();
        this.socketToServer.close();
    }

    @Override
    public void setInvalid() {
        this.valid = false;
    }

    @Override
    public void killSession() throws Exception {
        this.killSender();
        this.sessionDead = true;
        this.closeSession();
    }

    private void killSender() {
        Socket sendClient = this.httpSendClient;
        this.httpSendClient = null;
        if (sendClient != null) {
            try {
                sendClient.shutdownInput();
                sendClient.shutdownOutput();
                sendClient.close();
            }
            catch (IOException e) {
                Logger.getLogger().logLine("killSession:" + e.toString());
            }
        }
    }

    private boolean socketAlive(Socket s) {
        try {
            int r = s.getInputStream().read();
            if (r != -1) {
                byte[] buf = new byte[1024];
                int r2 = s.getInputStream().read(buf);
                if (r2 == -1) {
                    r2 = 0;
                }
                Logger.getLogger().logLine("AliveChecker: INCONSISTENT STATE!!! - There is content on client socket:" + (char)r + new String(buf, 0, r2));
            }
            return r != -1;
        }
        catch (SocketTimeoutException e) {
            return true;
        }
        catch (IOException eio) {
            Logger.getLogger().logLine("AliveChecker:Catched Exception during socketAlive check - " + eio.toString());
            return false;
        }
    }

    @Override
    public boolean isAlive() {
        if (!this.valid) {
            return false;
        }
        if (this.do_internal_alivecheck) {
            Socket httpClient = this.httpRecClient;
            if (httpClient != null) {
                boolean clientAlive = this.socketAlive(httpClient);
                if (!clientAlive) {
                    if (this.lastAliveCheckOK) {
                        this.lastAliveCheckOK = false;
                        Logger.getLogger().logLine("AliveChecker: Client Socket is closed " + this);
                        return true;
                    }
                    Logger.getLogger().logLine("AliveChecker: Client Socket is closed - dead Session will be cleaned up " + this);
                    this.sessionDead = true;
                    return false;
                }
                this.lastAliveCheckOK = true;
                return true;
            }
            long cur = System.currentTimeMillis();
            if (cur - this.m_lastReceiver < 5000L) {
                return true;
            }
            return cur - this.m_lastSent < 5000L;
        }
        return true;
    }

    public boolean sessionDied() {
        return this.sessionDead;
    }

    public String toString() {
        return "HTTPTunnelConnection, host=" + this.host + ", port=" + this.port;
    }

    @Override
    public String getClientId() {
        return this.clientID;
    }
}

