/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.util.Hashtable;
import util.LoggerInterface;

public class Logger
implements LoggerInterface {
    private static Hashtable _loggers = new Hashtable();
    private static LoggerInterface m_logger;
    private static LoggerInterface m_default;

    static {
        m_default = new Logger();
    }

    public static void setLogger(LoggerInterface logger) {
        m_logger = logger;
    }

    public static void setLogger(LoggerInterface logger, String id) {
        _loggers.put(id, logger);
    }

    public static void removeLogger(String id) {
        _loggers.remove(id);
    }

    public static LoggerInterface getLogger() {
        if (m_logger != null) {
            return m_logger;
        }
        return m_default;
    }

    public static LoggerInterface getLogger(String id) {
        LoggerInterface l = (LoggerInterface)_loggers.get(id);
        if (l != null) {
            return l;
        }
        return Logger.getLogger();
    }

    @Override
    public void logLine(String txt) {
        System.out.println(txt);
    }

    @Override
    public void logException(Exception e) {
        e.printStackTrace();
    }

    @Override
    public void log(String txt) {
        System.out.print(txt);
    }

    @Override
    public void closeLogger() {
    }
}

