/*
 * Decompiled with CFR 0.152.
 */
package httpproxy;

import httpproxy.HttpProxyRequest;
import httpproxy.HttpProxyResponse;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.Socket;
import java.net.SocketException;
import java.util.Set;
import util.DateRetriever;
import util.Logger;
import util.LoggerInterface;
import util.TimeoutListener;
import util.TimeoutTime;
import util.TimoutNotificator;
import util.conpool.Connection;
import util.http.HttpHeader;

public class HttpProxyServer
extends Socket
implements TimeoutListener {
    public static final byte READ_REQUEST_HEADER = 1;
    public static final byte CONTACT_SERVER = 2;
    public static final byte SEND_REQUEST_HEADER = 3;
    public static final byte PROCESS_REQUEST_BODY = 4;
    public static final byte READ_RESPONSE_HEADER = 5;
    public static final byte RETURN_RESPONSE_HEADER = 6;
    public static final byte PROCESS_RESPONSE_BODY = 7;
    public static final int IDLE_TO = 300000;
    public static final int INIT_CON_TO = 120000;
    private static byte[] TUNNEL_RQ_FILTER_RESP = "HTTP/1.1 403 Forbidden\r\n\r\n".getBytes();
    private LoggerInterface TRAFFIC_LOG;
    private TimeoutTime idleTimeout;
    private String clientID = "<unknkown>";
    private boolean useProxy = false;
    private Proxy chainedProxy = null;
    private Set hostFilter = null;
    private Set urlFilter = null;
    private byte[] filterResponse;
    public boolean closed = false;
    public byte current_status = 1;
    private HttpProxyRequest request = new HttpProxyRequest(this);
    private HttpProxyResponse response;
    private String urlLogEntry = null;
    protected HttpHeader reqHeader = null;
    private Connection httpServer = null;
    public InputStream httpSrv_In = null;
    public OutputStream httpSrv_Out = null;
    public int soTimeout = 0;

    public HttpProxyServer() {
        this.request.initRequest();
        this.response = new HttpProxyResponse(this);
        this.idleTimeout = new TimeoutTime(TimoutNotificator.getInstance());
        this.idleTimeout.setTimeout(300000L);
        TimoutNotificator.getInstance().register(this);
        this.TRAFFIC_LOG = Logger.getLogger();
    }

    public HttpProxyServer(LoggerInterface trafficLogger, String clientID, Proxy chainedProxy, Set hostFilter, Set urlFilter, byte[] filterResponse) {
        this();
        this.TRAFFIC_LOG = trafficLogger;
        if (chainedProxy != null) {
            this.useProxy = true;
            this.chainedProxy = chainedProxy;
        }
        this.clientID = clientID;
        this.hostFilter = hostFilter;
        this.urlFilter = urlFilter;
        this.filterResponse = filterResponse;
    }

    @Override
    public OutputStream getOutputStream() {
        return this.request;
    }

    @Override
    public InputStream getInputStream() {
        return this.response;
    }

    private String getURL4LogEntry() {
        String urlLogEntry = this.getURL(this.reqHeader);
        int idx = urlLogEntry.indexOf(63);
        if (idx != -1) {
            urlLogEntry = urlLogEntry.substring(0, idx);
        }
        return urlLogEntry;
    }

    public void requestHeaderReceived(byte[] headerBytes) {
        boolean filtered;
        try {
            this.reqHeader = new HttpHeader(new ByteArrayInputStream(headerBytes), 1);
            if (this.TRAFFIC_LOG != null) {
                this.urlLogEntry = this.getURL4LogEntry();
            }
        }
        catch (IOException e1) {
            this.current_status = (byte)5;
            this.response.startErrorResponse("HTTP/1.1 400 Bad Request!", "Request Parsing failed!\r\n" + e1.getMessage());
            return;
        }
        boolean ssl = this.reqHeader.tunnelMode;
        long reqContentLength = this.reqHeader.getContentLength();
        boolean chunkedReq = this.reqHeader.chunkedTransfer();
        this.current_status = (byte)2;
        try {
            filtered = this.contactServer();
        }
        catch (IOException e) {
            this.current_status = (byte)5;
            this.response.startErrorResponse("HTTP/1.1 503 Server Connect Failed!", "Server Connect Failed!\n" + e.getMessage());
            return;
        }
        try {
            if (!ssl) {
                this.current_status = (byte)3;
                this.sendRequestHeader();
                this.reqHeader = null;
                if (reqContentLength > 0L || chunkedReq) {
                    this.current_status = (byte)4;
                    this.request.initRequestBody(reqContentLength, chunkedReq);
                    this.request.notifyAll();
                } else {
                    this.requestComplete();
                }
            } else {
                if (this.useProxy) {
                    this.sendRequestHeader();
                    this.httpSrv_Out.flush();
                }
                HttpHeader tunnelResponse = null;
                this.current_status = (byte)5;
                if (this.useProxy || filtered) {
                    tunnelResponse = new HttpHeader(this.httpSrv_In, 2);
                }
                this.response.startResponse(tunnelResponse, this.httpSrv_In, true);
                this.request.startSSL();
            }
        }
        catch (IOException e2) {
            this.current_status = (byte)5;
            this.response.startErrorResponse("HTTP/1.1 500 Server Error!", "Request Sent failed!\n" + e2.getMessage());
            return;
        }
    }

    public void requestComplete() throws IOException {
        this.httpSrv_Out.flush();
        this.current_status = (byte)5;
        this.response.startResponse(null, this.httpSrv_In, false);
    }

    private void sendRequestHeader() throws IOException {
        this.httpSrv_Out.write(this.reqHeader.getServerRequestHeader(this.useProxy).getBytes());
        this.httpSrv_Out.flush();
    }

    private String getURL(HttpHeader reqHeader) {
        String url = reqHeader.tunnelMode ? (reqHeader.remote_port != 443 ? "https://" + reqHeader.hostEntry + "/" : "https://" + reqHeader.remote_host_name + "/") : (reqHeader.remote_port != 80 ? "http://" + reqHeader.hostEntry + reqHeader.url : "http://" + reqHeader.remote_host_name + reqHeader.url);
        return url;
    }

    private boolean filter(HttpHeader reqHeader) {
        if (this.hostFilter != null && this.hostFilter.contains(reqHeader.remote_host_name)) {
            Logger.getLogger().logLine("FILTERED:" + reqHeader.remote_host_name);
            return true;
        }
        if (this.urlFilter != null) {
            String url = this.getURL(reqHeader);
            if (this.urlFilter.contains(url)) {
                Logger.getLogger().logLine("FILTERED:" + url);
                return true;
            }
            return false;
        }
        return false;
    }

    protected boolean contactServer() throws IOException {
        boolean filter = this.filter(this.reqHeader);
        if (filter) {
            this.httpSrv_Out = new NullOutput();
            this.httpSrv_In = this.reqHeader.tunnelMode ? new ByteArrayInputStream(TUNNEL_RQ_FILTER_RESP) : new ByteArrayInputStream(this.filterResponse);
        } else {
            Logger.getLogger().logLine("REQUESTING:" + this.reqHeader.remote_host_name + " on port " + this.reqHeader.remote_port);
            this.httpServer = this.useProxy ? Connection.connect((InetSocketAddress)this.chainedProxy.address(), 120000) : Connection.connect(this.reqHeader.remote_host_name, this.reqHeader.remote_port, 120000);
            this.httpSrv_In = new BufferedInputStream(this.httpServer.getInputStream());
            this.httpSrv_Out = new BufferedOutputStream(this.httpServer.getOutputStream());
            this.setHttpServerReadTimeOut(this.soTimeout);
        }
        return filter;
    }

    protected synchronized void releaseServer(boolean reuse) {
        if (this.httpSrv_In == null) {
            return;
        }
        if (this.httpServer != null && this.TRAFFIC_LOG != null) {
            long[] traffic = this.httpServer.getTraffic();
            this.TRAFFIC_LOG.logLine(String.valueOf(DateRetriever.getDateString()) + ", " + this.clientID + ", " + this.httpServer.getDestination() + ", " + traffic[0] + ", " + traffic[1] + ", " + this.urlLogEntry);
        } else if (this.TRAFFIC_LOG != null) {
            this.TRAFFIC_LOG.logLine(String.valueOf(DateRetriever.getDateString()) + ", " + this.clientID + ", <no connection / filtered>, 0, 0, " + this.urlLogEntry);
        }
        if (this.httpServer != null) {
            this.httpServer.release(reuse);
        }
        this.httpServer = null;
        this.httpSrv_In = null;
        this.httpSrv_Out = null;
    }

    public void responseFinished(boolean reuseServer) {
        this.releaseServer(reuseServer);
        this.urlLogEntry = null;
        this.request.initRequest();
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        TimoutNotificator.getInstance().unregister(this);
        this.closed = true;
        if (this.httpServer != null) {
            this.releaseServer(false);
        }
        this.response.closeResponse();
        this.request.closeRequest();
    }

    @Override
    public void setSoTimeout(int timeout) throws SocketException {
        this.soTimeout = timeout;
        this.setHttpServerReadTimeOut(timeout);
    }

    protected void setHttpServerReadTimeOut(int to) throws SocketException {
        if (this.httpServer != null) {
            this.httpServer.setSoTimeout(to);
        }
    }

    @Override
    public void shutdownInput() throws IOException {
    }

    @Override
    public void shutdownOutput() throws IOException {
    }

    @Override
    public void timeoutNotification() {
        this.close();
    }

    @Override
    public long getTimoutTime() {
        return this.idleTimeout.getTimeout();
    }

    public void resetIdleTimeOut() {
        this.idleTimeout.setTimeout(300000L);
    }

    private class NullOutput
    extends OutputStream {
        private NullOutput() {
        }

        @Override
        public void write(int arg0) throws IOException {
        }
    }
}

