/*
 * Decompiled with CFR 0.152.
 */
package util.http;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Vector;
import util.Utils;

public class HttpHeader {
    private static final String[] reqparamSequence = new String[]{"Cache-Control", "Connection", "Date", "Pragma", "Trailer", "Transfer-Encoding", "Upgrade", "Via", "Warning", "Accept", "Accept-Charset", "Accept-Encoding", "Accept-Language", "Authorization", "Expect", "From", "Host", "If-Match", "If-Modified-Since", "If-None-Match", "If-Range", "If-Unmodified-Since", "Max-Forwards", "Proxy-Authorization", "Range", "Referer", "TE", "User-Agent", "Allow", "Content-Encoding", "Content-Language", "Content-Length", "Content-Location", "Content-MD5", "Content-Range", "Content-Type", "Expires", "Last-Modified", "extension-header"};
    public static final int REQUEST_HEADER = 1;
    public static final int RESPONSE_HEADER = 2;
    public String remote_host_name = "";
    public String hostEntry;
    public String url;
    public String method;
    public int remote_port = 0;
    public boolean tunnelMode = false;
    public int responsecode = -1;
    private String _first;
    private Vector _keys = null;
    private HashMap _mapping = null;
    private int type;

    public HttpHeader(InputStream in, int type) throws IOException {
        this._keys = new Vector();
        this._mapping = new HashMap();
        if (type != 1 && type != 2) {
            throw new IOException("INVALID TYPE!");
        }
        this.type = type;
        this._first = Utils.readLineFromStream(in, true);
        if (type == 1) {
            this.parseURI();
            if (this.hostEntry != null) {
                this.setValue("Host", this.hostEntry);
            }
        } else {
            if (this._first.length() < 12) {
                throw new IOException("Invalid Response Header:" + this._first);
            }
            String _first12 = this._first.substring(0, 12).toLowerCase();
            if (_first12.startsWith("http/")) {
                try {
                    this.responsecode = Integer.parseInt(this._first.substring(9, 12));
                    this._first = "HTTP/1.1 " + this.responsecode + this._first.substring(12);
                }
                catch (Exception e) {
                    throw new IOException(e.getMessage());
                }
            } else {
                throw new IOException("Invalid Response Header:" + this._first);
            }
        }
        String next = Utils.readLineFromStream(in, true);
        while (!next.equals("")) {
            String value;
            String key;
            int index = next.indexOf(": ");
            if (index == -1) {
                index = next.indexOf(":");
                if (index == -1) {
                    throw new IOException("Invalid header:" + next);
                }
                key = next.substring(0, index).trim();
                value = next.substring(index + 1).trim();
            } else {
                key = next.substring(0, index).trim();
                value = next.substring(index + 2).trim();
            }
            String keyUpper = key.toUpperCase();
            String curVal = (String)this._mapping.get(keyUpper);
            if (curVal == null) {
                this._keys.add(key);
                this._mapping.put(keyUpper, value);
            } else if (!keyUpper.equals("CONTENT-LENGTH")) {
                if (!keyUpper.equals("HOST")) {
                    this._mapping.put(keyUpper, String.valueOf(curVal) + "_,_" + value);
                }
            } else if (!curVal.equals(value)) {
                throw new IOException("Invalid Header! Duplicated Content-Length with different values:" + curVal + "<>" + value + "!");
            }
            next = Utils.readLineFromStream(in, true);
        }
        if (this.hostEntry == null && type == 1) {
            this.hostEntry = this.getValue("Host");
            if (this.hostEntry != null) {
                this.parseHostEntry();
            } else {
                throw new IOException("Bad Request - No Host specified!");
            }
        }
    }

    public HttpHeader(int type) {
        this._keys = new Vector();
        this._mapping = new HashMap();
        this.type = type;
    }

    public HttpHeader(String headerStr, int type) throws IOException {
        this(new ByteArrayInputStream(headerStr.getBytes()), type);
    }

    private HttpHeader() {
    }

    public HttpHeader clone() {
        HttpHeader clone = new HttpHeader();
        clone.remote_host_name = this.remote_host_name;
        clone.hostEntry = this.hostEntry;
        clone.url = this.url;
        clone.method = this.method;
        clone.remote_port = this.remote_port;
        clone.tunnelMode = this.tunnelMode;
        clone.responsecode = this.responsecode;
        clone._first = this._first;
        clone._keys = (Vector)this._keys.clone();
        clone._mapping = (HashMap)this._mapping.clone();
        clone.type = this.type;
        return clone;
    }

    public void setRequest(String request) throws IOException {
        this._first = request;
        this.parseURI();
        this.setValue("Host", this.hostEntry);
    }

    public String getResponseMessage() {
        if (this.type != 2) {
            throw new IllegalStateException(this + " is not a ResonseHeader!");
        }
        return this._first;
    }

    public int getResponseCode() {
        if (this.type != 2) {
            throw new IllegalStateException(this + " is not a ResonseHeader!");
        }
        return this.responsecode;
    }

    public String getValue(String key) {
        return (String)this._mapping.get(key.toUpperCase());
    }

    public void appendValueToHeaderString(StringBuffer headerString, String key, String value) {
        String[] tokens = value.split("_,_");
        int i = 0;
        while (i < tokens.length) {
            headerString.append(String.valueOf(key) + ": " + tokens[i] + "\r\n");
            ++i;
        }
    }

    public String getHeaderString() {
        StringBuffer headerString = new StringBuffer(String.valueOf(this._first) + "\r\n");
        for (String key : this._keys) {
            String value = (String)this._mapping.get(key.toUpperCase());
            this.appendValueToHeaderString(headerString, key, value);
        }
        headerString.append("\r\n");
        return headerString.toString();
    }

    public String getServerRequestHeader(boolean useProxy) {
        String value;
        String firstLn = this._first;
        if (!this.tunnelMode) {
            firstLn = useProxy ? String.valueOf(this.method) + " http://" + this.hostEntry + this.url + " HTTP/1.1" : String.valueOf(this.method) + " " + this.url + " HTTP/1.1";
        }
        StringBuffer headerString = new StringBuffer(String.valueOf(firstLn) + "\r\n");
        HashMap mapping = (HashMap)this._mapping.clone();
        int i = 0;
        while (i < reqparamSequence.length) {
            String key = reqparamSequence[i];
            value = (String)mapping.remove(key.toUpperCase());
            if (value != null) {
                if (useProxy && key.toUpperCase().equals("CONNECTION")) {
                    key = "Proxy-Connection";
                }
                if (value.length() > 0) {
                    this.appendValueToHeaderString(headerString, key, value);
                } else {
                    headerString.append(String.valueOf(key) + ":\r\n");
                }
            }
            ++i;
        }
        for (String key : this._keys) {
            value = (String)mapping.remove(key.toUpperCase());
            if (value == null) continue;
            if (!useProxy && key.toUpperCase().equals("PROXY-CONNECTION")) {
                key = "Connection";
            }
            if (value.length() > 0) {
                this.appendValueToHeaderString(headerString, key, value);
                continue;
            }
            headerString.append(String.valueOf(key) + ":\r\n");
        }
        headerString.append("\r\n");
        return headerString.toString();
    }

    public String getServerRequestHeader() {
        return this.getServerRequestHeader(false);
    }

    public long getContentLength() {
        if (this.responsecode == 304 || this.responsecode == 204) {
            return 0L;
        }
        String val = this.getValue("Content-Length");
        if (val != null) {
            return Long.parseLong(val);
        }
        return -1L;
    }

    public boolean getConnectionClose() {
        String value = this.getValue("Connection");
        if (value == null) {
            return false;
        }
        return value.equalsIgnoreCase("close");
    }

    public boolean chunkedTransfer() {
        String val = this.getValue("Transfer-Encoding");
        if (val != null) {
            return val.equalsIgnoreCase("chunked");
        }
        return false;
    }

    public void setValue(String key, String value) {
        if (this.getValue(key) == null) {
            this._keys.add(key);
        }
        this._mapping.put(key.toUpperCase(), value);
    }

    public void setHostEntry(String hostEntry) throws IOException {
        this.hostEntry = hostEntry;
        this.setValue("Host", hostEntry);
        this.parseHostEntry();
    }

    private void parseURI() throws IOException {
        int idx = this._first.indexOf(32);
        int idx2 = this._first.lastIndexOf(32);
        if (idx == -1 || idx == idx2) {
            throw new IOException("Bad Request:" + this._first);
        }
        this.method = this._first.substring(0, idx);
        this.url = this._first.substring(idx + 1, idx2);
        this.tunnelMode = this.method.equalsIgnoreCase("CONNECT");
        if (!this.tunnelMode) {
            if (this.url.length() >= 7 && this.url.substring(0, 7).equalsIgnoreCase("http://")) {
                this.url = this.url.substring(7);
                idx = this.url.indexOf(47);
                if (idx == -1) {
                    idx = this.url.length();
                }
                this.hostEntry = this.url.substring(0, idx);
                this.url = idx == this.url.length() ? "/" : this.url.substring(idx);
            }
        } else {
            this.hostEntry = this.url;
        }
        if (this.hostEntry != null) {
            this.parseHostEntry();
        }
    }

    private void parseHostEntry() throws IOException {
        this.remote_port = 80;
        this.remote_host_name = this.hostEntry;
        int idx = this.hostEntry.lastIndexOf(":");
        if (idx != -1 && !this.hostEntry.endsWith("]")) {
            try {
                this.remote_port = Integer.parseInt(this.hostEntry.substring(idx + 1));
            }
            catch (NumberFormatException nfe) {
                throw new IOException("Bad Request - Cannot parse port to int:" + this._first);
            }
            this.remote_host_name = this.hostEntry.substring(0, idx);
        }
        if (this.remote_host_name.startsWith("[") && this.remote_host_name.endsWith("]")) {
            this.remote_host_name = this.remote_host_name.substring(1, this.remote_host_name.length() - 1);
        }
    }
}

