/*
 * Decompiled with CFR 0.152.
 */
package util.conpool;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Vector;
import util.Logger;
import util.TimeoutListener;
import util.TimeoutTime;
import util.TimoutNotificator;
import util.conpool.PooledConnectionInputStream;
import util.conpool.PooledConnectionOutputStream;

public class Connection
implements TimeoutListener {
    private Socket socket = null;
    private InputStream socketIn;
    private OutputStream socketOut;
    private PooledConnectionInputStream in;
    private PooledConnectionOutputStream out;
    String poolKey;
    TimeoutTime timeout;
    boolean aquired = true;
    boolean valid = true;
    private static HashMap connPooled = new HashMap();
    private static HashSet connAquired = new HashSet();
    private static int POOLTIMEOUT_SECONDS = 300;
    private static TimoutNotificator toNotify = TimoutNotificator.getNewInstance();

    private Connection(String host, int port, int conTimeout) throws IOException {
        InetAddress adr = InetAddress.getByName(host);
        InetSocketAddress sadr = new InetSocketAddress(adr, port);
        this.poolKey = String.valueOf(host) + ":" + port;
        this.initConnection(sadr, conTimeout);
        this.timeout = new TimeoutTime(toNotify);
    }

    private Connection(InetSocketAddress sadr, int conTimeout) throws IOException {
        this.poolKey = String.valueOf(sadr.getAddress().getHostAddress()) + ":" + sadr.getPort();
        this.initConnection(sadr, conTimeout);
        this.timeout = new TimeoutTime(toNotify);
    }

    private void initConnection(InetSocketAddress sadr, int conTimeout) throws IOException {
        this.socket = new Socket();
        if (conTimeout > 0) {
            this.socket.connect(sadr, conTimeout);
        } else {
            this.socket.connect(sadr);
        }
        this.socketIn = this.socket.getInputStream();
        this.socketOut = this.socket.getOutputStream();
    }

    public static Connection connect(InetSocketAddress sadr, int conTimeout) throws IOException {
        Connection con = Connection.poolRemove(sadr.getAddress().getHostAddress(), sadr.getPort());
        if (con == null) {
            con = new Connection(sadr, conTimeout);
        }
        con.initStreams();
        connAquired.add(con);
        return con;
    }

    public static Connection connect(InetSocketAddress address) throws IOException {
        return Connection.connect(address, -1);
    }

    public static Connection connect(String host, int port, int conTimeout) throws IOException {
        Connection con = Connection.poolRemove(host, port);
        if (con == null) {
            con = new Connection(host, port, conTimeout);
        }
        con.initStreams();
        connAquired.add(con);
        return con;
    }

    public static Connection connect(String host, int port) throws IOException {
        return Connection.connect(host, port, -1);
    }

    public static void setPoolTimeoutSeconds(int secs) {
        POOLTIMEOUT_SECONDS = secs;
    }

    private void initStreams() {
        this.in = new PooledConnectionInputStream(this.socketIn);
        this.out = new PooledConnectionOutputStream(this.socketOut);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void invalidate() {
        HashMap hashMap = connPooled;
        synchronized (hashMap) {
            Vector[] destinations = connPooled.values().toArray(new Vector[0]);
            int i = 0;
            while (i < destinations.length) {
                Connection[] cons = destinations[i].toArray(new Connection[0]);
                int ii = 0;
                while (ii < cons.length) {
                    cons[ii].release(false);
                    ++ii;
                }
                ++i;
            }
            Connection[] cons = connAquired.toArray(new Connection[0]);
            int i2 = 0;
            while (i2 < cons.length) {
                cons[i2].release(false);
                ++i2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void poolReuse(Connection con) {
        HashMap hashMap = connPooled;
        synchronized (hashMap) {
            if (!con.aquired) {
                throw new IllegalStateException("Inconsistwent Connection State - Cannot release non aquired connection");
            }
            con.aquired = false;
            Vector<Connection> hostCons = (Vector<Connection>)connPooled.get(con.poolKey);
            if (hostCons == null) {
                hostCons = new Vector<Connection>();
                connPooled.put(con.poolKey, hostCons);
            }
            toNotify.register(con);
            con.timeout.setTimeout(POOLTIMEOUT_SECONDS * 1000);
            hostCons.add(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Connection poolRemove(String host, int port) {
        String key = String.valueOf(host) + ":" + port;
        HashMap hashMap = connPooled;
        synchronized (hashMap) {
            Vector hostCons;
            block7: {
                hostCons = (Vector)connPooled.get(key);
                if (hostCons != null) break block7;
                return null;
            }
            boolean found = false;
            Connection con = null;
            while (!found && !hostCons.isEmpty()) {
                con = (Connection)hostCons.remove(hostCons.size() - 1);
                if (con.aquired) {
                    throw new IllegalStateException("Inconsistent Connection State - Cannot take already aquired connection from pool!");
                }
                con.aquired = true;
                toNotify.unregister(con);
                found = con.isAlive();
                if (found) continue;
                con.release(false);
                con = null;
            }
            if (hostCons.isEmpty()) {
                connPooled.remove(key);
            }
            return con;
        }
    }

    private boolean isAlive() {
        try {
            this.socket.setSoTimeout(1);
            int r = this.socketIn.read();
            if (r != -1) {
                int avail = this.socketIn.available();
                byte[] buf = new byte[Math.max(avail, 10240)];
                this.socketIn.read(buf);
                String data = String.valueOf((char)r) + new String(buf);
                Logger.getLogger().logException(new IllegalStateException("Connection.isAlive received data on pooled connection:\r\n" + data));
            }
            return false;
        }
        catch (SocketTimeoutException to) {
            try {
                this.socket.setSoTimeout(0);
                return true;
            }
            catch (SocketException e) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
    }

    public OutputStream getOutputStream() {
        return this.out;
    }

    public InputStream getInputStream() {
        return this.in;
    }

    public void release(boolean reuse) {
        if (!this.valid) {
            return;
        }
        connAquired.remove(this);
        if (reuse) {
            this.in.invalidate();
            this.out.invalidate();
            try {
                this.socket.setSoTimeout(0);
            }
            catch (SocketException e) {
                this.release(false);
                return;
            }
            Connection.poolReuse(this);
        } else {
            try {
                this.valid = false;
                this.socket.shutdownOutput();
                this.socket.shutdownInput();
                this.socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void setSoTimeout(int millis) throws SocketException {
        this.socket.setSoTimeout(millis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void timeoutNotification() {
        boolean found = false;
        HashMap hashMap = connPooled;
        synchronized (hashMap) {
            Vector hostCons = (Vector)connPooled.get(this.poolKey);
            if (hostCons == null) {
                return;
            }
            found = hostCons.remove(this);
            if (hostCons.isEmpty()) {
                connPooled.remove(this.poolKey);
            }
        }
        if (found) {
            this.release(false);
        }
    }

    @Override
    public long getTimoutTime() {
        return this.timeout.getTimeout();
    }

    public long[] getTraffic() {
        if (!this.aquired) {
            throw new IllegalStateException("Inconsistent Connection State - Connection is not aquired!");
        }
        return new long[]{this.in.getTraffic(), this.out.getTraffic()};
    }

    public String getDestination() {
        return this.poolKey;
    }
}

