/*
 * Decompiled with CFR 0.152.
 */
package proxy;

import httpproxy.HttpProxyServer;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.net.URLConnection;
import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import proxy.BlockedHosts;
import proxy.BlockedUrls;
import proxy.Transmitter;
import util.ExecutionEnvironment;
import util.FileLogger;
import util.Logger;
import util.LoggerInterface;

public class HttpProxy
implements Runnable,
LoggerInterface {
    public static final String VERSION = "1.57.5";
    public static boolean debug;
    public static String WORKDIR;
    private static String filterReloadURL;
    private static String filterhostfile;
    private static long filterReloadIntervalDays;
    private static long nextReload;
    private static int okCacheSize;
    private static int filterListCacheSize;
    private static boolean reloadUrlChanged;
    private static boolean validIndex;
    private static LoggerInterface TRAFFIC_LOG;
    private static BlockedHosts hostFilter;
    private static BlockedUrls urlFilter;
    private static Hashtable hostsFilterOverRule;
    private static byte[] filterResponse;
    private static Proxy chainedProxy;
    private static HttpProxy MAINLOOP;
    private static HashSet openConnections;
    private Socket client = null;
    private Socket server = null;
    private ServerSocket acceptSocket;
    private boolean serverStopped = false;
    private boolean listenerStopped = false;
    private boolean closed = false;

    static {
        WORKDIR = "";
        okCacheSize = 500;
        filterListCacheSize = 500;
        hostFilter = null;
        urlFilter = null;
        hostsFilterOverRule = null;
    }

    public HttpProxy() {
    }

    public HttpProxy(Socket clientSocket) {
        this.client = clientSocket;
    }

    public void close(Socket s) {
        try {
            s.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void cleanUp(int code, String transmitter) {
        if (this.closed) {
            return;
        }
        this.close(this.server);
        this.close(this.client);
        this.closed = true;
        HashSet hashSet = openConnections;
        synchronized (hashSet) {
            openConnections.remove(this.server);
        }
        Logger.getLogger().logLine("HTTP proxy: " + transmitter + " closed!");
    }

    public boolean go() {
        try {
            this.server = this.connectServer(this.client.getInetAddress().getHostAddress(), true);
        }
        catch (Exception e) {
            Logger.getLogger().logLine(e.toString());
            return false;
        }
        Transmitter c = new Transmitter(this.client, this.server, this, "Client->Server");
        if (!c.start()) {
            this.close(this.server);
            return false;
        }
        Transmitter s = new Transmitter(this.server, this.client, this, "Server->Client");
        if (!s.start()) {
            this.close(this.server);
            return false;
        }
        return true;
    }

    public Socket connectServer(String clientID) throws Exception {
        return this.connectServer(clientID, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Socket connectServer(String clientID, boolean internal) throws Exception {
        HttpProxyServer con = new HttpProxyServer(TRAFFIC_LOG, clientID, chainedProxy, hostFilter, urlFilter, filterResponse);
        if (internal) {
            HashSet hashSet = openConnections;
            synchronized (hashSet) {
                openConnections.add(con);
            }
        }
        Logger.getLogger().logLine("HTTP proxy: New connection...");
        return con;
    }

    ServerSocket openListener(boolean localOnly, int port) throws Exception {
        InetAddress adr = null;
        if (localOnly) {
            adr = InetAddress.getByName("127.0.0.1");
        }
        return new ServerSocket(port, 0, adr);
    }

    public HttpProxy createProxy(Socket clientSocket) {
        return new HttpProxy(clientSocket);
    }

    @Override
    public void run() {
        if (this == MAINLOOP) {
            this.initAndRunListenerLoop();
        } else if (!this.go()) {
            try {
                this.client.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void triggerUpdateFilter() {
        if (filterReloadURL != null) {
            HttpProxy httpProxy = MAINLOOP;
            synchronized (httpProxy) {
                nextReload = 0L;
                MAINLOOP.notifyAll();
            }
        } else {
            Logger.getLogger().logLine("HTTP proxy: Setting 'filterAutoUpdateURL' not configured - cannot update filter!");
        }
    }

    private void updateFilter() throws IOException {
        try {
            ExecutionEnvironment.getEnvironment().wakeLock();
            FileOutputStream out = new FileOutputStream(String.valueOf(WORKDIR) + filterhostfile + ".tmp");
            ((OutputStream)out).write(("# Hosts Filter File from " + filterReloadURL + "\n").getBytes());
            ((OutputStream)out).write(("# Last Update:" + new Date() + "\n").getBytes());
            StringTokenizer urlTokens = new StringTokenizer(filterReloadURL, ";");
            int urlCnt = urlTokens.countTokens();
            int i = 0;
            while (i < urlCnt) {
                String urlStr = urlTokens.nextToken().trim();
                if (!urlStr.equals("")) {
                    int r;
                    Logger.getLogger().logLine("HTTP proxy: Updating filter from " + urlStr + "...");
                    ((OutputStream)out).write(("\n# Load Filter from URL:" + urlStr + "\n").getBytes());
                    URL url = new URL(urlStr);
                    URLConnection con = chainedProxy != null ? url.openConnection(chainedProxy) : url.openConnection(Proxy.NO_PROXY);
                    con.setConnectTimeout(120000);
                    con.setReadTimeout(120000);
                    InputStream in = con.getInputStream();
                    byte[] buf = new byte[10000];
                    int received = 0;
                    int delta = 100000;
                    while ((r = in.read(buf)) != -1) {
                        ((OutputStream)out).write(buf, 0, r);
                        if ((received += r) <= delta) continue;
                        Logger.getLogger().logLine("Bytes received:" + received);
                        delta += 100000;
                    }
                }
                ++i;
            }
            Logger.getLogger().logLine("Updating filter completed!");
            out.flush();
            ((OutputStream)out).close();
            new File(String.valueOf(WORKDIR) + filterhostfile).delete();
            new File(String.valueOf(WORKDIR) + filterhostfile + ".tmp").renameTo(new File(String.valueOf(WORKDIR) + filterhostfile));
            this.updateFilterURLinConfFile(filterReloadURL);
        }
        finally {
            ExecutionEnvironment.getEnvironment().releaseWakeLock();
        }
    }

    private void reloadFilter() throws IOException {
        block19: {
            try {
                ExecutionEnvironment.getEnvironment().wakeLock();
                File filterfile = new File(String.valueOf(WORKDIR) + filterhostfile);
                nextReload = filterfile.exists() && !reloadUrlChanged ? filterReloadIntervalDays * 24L * 60L * 60L * 1000L + filterfile.lastModified() : 0L;
                File indexFile = new File(String.valueOf(WORKDIR) + filterhostfile + ".idx");
                if (indexFile.exists() && validIndex && BlockedHosts.checkIndexVersion(indexFile.getAbsolutePath())) {
                    hostFilter = BlockedHosts.loadPersistedIndex(indexFile.getAbsolutePath(), false, okCacheSize, filterListCacheSize, hostsFilterOverRule);
                    break block19;
                }
                if (!filterfile.exists()) break block19;
                Logger.getLogger().logLine("Reading filter file and building index...!");
                BufferedReader fin = new BufferedReader(new InputStreamReader(new FileInputStream(filterfile)));
                String entry = null;
                int size = 0;
                BlockedHosts hostFilterSet = new BlockedHosts(Math.max(1, (int)(filterfile.length() / 30L)), okCacheSize, filterListCacheSize, hostsFilterOverRule);
                int cutFirst = 0;
                boolean first = true;
                while ((entry = fin.readLine()) != null) {
                    if (entry.startsWith("# Load Filter from URL:")) {
                        first = true;
                    }
                    if (entry.startsWith("#") || entry.equals("") || entry.startsWith("::1")) continue;
                    if (first) {
                        if (entry.startsWith("127.0.0.1 ") || entry.startsWith("127.0.0.1\t")) {
                            cutFirst = 10;
                            Logger.getLogger().logLine("Filter file is in 'Hosts' format!");
                        } else {
                            cutFirst = 0;
                        }
                        first = false;
                    }
                    hostFilterSet.prepareInsert(entry.substring(cutFirst).trim());
                    ++size;
                }
                fin.close();
                hostFilterSet.finalPrepare();
                Logger.getLogger().logLine("Building index for " + size + " entries...!");
                fin = new BufferedReader(new InputStreamReader(new FileInputStream(filterfile)));
                int processed = 0;
                int uniqueEntries = 0;
                while ((entry = fin.readLine()) != null) {
                    if (entry.startsWith("# Load Filter from URL:")) {
                        first = true;
                    }
                    if (entry.startsWith("#") || entry.equals("") || entry.startsWith("::1")) continue;
                    if (first) {
                        cutFirst = entry.startsWith("127.0.0.1 ") || entry.startsWith("127.0.0.1\t") ? 10 : 0;
                        first = false;
                    }
                    if (hostFilterSet.add(entry.substring(cutFirst).trim())) {
                        ++uniqueEntries;
                    }
                    if (++processed % 10000 != 0) continue;
                    Logger.getLogger().logLine("Building index for " + processed + "/" + size + " entries completed!");
                }
                fin.close();
                try {
                    if (hostFilter != null) {
                        hostFilter.lock(1);
                    }
                    Logger.getLogger().logLine("Persisting index for " + size + " entries...!");
                    Logger.getLogger().logLine("Index contains " + uniqueEntries + " unique entries!");
                    hostFilterSet.persist(String.valueOf(WORKDIR) + filterhostfile + ".idx");
                    hostFilterSet.clear();
                    hostFilterSet = BlockedHosts.loadPersistedIndex(indexFile.getAbsolutePath(), false, okCacheSize, filterListCacheSize, hostsFilterOverRule);
                    if (hostFilter != null) {
                        hostFilter.migrateTo(hostFilterSet);
                    } else {
                        hostFilter = hostFilterSet;
                    }
                }
                finally {
                    hostFilter.unLock(1);
                }
                validIndex = true;
                Logger.getLogger().logLine("Processing new filter file completed!");
            }
            finally {
                ExecutionEnvironment.getEnvironment().releaseWakeLock();
            }
        }
    }

    private void updateFilterURLinConfFile(String url) {
        try {
            String ln;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(String.valueOf(WORKDIR) + "httpproxy.conf")));
            boolean found = false;
            while ((ln = reader.readLine()) != null) {
                if (ln.startsWith("previousAutoUpdateURL")) {
                    found = true;
                    ln = "previousAutoUpdateURL = " + url;
                }
                out.write((String.valueOf(ln) + "\r\n").getBytes());
            }
            if (!found) {
                out.write(("previousAutoUpdateURL = " + url + "\r\n").getBytes());
            }
            out.flush();
            reader.close();
            FileOutputStream fout = new FileOutputStream(String.valueOf(WORKDIR) + "httpproxy.conf");
            ((OutputStream)fout).write(out.toByteArray());
            fout.flush();
            ((OutputStream)fout).close();
        }
        catch (IOException e) {
            Logger.getLogger().logException(e);
        }
    }

    private void initStatics() {
        debug = false;
        filterReloadURL = null;
        filterhostfile = null;
        filterReloadIntervalDays = 4L;
        nextReload = 0L;
        reloadUrlChanged = false;
        validIndex = true;
        hostFilter = null;
        hostsFilterOverRule = null;
        filterResponse = null;
        chainedProxy = null;
        MAINLOOP = null;
        openConnections = new HashSet();
    }

    public void init() throws Exception {
        String filterUrlfile;
        boolean filterEnabled = false;
        Logger.getLogger().logLine("***Initializing PersonalHttpProxy Version 1.57.5!***");
        Properties props = new Properties();
        FileInputStream in = new FileInputStream(String.valueOf(WORKDIR) + "httpproxy.conf");
        props.load(in);
        in.close();
        try {
            if (props.getProperty("enableTrafficLog", "true").equalsIgnoreCase("true")) {
                TRAFFIC_LOG = new FileLogger(String.valueOf(WORKDIR) + "log", props.getProperty("trafficLogName", "trafficlog"), Integer.parseInt(props.getProperty("trafficLogSize", "1048576").trim()), Integer.parseInt(props.getProperty("trafficLogSlotCount", "2").trim()), "timestamp, client, destination, bytes_received, bytes_sent, request");
                Logger.setLogger(TRAFFIC_LOG, "TrafficLogger");
            } else {
                TRAFFIC_LOG = null;
            }
        }
        catch (NumberFormatException nfe) {
            Logger.getLogger().logLine("Cannot parse log configuration!");
            throw nfe;
        }
        debug = Boolean.parseBoolean(props.getProperty("debug", "false"));
        int listenPort = Integer.parseInt(props.getProperty("listenPort", "8088"));
        if (listenPort >= 0) {
            boolean localOnly = Boolean.parseBoolean(props.getProperty("localOnly", "true"));
            if (localOnly) {
                Logger.getLogger().logLine("HTTP proxy: Only localhost connections to proxy will be accepted");
            } else {
                Logger.getLogger().logLine("HTTP proxy: Remote connections to proxy will be accepted");
            }
            this.acceptSocket = this.openListener(localOnly, listenPort);
            Logger.getLogger().logLine("HTTP proxy: Listening on port " + this.acceptSocket.getLocalPort() + "!");
        } else {
            Logger.getLogger().logLine("HTTP proxy: Listen port is disabled - no listener will be opened!");
        }
        String chainedProxyStr = props.getProperty("chainedProxyHost");
        int chainedProxyPort = Integer.parseInt(props.getProperty("chainedProxyPort", "-1"));
        if (chainedProxyStr != null) {
            InetAddress adr = InetAddress.getByName(chainedProxyStr);
            adr = InetAddress.getByAddress(chainedProxyStr, adr.getAddress());
            chainedProxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(adr, chainedProxyPort));
        }
        if ((filterUrlfile = props.getProperty("filterURLsFile")) != null) {
            filterEnabled = true;
            urlFilter = new BlockedUrls(okCacheSize, filterListCacheSize, null);
            urlFilter.appyList(new FileInputStream(String.valueOf(WORKDIR) + filterUrlfile));
        }
        if ((filterhostfile = props.getProperty("filterHostsFile")) != null) {
            filterEnabled = true;
            for (Map.Entry<Object, Object> entry : props.entrySet()) {
                String key = (String)entry.getKey();
                if (!key.startsWith("filter.")) continue;
                if (hostsFilterOverRule == null) {
                    hostsFilterOverRule = new Hashtable();
                }
                hostsFilterOverRule.put(key.substring(7), new Boolean(Boolean.parseBoolean(((String)entry.getValue()).trim())));
            }
            filterReloadURL = props.getProperty("filterAutoUpdateURL");
            filterReloadIntervalDays = Integer.parseInt(props.getProperty("reloadIntervalDays", "4"));
            String previousReloadURL = props.getProperty("previousAutoUpdateURL");
            if (filterReloadURL != null) {
                reloadUrlChanged = !filterReloadURL.equals(previousReloadURL);
            }
            this.reloadFilter();
            if (filterReloadURL != null) {
                Thread t = new Thread(new AutoFilterUpdater());
                t.setDaemon(true);
                t.start();
            }
        }
        if (filterEnabled) {
            File response;
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            bytes.write("HTTP/1.1 200 OK\r\n\r\n".getBytes());
            String filterResponsefile = props.getProperty("filterResponseFile");
            if (filterResponsefile != null && (response = new File(String.valueOf(WORKDIR) + filterResponsefile)).exists()) {
                FileInputStream responsein = new FileInputStream(response);
                byte[] buf = new byte[1024];
                int r = 0;
                while ((r = responsein.read(buf)) != -1) {
                    bytes.write(buf, 0, r);
                }
                responsein.close();
            }
            bytes.flush();
            filterResponse = bytes.toByteArray();
        }
    }

    public void initMainLoop(String[] args) throws Exception {
        this.initStatics();
        MAINLOOP = this;
        if (args.length > 0 && args[0].equals("-async")) {
            new Thread(this).start();
        } else {
            this.initAndRunListenerLoop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void initAndRunListenerLoop() {
        try {
            this.init();
            if (true) ** GOTO lbl24
        }
        catch (Exception e) {
            Logger.getLogger().logException(e);
            return;
        }
        do {
            try {
                client = this.acceptSocket.accept();
                proxy = this.createProxy(client);
                new Thread(proxy).start();
            }
            catch (Exception e0) {
                var2_4 = this;
                synchronized (var2_4) {
                    if (!this.serverStopped) {
                        Logger.getLogger().logLine("HTTP proxy: " + e0.toString());
                    }
                    this.listenerStopped = true;
                    this.notifyAll();
                }
            }
lbl24:
            // 3 sources

        } while (!this.serverStopped && this.acceptSocket != null);
        this.listenerStopped = true;
    }

    public synchronized void stop() {
        this.serverStopped = true;
        if (hostFilter != null) {
            hostFilter.clear();
        }
        if (urlFilter != null) {
            hostFilter.clear();
        }
        try {
            if (this.acceptSocket != null) {
                int port = this.acceptSocket.getLocalPort();
                this.acceptSocket.close();
                while (!this.listenerStopped) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        Logger.getLogger().logException(e);
                        return;
                    }
                }
                Logger.getLogger().logLine("HTTP proxy: Stopped listening on port " + port + "!");
            }
        }
        catch (IOException e) {
            Logger.getLogger().logException(e);
        }
        this.notifyAll();
        Object[] servers = openConnections.toArray();
        int i = 0;
        while (i < servers.length) {
            try {
                ((Socket)servers[i]).close();
            }
            catch (IOException ioe) {
                Logger.getLogger().logException(ioe);
            }
            ++i;
        }
        if (TRAFFIC_LOG != null) {
            TRAFFIC_LOG.closeLogger();
            Logger.removeLogger("TrafficLogger");
        }
    }

    public static void main(String[] args) {
        try {
            HttpProxy proxy = new HttpProxy();
            Logger.setLogger(proxy);
            proxy.initMainLoop(args);
        }
        catch (Exception e) {
            Logger.getLogger().logLine("HTTP proxy: Failed to start: " + e.getMessage());
        }
    }

    public static int openConnectionsCount() {
        if (openConnections != null) {
            return openConnections.size();
        }
        return 0;
    }

    @Override
    public void logLine(String txt) {
        System.out.println(txt);
    }

    @Override
    public void logException(Exception e) {
        e.printStackTrace(System.out);
    }

    @Override
    public void log(String txt) {
        System.out.print(txt);
    }

    @Override
    public void closeLogger() {
    }

    private class AutoFilterUpdater
    implements Runnable {
        private AutoFilterUpdater() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void waitUntilNextFilterReload() throws InterruptedException {
            HttpProxy httpProxy = MAINLOOP;
            synchronized (httpProxy) {
                while (nextReload > System.currentTimeMillis() && !HttpProxy.this.serverStopped) {
                    MAINLOOP.wait(10000L);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            HttpProxy httpProxy = MAINLOOP;
            synchronized (httpProxy) {
                int retry = 0;
                while (!HttpProxy.this.serverStopped) {
                    long waitTime;
                    Logger.getLogger().logLine("HTTP proxy: Next filter reload:" + new Date(nextReload));
                    try {
                        this.waitUntilNextFilterReload();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (HttpProxy.this.serverStopped) break;
                    try {
                        Logger.getLogger().logLine("HTTP proxy: Reloading hosts filter ...");
                        HttpProxy.this.updateFilter();
                        validIndex = false;
                        HttpProxy.this.reloadFilter();
                        Logger.getLogger().logLine("Reloading hosts filter ... completed!");
                        waitTime = filterReloadIntervalDays * 24L * 60L * 60L * 1000L;
                        nextReload = System.currentTimeMillis() + waitTime;
                        retry = 0;
                    }
                    catch (Exception e) {
                        Logger.getLogger().logLine("Cannot update hosts filter file!");
                        Logger.getLogger().logLine(e.getMessage());
                        if (retry < 10) {
                            waitTime = retry < 5 ? 60000L : 3600000L;
                            nextReload = System.currentTimeMillis() + waitTime;
                            Logger.getLogger().logLine("Retry at: " + new Date(nextReload));
                            ++retry;
                            continue;
                        }
                        Logger.getLogger().logLine("Giving up! Reload skipped!");
                        waitTime = filterReloadIntervalDays * 24L * 60L * 60L * 1000L;
                        nextReload = System.currentTimeMillis() + waitTime;
                        retry = 0;
                    }
                }
                Logger.getLogger().logLine("HTTP proxy: AutoFilterUpdater stopped!");
            }
        }
    }
}

